// $Id: glade--.cc,v 1.20 1998/10/09 11:33:30 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "TagStream.hh"
#include "Cxx.hh"
#include "Configuration.hh"
#include <unistd.h>
#include <cstdlib>
#include <sys/stat.h> // for makedir

struct Configuration Configuration;

int main(int argc,char **argv)
{  int opt;
   while ((opt=getopt(argc,argv,"d:m:Vgprs1A"))!=EOF) switch(opt)
   {  case 'd': Configuration.destination_directory=optarg;
         if (access(Configuration.destination_directory.c_str(),F_OK))
            if (mkdir(Configuration.destination_directory.c_str(),0755))
            {  perror(Configuration.destination_directory.c_str());
               return 2;
            }
         break;
      case 'm': Configuration.main_filename=optarg;
         break;
      case 'V': cout<< "glademm V"VERSION" (glade to Gtk-- converter)\n";
         return 0;
         break;
      case 'g': Configuration.debug=true;
         break;
      case 'p': Configuration.all_pointer=true;
         break;
      case 's': Configuration.sample_code=true;
         break;
      case '1': Configuration.gtk11=true;
         break;
      case 'r': Configuration.bare_bones=true;
         break;
      case 'A': Configuration.no_autoconf=true;
         break;
      case '?': usage:
      	 cerr << "USAGE: \n" << argv[0] << " [<option> ...] <inputfile>\n"
      	     "options:\n"
      	     "\t-d <destdir>\twrite files to different directory\n"
      	     "\t-m <name>\tmain and executable name\n"
      	     "\t-V \tprint version\n"
      	     "\t-g \tdebug tag structure\n"
      	     "\t-p \tuse pointer for all widgets\n"
      	     "\t-r \tonly create *_glade.cc/hh files\n"
      	     "\t-s \tinclude sample code into .cc file\n"
      	     "\t-1 \tuse gtk1.1 features (itemfactory)\n"
//	     "\t-M \tcreate menufactory\n"
//	     "\t-O \temit Gtkmm_OStream sample code\n"
	     "\t-A \tcreate bare Makefile (no autoconf/-make)\n"
      	     ;
         return 1;
   }
   if (argc-optind!=1) goto usage;
   Configuration.in_filename=argv[optind];
   
   Tag top("");
   {  TagStream t(Configuration.in_filename);
      t.load_project_file(&top);
   }
   Cxx *cxx=new Cxx(&top);
   cxx->WriteTags();
   delete cxx;
}
