// $Id: Writer.cc,v 1.18 1998/10/08 08:43:52 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Writer.hh"
#include <algo.h>
#include <cstring>

vector<string> Writer::_warned_types;

Writer::Writer(const Widget &w) throw()
	: widget(w), compound(w.isCompound())
{  string type(w.Class());
   if (!type.size()) { cerr<<"Writer without type\n"; index=maxindex; return; }
   for (index=0;writers[index].type;index++)
   {  if (type==writers[index].type) return;
   }
   if (find(_warned_types.begin(),_warned_types.end(),type)==_warned_types.end())
   {  cerr << "Warning: don't know how to handle Widget type \"" << type << "\"\n";
      _warned_types.push_back(type);
   }
   return;
}

void Writer::Declare(File &f) const
{  if (compound) StandardWriter::DeclareCompound(f,widget);
   else if (writers[index].declare) 
      (*(writers[index].declare))(f,widget); 
}

void Writer::DeclareNeeded(File &f) const
{  if (writers[index].declare_needed) 
   {  f << "\t";
      (*(writers[index].declare_needed))(f,widget); 
      f << "\n";
   }
}

void Writer::Construct(File &f,bool is_member) const
{  if (is_member && compound) 
      StandardWriter::ConstructCompound(f,widget,is_member);
   else if (writers[index].construct)
      (*(writers[index].construct))(f,widget,is_member); 
}

void Writer::ConstructPointer(File &f) const
{  if (compound) 
   {  f << "\t" << f.InstanceName(widget.Name()) << " = new ";
      StandardWriter::ConstructCompound(f,widget,false);
      f << ";\n";
   }
   else if (writers[index].construct_pointer)
      (*(writers[index].construct_pointer))(f,widget);
   else
   {  f << "\t" << f.InstanceName(widget.Name()) << " = new ";
      Construct(f,false);
      f << ";\n";
   }
}

void Writer::DestructPointer(File &f) const
{  if (compound) 
   {  f << "\tdelete " << f.InstanceName(widget.Name()) << ";\n";
   }
   else if (writers[index].destruct_pointer)
      (*(writers[index].destruct_pointer))(f,widget);
   else
   {  f << "\tdelete " << f.InstanceName(widget.Name()) << ";\n";
   }
}

bool Writer::NeedConstruct(bool is_member) const
{  if (is_member && widget.isPointer()) return false;
   else if (is_member && compound) 
      return StandardWriter::NeedConstructCompound(widget,is_member);
   else if (writers[index].need_construct)
      return (*(writers[index].need_construct))(widget,is_member); 
   return false;
}

void Writer::Customize(File &f,const string instance,bool nested) const
{  if (nested && compound) return;
   else if (writers[index].customize)
     (*(writers[index].customize))(f,widget,instance); 
}

void Writer::Derive(File &f) const
{  if (writers[index].derive)
     (*(writers[index].derive))(f,widget); 
}

bool Writer::IsDerived() const
{  if (writers[index].is_derived)
     return (*(writers[index].is_derived))(widget); 
   return false;
}

void Writer::Include(File &f) const
{  if (writers[index].include)
      (*(writers[index].include))(f,widget); 
}

bool Writer::IsBasic() const
{  if (writers[index].is_basic)
     return (*(writers[index].is_basic))(widget); 
   return true;
}

WriterType::Subwidget Writer::IsSubwidget(const Widget &child) const
{  if (writers[index].is_subwidget)
     return (*(writers[index].is_subwidget))(widget,child);
   return WriterType::no_Subwidgets;
}  

bool Writer::SampleCode(File &f,WriterType::CodePosition pos,const string misc) const
{  if (writers[index].sample_code)
   {  // cout << "f=" << f << " pos=" <<  pos << " misc=\"" << misc << "\"\n";
      (*(writers[index].sample_code))(f,widget,pos,misc);
   }
}

const string Writer::CallbackArgs(const string signal,string &rettype) const
{  rettype="void";
   if (writers[index].callback_args)
      return (*(writers[index].callback_args))(widget,signal,rettype);
   return "";
}
