// $Id: TagStream.cc,v 1.8 1998/09/25 13:33:51 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "TagStream.hh"
#include <cstring>
#include <unistd.h>

TagStream::TagStream(const string path) 
	: ifstream(path.c_str()), read_again(false), pointer(0),
	  end_pointer(0)
{  read(buffer,GB_BUFFER_SIZE);
   end_pointer=gcount();
}

void TagStream::load_project_file(Tag *top)
{  while (good() && next_tag(top));
}

bool TagStream::good()
{  return pointer<end_pointer;
}

char *TagStream::next_tag_pointer()
{  if (pointer>GB_BUFFER_SIZE/2 && end_pointer==GB_BUFFER_SIZE)
   {  memmove(buffer,buffer+pointer,GB_BUFFER_SIZE-pointer);
      end_pointer-=pointer;
      pointer=0;
      read(buffer+end_pointer,GB_BUFFER_SIZE-end_pointer);
      end_pointer+=gcount();
   }
   char *bra=find('<');
   char *result=bra;
   if (!bra) bra=buffer+end_pointer;
   for (const char *test=buffer+pointer;test<bra;test++)
   {  if (!isspace((unsigned char)*test))
      {  cerr << "strange chars @'";
         write(cerr,test);
         cerr << "'\n";
         break;
      }
   }
   set_pointer(bra);
   return result;
}

// returns unmatched </tag> or 0
char *TagStream::next_tag(Tag *parent)
{  // string tag_name="",tag_value="";
   char *tag;
   while ((tag=next_tag_pointer()))
   {  if (tag[1]=='?') // ignore comments
      {  char *endtagend=find(tag,'>');
         if (!endtagend) 
         {  cerr << "comment doesn't end @'";
            write(cerr,tag);
            cerr << "'\n";
            return 0;
         }
         set_pointer(endtagend+1);
         continue;
      }
      if (tag[1]=='/') return tag; // unmatched </tag>
      char *tagend=find(tag,'>');
      if (!tagend) 
      {  cerr << "tag doesn't end @'";
         write(cerr,tag);
         cerr << "'\n";
         return 0;
      }
      char *tagvalue=tagend+1;
      char *valueend=find(tagvalue,'<');
      if (!valueend) 
      {  cerr << __FILE__ << ":" << __LINE__ << "\n";
         return 0;
      }
      if (valueend[1]=='/') // this is a normal tag
      {  // 2do: check whether this is the right tag ending
         parent->push_back(Tag(string(tag+1,tagend-tag-1),
         		      string(tagvalue,valueend-tagvalue)));
         char *endtagend=find(valueend,'>');
         if (!endtagend) 
         {  cerr << "endtag doesn't end @'";
            write(cerr,valueend);
            cerr << "'\n";
            return 0;
         }
         if (memcmp(valueend+2,tag+1,tagend-tag-1))
         {  cerr << "tag <";
            cerr.write(tag,tagend-tag-1) << "> ended with <";
            cerr.write(valueend+1,endtagend-valueend-2) << ">\n";
         }
         set_pointer(endtagend+1);
      }
      else // nested tag
      {  string tagname(tag+1,tagend-tag-1);
         set_pointer(tagend+1);
         char *sub=next_tag(&(parent->push_back(Tag(tagname))));
         if (!sub) return 0;
         char *endtagend=find(sub,'>');
         if (!endtagend) 
         {  cerr << "endtag doesn't end @'";
            write(cerr,sub);
            cerr << "'\n";
            return 0;
         }
         if (memcmp(sub+2,tagname.data(),tagname.size()))
         {  cerr << "tag <" << tagname << "> ended with <";
            cerr.write(sub+1,endtagend-sub-2) << ">\n";
         }
         set_pointer(endtagend+1);
      }
   }
   return 0;
}

