/*  Gtk+ User Interface Builder
 *  Copyright (C) 1998  Damon Chaplin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef __PROPERTY_H__
#define __PROPERTY_H__

#include "gbwidget.h"


extern gchar*  GbDialogValueKey;

/* Event masks */
#define GB_EVENT_MASKS_COUNT 19
gchar *GbEventMaskSymbols     [GB_EVENT_MASKS_COUNT];
gint   GbEventMaskValues      [GB_EVENT_MASKS_COUNT];


/* X Extension mode choices data, for updating the choice property */
extern gchar*  GbExtensionModeChoices[];
extern gint    GbExtensionModeValues[];
extern gchar*  GbExtensionModeSymbols[];


/* These are the standard widget attribute names */
extern gchar*	GbName;
extern gchar*	GbX;
extern gchar*	GbY;
extern gchar*	GbWidth;
extern gchar*	GbHeight;
extern gchar*	GbVisible;
extern gchar*	GbSensitive;
extern gchar*	GbTooltip;
extern gchar*	GbCanDefault;
extern gchar*	GbHasDefault;
extern gchar*	GbCanFocus;
extern gchar*	GbHasFocus;
extern gchar*	GbEvents;
extern gchar*	GbExtEvents;

extern gchar*	GbStylePropagate;
extern gchar*	GbStyleName;
extern gchar*	GbStyleFont;

/* For children of a table */
extern gchar*	GbCellX;
extern gchar*	GbCellY;
extern gchar*	GbColSpan;
extern gchar*	GbRowSpan;
extern gchar*	GbXPad;
extern gchar*	GbYPad;
extern gchar*	GbXExpand;
extern gchar*	GbYExpand;
extern gchar*	GbXShrink;
extern gchar*	GbYShrink;
extern gchar*	GbXFill;
extern gchar*	GbYFill;

/* For children of a box */
extern gchar*	GbPadding;
extern gchar*	GbExpand;
extern gchar*	GbFill;
extern gchar*	GbPack;

/* For children of a packer */
#ifdef GLD_HAVE_GTK_1_1
extern gchar*	GbPackerSide;
extern gchar*	GbPackerAnchor;
extern gchar*	GbPackerExpand;
extern gchar*	GbPackerFillX;
extern gchar*	GbPackerFillY;
extern gchar*	GbPackerBorder;
extern gchar*	GbPackerPadX;
extern gchar*	GbPackerPadY;
extern gchar*	GbPackerIPadX;
extern gchar*	GbPackerIPadY;

extern gchar*	GbPackerSideChoices[];
extern gint	GbPackerSideValues[];
extern gchar*	GbPackerSideSymbols[];

extern gchar*	GbPackerAnchorChoices[];
extern gint	GbPackerAnchorValues[];
extern gchar*	GbPackerAnchorSymbols[];
#endif

/* Signals page */
extern gchar*	GbSignalName;
extern gchar*	GbSignalHandler;
extern gchar*	GbSignalObject;
extern gchar*	GbSignalAfter;
extern gchar*	GbSignalData;

/* Accelerators page */
extern gchar*	GbAccelKey;
extern gchar*	GbAccelSignal;



void	    property_show		(GtkWidget	    *widget,
					 gpointer	     data);
gint	    property_hide		(GtkWidget	    *widget,
					 gpointer	     data);
void	    property_set_widget		(GtkWidget	    *widget);
GtkWidget*  property_get_widget		(void);

/* Adding properties */
gint	    property_add_gbwidget_page	(GtkWidget	    *page);
void	    property_hide_gbwidget_page	(void);
void	    property_show_gbwidget_page	(gint		     page);

void	    property_hide_special_child_page	();
void	    property_show_special_child_page	(gint page);

GtkWidget*  property_get_table_position (gint		    *row);
void	    property_set_table_position	(GtkWidget	    *table,
					 gint		     row);


/* Note: Unless stated otherwise, values passed to property_set_XXX() will
   not be changed (and copied if needed), and you should copy values returned
   from property_get_XXX() calls if you need them (or ref pixmaps/bitmaps). */
void	    property_add_string		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
gchar*	    property_get_string		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_string		(gchar		    *property_name,
					 gchar		    *value);

void	    property_add_text		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 gint		     visible_lines);
/* Note: string returned from property_get_text must be freed with g_free() */
gchar*	    property_get_text		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_text		(gchar		    *property_name,
					 gchar		    *value);

void	    property_add_int		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
void	    property_add_int_range	(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 gint		     min,
					 gint		     max,
					 gint		     step_increment,
					 gint		     page_increment,
					 gint		     climb_rate);
gint	    property_get_int		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_int		(gchar		    *property_name,
					 gint		     value);

void	    property_add_float		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
void	    property_add_float_range	(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 gfloat		     min,
					 gfloat		     max,
					 gfloat		     step_increment,
					 gfloat		     page_increment,
					 gfloat		     climb_rate,
					 gint		     decimal_digits);
gfloat	    property_get_float		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_float		(gchar		    *property_name,
					 gfloat		     value);

void	    property_add_bool		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
gboolean    property_get_bool		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
/* set_bool takes an int so we can pass it GTK values which aren't really
   gbooleans and also results of ANDing bit masks. */
void	    property_set_bool		(gchar		    *property_name,
					 gint		     value);

void	    property_add_choice		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 gchar		   **choices);
gchar*	    property_get_choice		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_choice		(gchar		    *property_name,
					 gint		     value);

void	    property_add_combo		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 GList		    *choices);
gchar*	    property_get_combo		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_combo		(gchar		    *property_name,
					 gchar		    *value);
void	    property_set_combo_strings	(gchar		    *property_name,
					 GList		    *choices);

void	    property_add_color		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
guchar*	    property_get_color		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_color		(gchar		    *property_name,
					 guchar		    *value);

void	    property_add_bgpixmap	(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
GdkPixmap*  property_get_bgpixmap	(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply,
					 gchar		   **filename);
void	    property_set_bgpixmap	(gchar		    *property_name,
					 GdkPixmap	    *gdkpixmap,
					 gchar		    *filename);

/* A dialog property is an Entry with a button on the right of it which, when
   clicked, calls the callback given in the property_add_dialog function.
   This callback should show an appropriate dialog box for editing the
   property. Then, the dialog should change the text in the Entry.
   If the property value can't be completely represented using text, the value
   should be placed in the Entry's object data hash under GbDialogValueKey.
   (In this case the the Entry should not be editable, as set in
   property_add_dialog) */
void	    property_add_dialog		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip,
					 gboolean	     editable,
					 GtkCallback	     callback);
gpointer    property_get_dialog		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_dialog		(gchar		    *property_name,
					 gchar		    *string,
					 gpointer	     value);

void	    property_add_filename	(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
gchar*	    property_get_filename	(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply);
void	    property_set_filename	(gchar		    *property_name,
					 gchar		    *value);

void	    property_add_font		(gchar		    *property_name,
					 gchar		    *label,
					 gchar		    *tooltip);
GdkFont*    property_get_font		(gchar		    *property_name,
					 GtkWidget	    *to_apply,
					 gboolean	    *apply,
					 gchar		   **xlfd_fontname);
void	    property_set_font		(gchar		    *property_name,
					 GdkFont	    *font,
					 gchar		    *xlfd_fontname);

#define GB_ADJUST_DEFAULT_LABELS 1
#define GB_ADJUST_H_LABELS	 2
#define GB_ADJUST_V_LABELS	 3
void	    property_add_adjustment	(gchar		    *Values[],
					 gint		     label_type);

void	    property_set_sensitive	(gchar		    *property_name,
					 gboolean	     sensitive);

void	    property_set_valid		(gchar		    *property_name,
					 gboolean	     valid);

gchar*	    property_events_value_to_string	(gint	     event_mask);
gint	    property_events_string_to_value	(gchar	    *event_string);

/* Turn on/off auto-apply which applies changes as they are made in the
   property editor. You may need to turn this off if you are updating
   properties, otherwise the properties will be applied again. */
void	    property_set_auto_apply	(gboolean	     value);


void	    property_clear_accelerators	(void);
void	    property_add_accelerator	(GbAccelerator	    *accel);
gboolean    property_is_accel_clist	(GtkWidget	    *widget);
GList*      property_get_accelerators	(void);

void	    property_clear_signals	(void);
void	    property_add_signal		(GbSignal	    *signal);
gboolean    property_is_signal_clist	(GtkWidget	    *widget);
GList*      property_get_signals	(void);


#endif	/* __PROPERTY_H__ */
