/* A simple test of bsearch.
   Check how a checkered function can be called from non checkered-code.  */
#include <stdlib.h>
#include <stdio.h>

#define NBR_NUMBERS 1024

int data_vals[NBR_NUMBERS];

int
int_compare (const void *a, const void *b)
{
  return *(int *)a - *(int *)b;
}

int
main(void)
{
  int i;
  int val;
  int *res;

  for (i = 0; i < NBR_NUMBERS; i++)
    data_vals[i] = rand ();

  qsort (data_vals, NBR_NUMBERS, sizeof (int), int_compare);

  for (i = 0; i < 100; i++)
    {
      val = rand ();
      res = bsearch (&val, data_vals, NBR_NUMBERS, sizeof (int), int_compare);
      if (res)
	printf ("%d was found at position %d\n", val, res - data_vals);
      else
	printf ("%d was not found\n", val);
    }
  return 0;
}
