/* Checker stubs for functions defined in stdlib.h
   Copyright 1995, 96, 1997 Tristan Gingold
		  Written December 1995 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

 The author may be reached by US/French mail:
		Tristan Gingold 
		8 rue Parmentier
		F-91120 PALAISEAU
		FRANCE
*/
#include "available-stubs.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#include "checker_api.h"

#undef HAVE_mblen
#undef HAVE_mbtowc
#undef HAVE_wctomb
#undef HAVE_mbstowcs
#undef HAVE_wcstombs
#undef HAVE_ecvt
#undef HAVE_fcvt
#undef HAVE_gcvt
#undef HAVE_insque
#undef HAVE_remque

/* compiled from: . */
#ifdef HAVE_atof
double chkr_stub_atof (const char *ptr) __asm__ (CHKR_PREFIX ("atof"));
double
chkr_stub_atof (const char *ptr)
{
  stubs_chkr_check_str (ptr, CHKR_RO, "ptr");
#if USE_BI_JUMP
  __builtin_jump (atof);
#else
  return atof (ptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_atof */

#ifdef HAVE_atoi
int chkr_stub_atoi (const char *ptr) __asm__ (CHKR_PREFIX ("atoi"));
int
chkr_stub_atoi (const char *ptr)
{
  stubs_chkr_check_str (ptr, CHKR_RO, "ptr");
#if USE_BI_JUMP
  __builtin_jump (atoi);
#else
  return atoi (ptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_atoi */

#ifdef HAVE_atol
long int chkr_stub_atol (const char *ptr) __asm__ (CHKR_PREFIX ("atol"));
long int
chkr_stub_atol (const char *ptr)
{
  int len;
  const char *p = ptr;
  
  len = 1;
  if (*p == '+' || *p == '-')
    {
      p++;
      len++;
    }
  for (; *p >= '0' && *p <= '9'; p++)
    len++;
    
  stubs_chkr_check_addr (ptr, len, CHKR_RO, "ptr");
#if USE_BI_JUMP
  __builtin_jump (atol);
#else
  return atol (ptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_atol */

#ifdef HAVE_atoq
long long int chkr_stub_atoq (const char *ptr) __asm__ (CHKR_PREFIX ("atoq"));
long long int
chkr_stub_atoq (const char *ptr)
{
  stubs_chkr_check_str (ptr, CHKR_RO, "ptr");
#if USE_BI_JUMP
  __builtin_jump (atoq);
#else
  return atoq (ptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_atoq */

#ifdef HAVE_strtof
float chkr_stub_strtof (const char *nptr, char **endptr)
  __asm__ (CHKR_PREFIX ("strtof"));
float
chkr_stub_strtof (const char *nptr, char **endptr)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtof);
#else
  return strtof (nptr, endptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtof */

#ifdef HAVE_strtod
double chkr_stub_strtod (const char *nptr, char **endptr)
  __asm__ (CHKR_PREFIX ("strtod"));
double
chkr_stub_strtod (const char *nptr, char **endptr)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return strtod (nptr, endptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtod */

#ifdef HAVE_strtold
long double chkr_stub_strtold (const char *nptr, char **endptr)
  __asm__ (CHKR_PREFIX ("strtold"));
long double
chkr_stub_strtold (const char *nptr, char **endptr)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return strtold (nptr, endptr);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtold */

#ifdef HAVE_strtol
long int chkr_stub_strtol (const char *nptr, char **endptr, int base)
  __asm__ (CHKR_PREFIX ("strtol"));
long int
chkr_stub_strtol (const char *nptr, char **endptr, int base)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return strtol (nptr, endptr, base);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtol */

#ifdef HAVE_strtoul
long unsigned int chkr_stub_strtoul (const char *nptr, char **endptr, int base)
  __asm__ (CHKR_PREFIX ("strtoul"));
long unsigned int
chkr_stub_strtoul (const char *nptr, char **endptr, int base)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return strtoul (nptr, endptr, base);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtoul */

#ifdef HAVE_strtoq
long long int chkr_stub_strtoq (const char *nptr, char **endptr, int base)
  __asm__ (CHKR_PREFIX ("strtoq"));
long long int
chkr_stub_strtoq (const char *nptr, char **endptr, int base)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return strtoq (nptr, endptr, base);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtoq */

#ifdef HAVE_strtouq
long long unsigned int chkr_stub_strtouq (const char *nptr, char **endptr,
					  int base)
  __asm__ (CHKR_PREFIX ("strtouq"));
long long unsigned int
chkr_stub_strtouq (const char *nptr, char **endptr, int base)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtouq);
#else
  return strtouq (nptr, endptr, base);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_strtouq */


#ifdef HAVE___strtod_internal
/* From `/usr/include/stdlib.h:116'.  */
double chkr_stub___strtod_internal (const char *nptr, char **endptr, int group)
  __asm__ (CHKR_PREFIX ("__strtod_internal"));
double
chkr_stub___strtod_internal (const char *nptr, char **endptr, int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (__strtod_internal);
#else
  return __strtod_internal (nptr, endptr, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtod_internal */

#ifdef HAVE___strtof_internal
/* From `/usr/include/stdlib.h:118'.  */
float chkr_stub___strtof_internal (const char *nptr, char **endptr, int group)
   __asm__ (CHKR_PREFIX ("__strtof_internal"));
float
chkr_stub___strtof_internal (const char *nptr, char **endptr, int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtof);
#else
  return __strtof_internal (nptr, endptr, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtof_internal */

#ifdef HAVE___strtold_internal
/* From `/usr/include/stdlib.h:120'.  */
__long_double_t
chkr_stub___strtold_internal (const char *nptr, char **endptr, int group)
  __asm__ (CHKR_PREFIX ("__strtold_internal"));
__long_double_t
chkr_stub___strtold_internal (const char *nptr, char **endptr, int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (__strtold_internal);
#else
  return __strtold_internal (nptr, endptr, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtold_internal */

#ifdef HAVE___strtol_internal
/* From `/usr/include/stdlib.h:122'.  */
long int chkr_stub___strtol_internal (const char *nptr, char **endptr,
				      int base,
				      int group)
     __asm__ (CHKR_PREFIX ("__strtol_internal"));
long int
chkr_stub___strtol_internal (const char *nptr, char **endptr, int base,
			     int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (__strtol_internal);
#else
  return __strtol_internal (nptr, endptr, base, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtol_internal */

#ifdef HAVE___strtoul_internal
/* From `/usr/include/stdlib.h:125'.  */
long unsigned int chkr_stub___strtoul_internal (const char *nptr,
						char **endptr, int base,
						int group)
     __asm__ (CHKR_PREFIX ("__strtoul_internal"));
long unsigned int
chkr_stub___strtoul_internal (const char *nptr, char **endptr, int base,
			      int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
  return __strtoul_internal (nptr, endptr, base, group);
}
#endif /* HAVE___strtoul_internal */

#ifdef HAVE___strtoq_internal
/* From `/usr/include/stdlib.h:128'.  */
long long int chkr_stub___strtoq_internal (const char *nptr, char **endptr,
					   int base, int group)
     __asm__ (CHKR_PREFIX ("__strtoq_internal"));
long long int
chkr_stub___strtoq_internal (const char *nptr, char **endptr, int base,
			     int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtod);
#else
  return __strtoq_internal (nptr, endptr, base, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtoq_internal */

#ifdef HAVE___strtouq_internal
/* From `/usr/include/stdlib.h:131'.  */
long long unsigned int chkr_stub___strtouq_internal (const char *nptr,
						     char **endptr, int base,
						     int group)
     __asm__ (CHKR_PREFIX ("__strtouq_internal"));
long long unsigned int
chkr_stub___strtouq_internal (const char *nptr, char **endptr, int base,
			      int group)
{
  stubs_chkr_check_str (nptr, CHKR_RO, "nptr");
  if (endptr)
    stubs_chkr_check_addr (endptr, sizeof (char *), CHKR_WO, "endptr");
#if USE_BI_JUMP
  __builtin_jump (strtouq);
#else
  return __strtouq_internal (nptr, endptr, base, group);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___strtouq_internal */

#ifdef HAVE_lltostr
/* FIXME: Is it correct ? (no docs).  */
char *chkr_stub_lltostr(long long value, char *ptr)
     __asm__ (CHKR_PREFIX ("lltostr"));
char *
chkr_stub_lltostr(long long value, char *ptr)
{
  char * res;
  stubs_chkr_check_addr (ptr, sizeof (long long) * 8 / 3 + 1, CHKR_MW, "ptr");
  res = lltostr (value, ptr);
  if (res)
    stubs_chkr_set_right (ptr, strlen (ptr) + 1, CHKR_RW);
  return res;
}
#endif

#ifdef HAVE_rand
int chkr_stub_rand (void) __asm__ (CHKR_PREFIX ("rand"));
int
chkr_stub_rand (void)
{
#if USE_BI_JUMP
  __builtin_jump (rand);
#else
  return rand ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_rand */

#ifdef HAVE_srand
void chkr_stub_srand (unsigned int seed) __asm__ (CHKR_PREFIX ("srand"));
void
chkr_stub_srand (unsigned int seed)
{
#if USE_BI_JUMP
  __builtin_jump (srand);
#else
  srand (seed);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_srand */

#ifdef HAVE_random
long int chkr_stub_random (void) __asm__ (CHKR_PREFIX ("random"));
long int
chkr_stub_random (void)
{
#if USE_BI_JUMP
  __builtin_jump (random);
#else
  return random ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_random */

#ifdef HAVE_srandom
void chkr_stub_srandom (unsigned int seed) __asm__ (CHKR_PREFIX ("srandom"));
void
chkr_stub_srandom (unsigned int seed)
{
#if USE_BI_JUMP
  __builtin_jump (srandom);
#else
  srandom (seed);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_srandom */

#ifdef HAVE_initstate
void * chkr_stub_initstate (unsigned int seed, void *state, size_t n)
  __asm__ (CHKR_PREFIX ("initstate"));
void *
chkr_stub_initstate (unsigned int seed, void *state, size_t n)
{
  stubs_chkr_check_addr (state, n, CHKR_RO, "state");
#if USE_BI_JUMP
  __builtin_jump (initstate);
#else
  return initstate (seed, state, n);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_initstate */

#ifdef HAVE_setstate
void * chkr_stub_setstate (void *state) __asm__ (CHKR_PREFIX ("setstate"));
void *
chkr_stub_setstate (void *state)
{
#if USE_BI_JUMP
  __builtin_jump (setstate);
#else
  return setstate (state);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_setstate */

#ifdef HAVE_abort
void chkr_stub_abort (void) __asm__ (CHKR_PREFIX ("abort"));
void
chkr_stub_abort (void)
{
#if USE_BI_JUMP
  __builtin_jump (abort);
#else
  abort ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_abort */

#ifdef HAVE_atexit
int chkr_stub_atexit (void (*func) (void)) __asm__ (CHKR_PREFIX ("atexit"));
int
chkr_stub_atexit (void (*func) (void))
{
  stubs_chkr_check_exec (func, "func");
#if USE_BI_JUMP
  __builtin_jump (atexit);
#else
  return atexit (func);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_atexit */

#ifdef HAVE_on_exit
int chkr_stub_on_exit (void (*func) (int, void *), void *arg)
  __asm__ (CHKR_PREFIX ("on"));
int
chkr_stub_on_exit (void (*func) (int, void *), void *arg)
{
  stubs_chkr_check_exec (func, "func");
#if USE_BI_JUMP
  __builtin_jump (on_exit);
#else
  return on_exit (func, arg);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_on_exit */

#ifdef HAVE_exit
void chkr_stub_exit (int status) __asm__ (CHKR_PREFIX ("exit"));
void
chkr_stub_exit (int status)
{
  status = stubs_chkr_get_exit_status (status);

  exit (status);
}
#endif /* HAVE_exit */

#ifdef HAVE_getenv
char * chkr_stub_getenv (const char *str) __asm__ (CHKR_PREFIX ("getenv"));
char *
chkr_stub_getenv (const char *str)
{
  stubs_chkr_check_str (str, CHKR_RO, "str");
#if USE_BI_JUMP
  __builtin_jump (getenv);
#else
  {
    char * res;
    res = getenv (str);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_getenv */

#ifdef HAVE_putenv
int chkr_stub_putenv (const char *name) __asm__ (CHKR_PREFIX ("putenv"));
int
chkr_stub_putenv (const char *name)
{
  stubs_chkr_check_str (name, CHKR_RO, "name");
#if USE_BI_JUMP
  __builtin_jump (putenv);
#else
  return putenv (name);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_putenv */

#ifdef HAVE_setenv
int chkr_stub_setenv (const char *name, const char *value, int overwrite)
  __asm__ (CHKR_PREFIX ("setenv"));
int
chkr_stub_setenv (const char *name, const char *value, int overwrite)
{
  stubs_chkr_check_str (name, CHKR_RO, "name");
  stubs_chkr_check_str (value, CHKR_RO, "value");
#if USE_BI_JUMP
  __builtin_jump (setenv);
#else
  return setenv (name, value, overwrite);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_setenv */

#ifdef HAVE_system
int chkr_stub_system (const char *command) __asm__ (CHKR_PREFIX ("system"));
int
chkr_stub_system (const char *command)
{
  if (command)
    stubs_chkr_check_str (command, CHKR_RO, "command");
#if USE_BI_JUMP
  __builtin_jump (system);
#else
  return system (command);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_system */

#ifdef HAVE_bsearch
void *
chkr_stub_bsearch (const void *key, const void *base, size_t nmemb,
		   size_t size, int (*compare)(const void *, const void *))
  __asm__ (CHKR_PREFIX ("bsearch"));
void *
chkr_stub_bsearch (const void *key, const void *base, size_t nmemb,
		   size_t size, int (*compare)(const void *, const void *))
{
  stubs_chkr_check_exec (compare, "compare");
#if 1
  stubs_chkr_assert_not_red_zone (base, nmemb * size);
  stubs_chkr_assert_not_red_zone (key, size);
#else
  if (nmemb * size)
    stubs_chkr_check_addr (base, nmemb * size, CHKR_RO, "base");
  if (size)
    stubs_chkr_check_addr (key, size, CHKR_RO, "key");
#endif
#if USE_BI_JUMP
  __builtin_jump (bsearch);
#else
  return bsearch (key, base, nmemb, size, compare);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_bsearch */

#ifdef HAVE_qsort
void
chkr_stub_qsort (void *base, size_t nmemb, size_t size,
            int (*compare)(const void *, const void *))
  __asm__ (CHKR_PREFIX ("qsort"));
void
chkr_stub_qsort (void *base, size_t nmemb, size_t size,
            int (*compare)(const void *, const void *))
{
  stubs_chkr_check_exec (compare, "compare");
  if (nmemb * size)
    stubs_chkr_check_addr (base, nmemb * size, CHKR_TW, "base");
  qsort (base, nmemb, size, compare);
}
#endif /* HAVE_qsort */

#ifdef HAVE_abs
int chkr_stub_abs (int j) __asm__ (CHKR_PREFIX ("abs"));
int
chkr_stub_abs (int j)
{
#if USE_BI_JUMP
  __builtin_jump (abs);
#else
  return abs (j);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_abs */

#ifdef HAVE_labs
long int chkr_stub_labs (long int j) __asm__ (CHKR_PREFIX ("labs"));
long int
chkr_stub_labs (long int j)
{
#if USE_BI_JUMP
  __builtin_jump (labs);
#else
  return labs (j);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_labs */

#ifdef HAVE_div
div_t chkr_stub_div (int numer, int denom) __asm__ (CHKR_PREFIX ("div"));
div_t
chkr_stub_div (int numer, int denom)
{
  div_t res;
  div_t *ptr;

  ptr = (div_t *) __builtin_aggregate_incoming_address ();
  res = div (numer, denom);
  stubs_chkr_set_right (&(ptr->quot), sizeof (ptr->quot), CHKR_RW);
  stubs_chkr_set_right (&(ptr->rem), sizeof (ptr->rem), CHKR_RW);
  return res;
}
#endif /* HAVE_div */

#ifdef HAVE_ldiv
ldiv_t chkr_stub_ldiv (long int numer, long int denom)
  __asm__ (CHKR_PREFIX ("ldiv"));
ldiv_t
chkr_stub_ldiv (long int numer, long int denom)
{
  ldiv_t res;
  ldiv_t *ptr;

  ptr = (ldiv_t *) __builtin_aggregate_incoming_address ();
  res = ldiv (numer, denom);
  stubs_chkr_set_right (&(ptr->quot), sizeof (ptr->quot), CHKR_RW);
  stubs_chkr_set_right (&(ptr->rem), sizeof (ptr->rem), CHKR_RW);
  return res;
}
#endif /* HAVE_ldiv */

#ifdef HAVE_lldiv
lldiv_t chkr_stub_lldiv (long long int numer, long long int denom)
  __asm__ (CHKR_PREFIX ("lldiv"));
lldiv_t
chkr_stub_lldiv (long long int numer, long long int denom)
{
  lldiv_t res;
  lldiv_t *ptr;

  ptr = (lldiv_t *) __builtin_aggregate_incoming_address ();
  res = lldiv (numer, denom);
  stubs_chkr_set_right (&(ptr->quot), sizeof (ptr->quot), CHKR_RW);
  stubs_chkr_set_right (&(ptr->rem), sizeof (ptr->rem), CHKR_RW);
  return res;
}
#endif /* HAVE_lldiv */

#ifdef HAVE_mblen
int chkr_stub_mblen (const char * arg0, size_t arg1) 
  __asm__ (CHKR_PREFIX ("mblen"));
int
chkr_stub_mblen (const char * arg0, size_t arg1)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (mblen);
#else
  {
    int res;
    res = mblen (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mblen */

#ifdef HAVE_mbtowc
int chkr_stub_mbtowc (wchar_t * arg0, const char * arg1, size_t arg2)
  __asm__ (CHKR_PREFIX ("mbtowc"));
int
chkr_stub_mbtowc (wchar_t * arg0, const char * arg1, size_t arg2)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (wchar_t), CHKR_XX);
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (mbtowc);
#else
  {
    int res;
    res = mbtowc (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mbtowc */

#ifdef HAVE_wctomb
int chkr_stub_wctomb (char * arg0, wchar_t arg1)
  __asm__ (CHKR_PREFIX ("wctomb"));
int
chkr_stub_wctomb (char * arg0, wchar_t arg1)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (wctomb);
#else
  {
    int res;
    res = wctomb (arg0, arg1);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wctomb */

#ifdef HAVE_mbstowcs
size_t chkr_stub_mbstowcs (wchar_t * arg0, const char * arg1, size_t arg2)
  __asm__ (CHKR_PREFIX ("mbstowcs"));
size_t
chkr_stub_mbstowcs (wchar_t * arg0, const char * arg1, size_t arg2)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (wchar_t), CHKR_XX);
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (mbstowcs);
#else
  {
    size_t res;
    res = mbstowcs (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mbstowcs */

#ifdef HAVE_wcstombs
size_t chkr_stub_wcstombs (char * arg0, const wchar_t * arg1, size_t arg2)
  __asm__ (CHKR_PREFIX ("wcstombs"));
size_t
chkr_stub_wcstombs (char * arg0, const wchar_t * arg1, size_t arg2)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_XX);
  stubs_chkr_check_addr (arg1, sizeof (wchar_t), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (wcstombs);
#else
  {
    size_t res;
    res = wcstombs (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_wcstombs */

#ifdef HAVE_ecvt
char * chkr_stub_ecvt (double arg0, size_t arg1, int * arg2, int * arg3)
  __asm__ (CHKR_PREFIX ("ecvt"));
char *
chkr_stub_ecvt (double arg0, size_t arg1, int * arg2, int * arg3)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX);
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (ecvt);
#else
  {
    char * res;
    res = ecvt (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_ecvt */

#ifdef HAVE_fcvt
char * chkr_stub_fcvt (double arg0, size_t arg1, int * arg2, int * arg3)
  __asm__ (CHKR_PREFIX ("fcvt"));
char *
chkr_stub_fcvt (double arg0, size_t arg1, int * arg2, int * arg3)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_XX);
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (fcvt);
#else
  {
    char * res;
    res = fcvt (arg0, arg1, arg2, arg3);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_fcvt */

#ifdef HAVE_gcvt
char * chkr_stub_gcvt (double arg0, size_t arg1, char * arg2)
  __asm__ (CHKR_PREFIX ("gcvt"));
char *
chkr_stub_gcvt (double arg0, size_t arg1, char * arg2)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg2, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (gcvt);
#else
  {
    char * res;
    res = gcvt (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_gcvt */

#ifdef HAVE_drand48
double chkr_stub_drand48 (void) __asm__ (CHKR_PREFIX ("drand48"));
double
chkr_stub_drand48 (void)
{
#if USE_BI_JUMP
  __builtin_jump (drand48);
#else
  return drand48 ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_drand48 */

#ifdef HAVE_erand48
double chkr_stub_erand48 (short unsigned int xsubi[3])
  __asm__ (CHKR_PREFIX ("erand48"));
double
chkr_stub_erand48 (short unsigned int xsubi[3])
{
  stubs_chkr_check_addr (xsubi, 3 * sizeof (short unsigned int), CHKR_WO, "xsubi");
#if USE_BI_JUMP
  __builtin_jump (erand48);
#else
  return erand48 (xsubi);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_erand48 */

#ifdef HAVE_lrand48
long int chkr_stub_lrand48 (void)
  __asm__ (CHKR_PREFIX ("lrand48"));
long int
chkr_stub_lrand48 (void)
{
#if USE_BI_JUMP
  __builtin_jump (lrand48);
#else
  return lrand48 ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lrand48 */

#ifdef HAVE_nrand48
long int chkr_stub_nrand48 (short unsigned int xsubi[3])
  __asm__ (CHKR_PREFIX ("nrand48"));
long int
chkr_stub_nrand48 (short unsigned int xsubi[3])
{
  stubs_chkr_check_addr (xsubi, 3 * sizeof (short unsigned int), CHKR_WO, "xsubi");
#if USE_BI_JUMP
  __builtin_jump (nrand48);
#else
  return nrand48 (xsubi);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_nrand48 */

#ifdef HAVE_mrand48
long int chkr_stub_mrand48 (void) __asm__ (CHKR_PREFIX ("mrand48"));
long int
chkr_stub_mrand48 (void)
{
#if USE_BI_JUMP
  __builtin_jump (mrand48);
#else
  return mrand48 ();
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_mrand48 */

#ifdef HAVE_jrand48
long int chkr_stub_jrand48 (short unsigned int xsubi[3])
  __asm__ (CHKR_PREFIX ("jrand48"));
long int
chkr_stub_jrand48 (short unsigned int xsubi[3])
{
  stubs_chkr_check_addr (xsubi, 3 * sizeof (short unsigned int), CHKR_WO, "xsubi");
#if USE_BI_JUMP
  __builtin_jump (jrand48);
#else
  return jrand48 (xsubi);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_jrand48 */

#ifdef HAVE_srand48
void chkr_stub_srand48 (long int seedval) __asm__ (CHKR_PREFIX ("srand48"));
void
chkr_stub_srand48 (long int seedval)
{
#if USE_BI_JUMP
  __builtin_jump (srand48);
#else
  srand48 (seedval);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_srand48 */

#ifdef HAVE_seed48
short unsigned int * chkr_stub_seed48 (short unsigned int seed16v[3])
  __asm__ (CHKR_PREFIX ("seed48"));
short unsigned int *
chkr_stub_seed48 (short unsigned int seed16v[3])
{
  short unsigned int *res;
  stubs_chkr_check_addr (seed16v, 3 * sizeof (short unsigned int), CHKR_RO, "seed16v");
  res = seed48 (seed16v);
  if (res)
    stubs_chkr_set_right (seed16v, 3 * sizeof (short unsigned int), CHKR_RW);
  return res;
}
#endif /* HAVE_seed48 */

#ifdef HAVE_lcong48
void chkr_stub_lcong48 (short unsigned int param[7])
  __asm__ (CHKR_PREFIX ("lcong48"));
void
chkr_stub_lcong48 (short unsigned int param[7])
{
  stubs_chkr_check_addr (param, 7 * sizeof (short unsigned int), CHKR_RO, "param");
#if USE_BI_JUMP
  __builtin_jump (lcong48);
#else
  lcong48 (param);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lcong48 */

#ifdef HAVE_unsetenv
void chkr_stub_unsetenv (const char *name) __asm__ (CHKR_PREFIX ("unsetenv"));
void
chkr_stub_unsetenv (const char *name)
{
  stubs_chkr_check_str (name, CHKR_RO, "name");
#if USE_BI_JUMP
  __builtin_jump (unsetenv);
#else
  unsetenv (name);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_unsetenv */

#ifdef HAVE_insque
void chkr_stub_insque (struct qelem * arg0, struct qelem * arg1)
  __asm__ (CHKR_PREFIX ("insque"));
void
chkr_stub_insque (struct qelem * arg0, struct qelem * arg1)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct qelem), CHKR_XX);
  stubs_chkr_check_addr (arg1, sizeof (struct qelem), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (insque);
#else
  insque (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_insque */

#ifdef HAVE_remque
void chkr_stub_remque (struct qelem * arg0)
  __asm__ (CHKR_PREFIX ("remque"));
void
chkr_stub_remque (struct qelem * arg0)
{
  /* This function require a stub */
  stubs_chkr_check_addr (arg0, sizeof (struct qelem), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (remque);
#else
  remque (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_remque */

#endif /* HAVE_STDLIB_H */
