# Note: Each line beginning with `##' are reserved.

# Note for `##-conf' lines: They are displayed (without ##-conf.?) with
# ./MakeMakefile --help
##-conf Options for sun-sparc-solaris2:
##-conf.simchecker: checker.so.1
##-conf.staticsimchecker: simchecker.o
##-conf.gccchecker: libchecker.a
##-conf.default: simchecker

# Common part
ifcommon
@decl
### makefile fragment for solaris 2
RANLIB = echo > /dev/null
LDFLAGS_FOR_CHKR = -r -Bstatic
SYMCTL_C = $(srcdir)/utils/symctl_elf.c
@rules
endifcommon

# ########### SIMCHECKER
ifsimchecker
@decl
TARGET=checker.so.1
ALL_CFLAGS = $(CPPFLAGS) $(CFLAGS) -fPIC -D__PIC__ -DSIMCHECKER -DVPRINTF_FLOAT
ALL_ASFLAGS = $(ACPPFLAGS) -D__PIC__ -fPIC
CHECKER_O_FLAG = -DSIMCHECKER
C_OBJS=begin.o syscalls.o elf-stabs.o instr.o run_sim.o solaris-syscalls.o \
  heap.o gettimeofday.o chkr-string.o ffs.o sigset.o opendir.o readdir.o \
  closedir.o solaris2.o _dup2.o sysconf.o ftruncate.o sigaction.o startup.o \
  __sbrk.o mmap.o parse-args.o error.o smalloc.o signal.o find-exec.o fd.o \
  time.o message.o version.o vprintf.o getenv.o getcwd.o mktemp.o qsort.o \
  malloc.o free.o realloc.o utils.o garbage.o maccess.o calloc.o memalign.o \
  sbrk.o attach.o detach.o syscallname.o simserver.o sig.o disassem.o \
  cvt.o imodf.o end.o 
# open.o

@rules
symctl.in: $(srcdir)/common.symctl $(srcdir)/config/sparc/solaris2/simchecker.symctl
	cat $(srcdir)/common.symctl $(srcdir)/config/sparc/solaris2/simchecker.symctl > symctl.in

checker.so.1: $(C_OBJS) symctl.in symctl
	$(LD) -G -z text -B symbolic -e _init -o checker.so.1 $(C_OBJS) -lc
	./symctl -s symctl.in checker.so.1

gdbserver: gdbserver.o
	$(CC) $(UTILS_LDFLAGS) -o gdbserver gdbserver.o -lsocket -lnls

gdbserver.o: $(srcdir)/config/sparc/sim/gdbserver.c
	$(CC) $(UTILS_CFLAGS) -c -o gdbserver.o $(srcdir)/config/sparc/sim/gdbserver.c

sstep: sstep.o sstep-disa.o
	$(CC) $(UTILS_CFLAGS) sstep.o sstep-disa.o -o sstep

sstep.o: $(srcdir)/config/sparc/sim/sstep.c
	$(CC) $(UTILS_CFLAGS) $(srcdir)/config/sparc/sim/sstep.c -c -o sstep.o

sstep-disa.o: $(srcdir)/config/sparc/sim/disassem.c
	$(CC) $(UTILS_CFLAGS) -DSSTEP $(srcdir)/config/sparc/sim/disassem.c -c -o sstep-disa.o

install: install.dir checker checker.so.1
	$(INSTALL_PROGRAM) checker $(bindir)/checker
	$(INSTALL_PROGRAM) checker.so.1 $(libdir)/checker.so.1

endifsimchecker

# ########### STATICSIMCHECKER
ifstaticsimchecker
@decl
TARGET=simchecker.o
ALL_CFLAGS = $(CPPFLAGS) $(CFLAGS) -DSIMCHECKER -DVPRINTF_FLOAT
ALL_ASFLAGS = $(ACPPFLAGS)
C_OBJS=begin.o syscalls.o elf-stabs.o instr.o run_sim.o solaris-syscalls.o \
  heap.o gettimeofday.o chkr-string.o ffs.o sigset.o opendir.o readdir.o \
  closedir.o solaris2.o _dup2.o sysconf.o ftruncate.o sigaction.o startup.o \
  __sbrk.o mmap.o parse-args.o error.o smalloc.o signal.o find-exec.o fd.o \
  time.o message.o version.o vprintf.o getenv.o getcwd.o mktemp.o qsort.o \
  malloc.o free.o realloc.o utils.o garbage.o maccess.o calloc.o memalign.o \
  sbrk.o attach.o detach.o syscallname.o simserver.o sig.o disassem.o \
  cvt.o imodf.o end.o
# open.o

@rules
symctl.in: $(srcdir)/common.symctl $(srcdir)/config/sparc/solaris2/simchecker.symctl
	cat $(srcdir)/common.symctl $(srcdir)/config/sparc/solaris2/simchecker.symctl > symctl.in

simchecker.o: $(C_OBJS) symctl.in symctl
	$(LD) -dn -r -Bstatic -o simchecker.o $(C_OBJS)
#	./symctl symctl.in simchecker.o

endifstaticsimchecker

# ###### For GCC Checker
ifgccchecker
@decl
OBJS=begin.o syscalls.o elf-stabs.o stubs-syscalls.o \
  gettimeofday.o chkr-string.o ffs.o sigset.o opendir.o readdir.o \
  closedir.o solaris2.o _dup2.o sysconf.o ftruncate.o sigaction.o startup.o \
  __sbrk.o mmap.o parse-args.o error.o smalloc.o signal.o find-exec.o fd.o \
  time.o message.o version.o vprintf.o getenv.o getcwd.o mktemp.o qsort.o \
  malloc.o free.o realloc.o utils.o garbage.o maccess.o calloc.o memalign.o \
  sbrk.o attach.o detach.o cvt.o imodf.o end.o
# open.o
ALL_CFLAGS = -DGCCCHECKER $(CPPFLAGS) $(CFLAGS)
CHECKER_O_FLAG = -DGCCCHECKER
# Stubs
STUB_OBJS= begin-stubs.o s-arpa_inet-inet_addr.o s-arpa_inet-inet_lnaof.o \
s-arpa_inet-inet_makeaddr.o s-arpa_inet-inet_netof.o \
s-arpa_inet-inet_network.o s-arpa_inet-inet_ntoa.o \
s-ctype-_tolower.o s-ctype-_toupper.o \
s-ctype-isalnum.o s-ctype-isalpha.o s-ctype-isascii.o s-ctype-iscntrl.o \
s-ctype-isdigit.o s-ctype-isgraph.o s-ctype-islower.o s-ctype-isprint.o \
s-ctype-ispunct.o s-ctype-isspace.o s-ctype-isupper.o s-ctype-isxdigit.o \
s-ctype-toascii.o s-ctype-tolower.o s-ctype-toupper.o s-dirent-closedir.o \
s-dirent-opendir.o s-dirent-readdir.o s-dirent-rewinddir.o \
s-dirent-seekdir.o s-dirent-telldir.o s-fcntl-creat.o s-fcntl-fcntl.o \
s-fcntl-open.o s-fnmatch-fnmatch.o s-grp-endgrent.o s-grp-getgrent.o \
s-grp-getgrgid.o s-grp-getgrnam.o s-grp-setgrent.o s-math-acos.o \
s-math-acosh.o s-math-asin.o s-math-asinh.o s-math-atan.o s-math-atan2.o \
s-math-atanh.o s-math-cbrt.o s-math-ceil.o s-math-copysign.o s-math-cos.o \
s-math-cosh.o s-math-erf.o s-math-erfc.o s-math-exp.o s-math-expm1.o \
s-math-fabs.o s-math-floor.o s-math-fmod.o s-math-frexp.o s-math-hypot.o \
s-math-isnan.o s-math-j0.o s-math-j1.o s-math-jn.o s-math-ldexp.o \
s-math-lgamma.o s-math-log.o s-math-log10.o s-math-log1p.o s-math-modf.o \
s-math-pow.o s-math-rint.o s-math-sin.o s-math-sinh.o s-math-sqrt.o \
s-math-tan.o s-math-tanh.o s-math-y0.o s-math-y1.o s-math-yn.o \
s-netdb-endhostent.o s-netdb-endnetent.o s-netdb-endprotoent.o \
s-netdb-endservent.o s-netdb-gethostbyaddr.o s-netdb-gethostbyname.o \
s-netdb-gethostent.o s-netdb-getnetbyaddr.o s-netdb-getnetbyname.o \
s-netdb-getnetent.o s-netdb-getprotobyname.o s-netdb-getprotobynumber.o \
s-netdb-getprotoent.o s-netdb-getservbyname.o s-netdb-getservbyport.o \
s-netdb-getservent.o s-netdb-sethostent.o s-netdb-setnetent.o \
s-netdb-setprotoent.o s-netdb-setservent.o s-pwd-endpwent.o \
s-pwd-getpwnam.o s-pwd-getpwuid.o s-pwd-setpwent.o s-setjmp-longjmp.o \
s-setjmp-setjmp.o s-signal-kill.o s-signal-raise.o s-signal-sigaddset.o \
s-signal-sigdelset.o s-signal-sigemptyset.o s-signal-sigfillset.o \
s-signal-sigismember.o s-signal-signal.o s-signal-sigpause.o \
s-signal-sigaction.o \
s-signal-sigprocmask.o s-stdio-fclose.o s-stdio-fdopen.o s-stdio-feof.o \
s-stdio-ferror.o s-stdio-fflush.o s-stdio-fgetc.o s-stdio-fgets.o \
s-stdio-fileno.o s-stdio-fopen.o s-stdio-fprintf.o s-stdio-fputc.o \
s-stdio-fputs.o s-stdio-fread.o s-stdio-freopen.o s-stdio-fscanf.o \
s-stdio-fseek.o s-stdio-ftell.o s-stdio-fwrite.o s-stdio-getc.o \
s-stdio-getchar.o s-stdio-gets.o s-stdio-getw.o s-stdio-pclose.o \
s-stdio-perror.o s-stdio-popen.o s-stdio-printf.o s-stdio-putc.o \
s-stdio-putchar.o s-stdio-puts.o s-stdio-putw.o s-stdio-remove.o \
s-stdio-rename.o s-stdio-rewind.o s-stdio-scanf.o s-stdio-setbuf.o \
s-stdio-setvbuf.o s-stdio-sprintf.o s-stdio-sscanf.o s-stdio-tempnam.o \
s-stdio-tmpfile.o s-stdio-tmpnam.o s-stdio-ungetc.o s-stdio-vfprintf.o \
s-stdio-vprintf.o s-stdio-vsprintf.o s-stdlib-abort.o s-stdlib-abs.o \
s-stdlib-atexit.o s-stdlib-atof.o s-stdlib-atoi.o s-stdlib-atol.o \
s-stdlib-bsearch.o s-stdlib-div.o s-stdlib-drand48.o s-stdlib-erand48.o \
s-stdlib-exit.o s-stdlib-getenv.o s-stdlib-jrand48.o s-stdlib-labs.o \
s-stdlib-lcong48.o s-stdlib-ldiv.o s-stdlib-lrand48.o s-stdlib-mrand48.o \
s-stdlib-nrand48.o s-stdlib-putenv.o s-stdlib-qsort.o s-stdlib-rand.o \
s-stdlib-seed48.o s-stdlib-srand.o s-stdlib-srand48.o s-stdlib-strtod.o \
s-stdlib-strtol.o s-stdlib-strtoul.o s-stdlib-system.o s-string-memchr.o \
s-string-bcopy.o \
s-string-memcmp.o s-string-memcpy.o s-string-memmove.o s-string-memset.o \
s-string-strcasecmp.o s-string-strcat.o s-string-strchr.o s-string-strcmp.o \
s-string-strcoll.o s-string-strcpy.o s-string-strcspn.o s-string-strdup.o \
s-string-strerror.o s-string-strlen.o s-string-strncasecmp.o \
s-string-strncat.o s-string-strncmp.o s-string-strncpy.o \
s-string-strpbrk.o s-string-strrchr.o s-string-strspn.o s-string-strstr.o \
s-string-strtok.o s-sys_resource-getrlimit.o s-sys_resource-setrlimit.o \
s-sys_socket-accept.o s-sys_socket-bind.o s-sys_socket-connect.o \
s-sys_socket-getpeername.o s-sys_socket-getsockname.o \
s-sys_socket-getsockopt.o s-sys_socket-listen.o s-sys_socket-recv.o \
s-sys_socket-recvfrom.o s-sys_socket-send.o s-sys_socket-sendto.o \
s-sys_socket-setsockopt.o s-sys_socket-shutdown.o s-sys_socket-socket.o \
s-sys_socket-socketpair.o s-sys_stat-chmod.o s-sys_stat-fchmod.o \
s-sys_stat-fstat.o s-sys_stat-lstat.o s-sys_stat-mkdir.o \
s-sys_stat-mkfifo.o s-sys_stat-mknod.o s-sys_stat-stat.o \
s-sys_stat-umask.o s-sys_time-getitimer.o s-sys_time-setitimer.o \
s-sys_uio-readv.o s-sys_uio-writev.o s-sys_utsname-uname.o \
s-sys_wait-wait.o s-sys_wait-waitpid.o s-time-asctime.o s-time-clock.o \
s-time-ctime.o s-time-difftime.o s-time-gmtime.o s-time-localtime.o \
s-time-mktime.o s-time-strftime.o s-time-time.o s-time-tzset.o \
s-unistd-_exit.o s-unistd-access.o s-unistd-acct.o s-unistd-alarm.o \
s-unistd-chdir.o s-unistd-chown.o s-unistd-close.o s-unistd-dup.o \
s-unistd-dup2.o s-unistd-execl.o s-unistd-execlp.o s-unistd-execv.o \
s-unistd-execve.o s-unistd-execvp.o s-unistd-fchdir.o s-unistd-fchown.o \
s-unistd-fork.o s-unistd-fpathconf.o s-unistd-fsync.o \
s-unistd-gethostname.o \
s-unistd-ftruncate.o s-unistd-getcwd.o s-unistd-getegid.o \
s-unistd-geteuid.o s-unistd-getgid.o s-unistd-getgroups.o \
s-unistd-getlogin.o s-unistd-getpgrp.o s-unistd-getpid.o \
s-unistd-getppid.o s-unistd-getuid.o s-unistd-isatty.o s-unistd-link.o \
s-unistd-llseek.o s-unistd-lseek.o s-unistd-nice.o s-unistd-pathconf.o \
s-unistd-pause.o s-unistd-pipe.o s-unistd-read.o s-unistd-readlink.o \
s-unistd-rmdir.o s-unistd-setegid.o s-unistd-seteuid.o s-unistd-setgid.o \
s-unistd-setpgid.o s-unistd-setpgrp.o s-unistd-setsid.o s-unistd-setuid.o \
s-unistd-sleep.o s-unistd-symlink.o s-unistd-sync.o s-unistd-sysconf.o \
s-unistd-_sysconf.o s-unistd-mktemp.o \
s-unistd-tcgetpgrp.o s-unistd-tcsetpgrp.o s-unistd-truncate.o \
s-unistd-ttyname.o s-unistd-unlink.o s-unistd-vfork.o s-unistd-vhangup.o \
s-unistd-write.o s-utime-utime.o s-assert-__eprintf.o \
s-dirent-chkr_func.o s-grp-chkr_func.o s-sys_socket-chkr_func.o \
s-sys_socket-chkr_func.o s-sys_stat-chkr_func.o s-sys_times-times.o \
s-locale-setlocale.o \
s-sys_mman-mmap.o s-sys_mman-munmap.o stubs-malloc.o check-printf.o \
vsscanf.o end-stubs.o
STUB_CFLAGS = -O2 -Wall -c -g $(CPPFLAGS)

TARGET=libchecker.a

@rules
symctl.in: $(srcdir)/common.symctl $(srcdir)/lib/stubs-syscalls.symctl \
	   $(srcdir)/config/sparc/solaris2/gccchecker.symctl
	cat $(srcdir)/common.symctl $(srcdir)/lib/stubs-syscalls.symctl \
	    $(srcdir)/config/sparc/solaris2/gccchecker.symctl > symctl.in

gccchecker.o: $(OBJS) symctl symctl.in
	$(LD) $(LDFLAGS_FOR_CHKR) -o gccchecker.o $(OBJS)
	./symctl -s symctl.in gccchecker.o

libchecker.a: gccchecker.o $(STUB_OBJS)
	$(AR) rcv libchecker.a gccchecker.o $(STUB_OBJS)

update: libchecker.a
	$(INSTALL_DATA) libchecker.a $(libdir)

fast-update: gccchecker.o
	$(AR) rv $(libdir)/libchecker.a gccchecker.o

install: libchecker.a checker install.dir install.stubs install.common
	echo done.

uninstall: uninstall.stubs uninstall.common

vsscanf.o: $(srcdir)/config/sparc/solaris2/vsscanf.c
	$(CC) $(STUB_CFLAGS) $(srcdir)/config/sparc/solaris2/vsscanf.c -o $@

#$(STUB_OBJS):
#	$(CC) $(STUB_CFLAGS) $(srcdir)/utils/$*.c -o $@

#libstubs.a: $(STUB_OBJS)
#	$(AR) rcv libstubs.a $(STUB_OBJS)

endifgccchecker

