{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Access functions for I/O ports for GPC on an x86 platform. This unit
is NOT portable. It works only on x86 platforms (tested under Linux
and DJGPP). It is provided here only to serve as a replacement for
BP's Port and PortW pseudo arrays.

This Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation, version 2.

This Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
}

{$ifndef __i386__}
{$error The Ports unit is only for the x86 platform}
{$endif}

unit Ports;

interface

{ Port access functions }
function  InPortB  (Port : ShortWord) : Byte;
function  InPortW  (Port : ShortWord) : ShortWord;
procedure OutPortB (Port : ShortWord; Val : Byte);
procedure OutPortW (Port, Val : ShortWord);

{ Functions from the C library for getting access to the ports -- only
  for root processes, of course. Dummies under DJGPP. }
function  IOPerm (From, Num : MedCard; On : Integer) : Integer; C;
function  IOPL (Level : Integer) : Integer; C;

{ In order to give up root privileges after getting access to the ports
  for setuid root programs. }
function  GetUID : Integer; C;
function  SetEUID (EUID : Integer) : Integer; C;

implementation

function InPortB (Port : ShortWord) : Byte;
var Result : volatile Byte; (*@@*)
begin
  asm ('inb %%dx, %%al' : '=a' (Result) : 'd' (Port) : 'ax', 'dx');
  InPortB := Result
end;

function InPortW (Port : ShortWord) : ShortWord;
var Result : volatile ShortWord; (*@@*)
begin
  asm ('inb %%dx, %%al' : '=a' (Result) : 'd' (Port) : 'ax', 'dx');
  InPortW := Result
end;

procedure OutPortB (Port : ShortWord; Val : Byte);
begin
  asm ('outb %%al, %%dx' : : 'd' (Port), 'a' (Val) : 'ax', 'dx')
end;

procedure OutPortW (Port, Val : ShortWord);
begin
  asm ('outw %%ax, %%dx' : : 'd' (Port), 'a' (Val) : 'ax', 'dx')
end;

{$ifdef MSDOS}

function IOPerm (From, Num : MedCard; On : Integer) : Integer;
begin
  IOPerm := 0
end;

function IOPL (Level : Integer) : Integer;
begin
  IOPL := 0
end;

function SetEUID (EUID : Integer) : Integer;
begin
  SetEUID := 0
end;

{$endif}

end.
