{

 This program tests gpc's constants definitions

 The testdata is taken from iso/iec 10206: 6.3.2

} 

(* BUG: Extended Pascal initializers do not work. *)

program Test(output);

const
  limit	=  43;
  

type
  indextype   = 1..limit;
  sieve	      = set of 1..20;
  vector      = array[indextype] of real;
  quiver      = array[1..10] of vector;
  PunchedCard = array[1..80] of char;
  angle	      = real value 0.0;
  subpolar    = record
		  r	: real;
		  theta	: angle;
		end;	


const
  unity		= 1.0;
  third		= unity/3.0;
  SmallPrimes	= sieve[2,3,5,7,11,13,17,19];
  ZeroVector	= vector[1..limit: 0.0];
  UnitVector	= vector[1: unity otherwise 0];
  ZeroQuiver	= quiver[otherwise ZeroVector];
  BlankCard	= PunchedCard[1..80: ' '];
  blank		= ' ';
  Unit		= subpolar[r:1; theta:0.0];
  Unit_Distance	= Unit.r;
  Origin	= subpolar[r,theta:0.0];
  thrust	= 5.3;
  theta		= -2.0;
  warp		= subpolar[r:thrust;theta:theta];
  column1	= BlankCard[1];
  MaxMatrix	= 39;
  pi		= 4 * arctan(1);
  hex_string	= '0123456789ABCDEF';
  hex_digits	= hex_string[1..10];
  mister	=  'Mr.';

{ Prospero doesn't compile this one... }
const
  hex_alpha	= hex_string[index(hex_string,'A')..index(hex_string,'F')];
  
 

begin
  writeln('OK');
end.

   
