/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -p -j1 -g -G -o -t -N is_reserved_word ./gpc.gperf  */ 
/* ISO Pascal 7185 && Extended Pascal (Jan 29, 1989 Draft) reserved words.

   Copyright (C) 1989, 1993, Free Software Foundation, Inc.

This file is part of GNU GPC.

GNU GPC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU GPC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GPC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * For GNU Pascal compiler (GPC) by Jukka Virtanen, jtv@hut.fi
 *
 * run this through the Doug Schmidt's gperf program
 * with command
 * gperf  -g -o -j1 -t -p -N is_reserved_word
 *
 * Thanks, Doug.
 */

/* ISO 7185 Standard Pascal keywords are recognized as keywords.
 *
 * To treat ISO 10206 Extended Pascal keywords as keywords,
 * you must give -fextended-pascal when compiling.
 *
 * To treat Object Pascal keywords as keywords, give
 * -fobject-pascal.
 *
 * And so on.
 *
 * Otherwise they are recognized, but may be redfined.
 * This violates Extended Pascal standard, but works anyhow,
 * if your program does not redefine them. And it also makes
 * ISO standard pascal program compile without modifications 
 * with GPC.
 *
 * Keywords are dynamically enabled and disabled such that a
 * correct ISO Pascal program will not notice foreign keywords
 * at all.  If you change this, extensions won't work.
 */


struct resword { char *name;
		 short token;
		 char informed;
		 char disabled;
		 unsigned long iclass;
	       };

#define TOTAL_KEYWORDS 82
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 14
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 90
/* maximum key range = 89, duplicates = 0 */

#ifdef __GNUC__
inline
#endif
static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
     91, 91, 91, 91, 91, 52, 23, 77, 74, 23,
     55,  0, 91,  0, 91, 91, 51, 31,  9, 34,
      1,  2, 33, 45, 81,  9, 64, 23, 30, 91,
     91, 91, 91, 91, 91, 91, 91, 91, 91,  0,
     13,  0, 14, 15,  8, 91, 91, 91,  7, 24,
      1,  0, 91, 91,  0,  0,  5, 91,  0, 22,
     91, 16, 91, 91, 91, 91, 91, 91,
    };
  return len + asso_values[str[len - 1]] + asso_values[str[0]];
}

static struct resword wordlist[] =
{
      {"",}, {"",}, 
      {"Is", 		OP_IS,		0,  0,	O_D_G_PASCAL},
      {"In", 		IN,		0,  0,	ANY_PASCAL},
      {"Goto", 		GOTO,		0,  0,	ANY_PASCAL},
      {"",}, 
      {"Inline", 		INLINE,		0,  0,	GNU_PASCAL},
      {"Public", 		BP_PUBLIC,	0,  1,	B_D_G_PASCAL},
      {"Private", 	BP_PRIVATE,	0,  1,	B_D_G_PASCAL},
      {"Interface", 	INTERFACE,	0,  1,	E_O_U_B_D_G_PASCAL},
      {"Procedure",  	PROCEDURE, 	0,  0,	ANY_PASCAL},
      {"Import",  	IMPORT, 	0,  0,	E_O_G_PASCAL},
      {"",}, 
      {"Uses", 		BP_USES,	0,  0,	U_B_D_G_PASCAL},
      {"Interrupt", 	BP_INTERRUPT,	0,  0,	B_D_PASCAL},
      {"Implementation", 	IMPLEMENTATION,	0,  1,	E_O_U_B_D_G_PASCAL},
      {"If", 		IF,		0,  0,	ANY_PASCAL},
      {"Not", 		NOT_,		0,  0,	ANY_PASCAL},
      {"Unit", 		BP_UNIT,	0,  0,	U_B_D_G_PASCAL},
      {"Nil", 		NIL_,		0,  0,	ANY_PASCAL},
      {"Packed", 		PACKED,		0,  0,	ANY_PASCAL},
      {"Until", 		UNTIL,		0,  0,	ANY_PASCAL},
      {"Inherited", 	OP_INHERITED,	0,  1,	O_B_D_G_PASCAL},
      {"Protected",  	PROTECTED, 	0,  1,	E_O_D_G_PASCAL},
      {"Qualified",  	QUALIFIED, 	0,  0,	E_O_G_PASCAL},
      {"Property", 	OP_PROPERTY, 	0,  0,	O_D_G_PASCAL},
      {"Pow",     	POW,    	0,  0,	E_O_G_PASCAL},
      {"Else", 		ELSE,		0,  0,	ANY_PASCAL},
      {"While", 		WHILE,		0,  0,	ANY_PASCAL},
      {"Begin", 		BEGIN,		0,  0,	ANY_PASCAL},
      {"Exports",  	BP_EXPORTS, 	0,  0,	B_D_G_PASCAL},
      {"Bindable",  	BINDABLE,	0,  0,	E_O_G_PASCAL},
      {"Program",    	PROGRAM,   	0,  0,	ANY_PASCAL},
      {"Xor", 		BP_XOR,		0,  0,	B_D_G_PASCAL},
      {"Export",  	EXPORT, 	0,  0,	E_O_B_D_G_PASCAL},
      {"With", 		WITH,		0,  0,	ANY_PASCAL},
      {"Or", 		OR,		0,  0,	ANY_PASCAL},
      {"Module",  	MODULE, 	0,  0,	E_O_G_PASCAL},
      {"External", 	D_EXTERNAL,	0,  1,  E_O_U_B_D_G_PASCAL},
      {"End", 		END,		0,  0,	ANY_PASCAL},
      {"",}, 
      {"Or_else",  	OR_ELSE, 	0,  0,	E_O_G_PASCAL},
      {"Operator", 	PXSC_OPERATOR,	0,  0,	SC_G_PASCAL},
      {"Otherwise",  	OTHERWISE, 	0,  1,	E_O_G_PASCAL},
      {"Repeat", 		REPEAT,		0,  0,	ANY_PASCAL},
      {"Object", 		BP_OBJECT,	0,  1,	B_D_G_PASCAL},
      {"Resident", 	BP_RESIDENT,	0,  0,	B_D_PASCAL},
      {"Mod", 		MOD_,		0,  0,	ANY_PASCAL},
      {"Shr", 		BP_SHR,		0,  0,	B_D_G_PASCAL},
      {"",}, 
      {"Of", 		OF,		0,  0,	ANY_PASCAL},
      {"Static", 		D_STATIC,	0,  1,	GNU_PASCAL},
      {"Record", 		RECORD,		0,  0,	ANY_PASCAL},
      {"Set", 		SET_,		0,  0,	ANY_PASCAL},
      {"Only",    	ONLY,   	0,  0,	E_O_G_PASCAL},
      {"Shl", 		BP_SHL,		0,  0,	B_D_G_PASCAL},
      {"Restricted",    	RESTRICTED,	0,  0,	E_O_G_PASCAL},
      {"Segment", 	UCSD_SEGMENT,	0,  0,	UCSD_PASCAL},
      {"For", 		FOR,		0,  0,	ANY_PASCAL},
      {"File", 		FILE_,		0,  0,	ANY_PASCAL},
      {"Absolute", 	BP_ABSOLUTE,	0,  1, 	B_D_G_PASCAL},
      {"And_then",  	AND_THEN, 	0,  0,	E_O_G_PASCAL},
      {"All", 		ALL,		0,  1,	GNU_PASCAL},
      {"Label", 		LABEL,		0,  0,	ANY_PASCAL},
      {"Function",  	FUNCTION, 	0,  0,	ANY_PASCAL},
      {"Abstract", 	OP_ABSTRACT,	0,  1,	O_G_PASCAL},
      {"String", 		STRING_KEYWORD,	0,  1,	B_D_G_PASCAL},
      {"Var", 		VAR,		0,  0,	ANY_PASCAL},
      {"And", 		AND_,		0,  0,	ANY_PASCAL},
      {"Value",   	VALUE,  	0,  1,	E_O_G_PASCAL},
      {"",}, {"",}, 
      {"Volatile", 	D_VOLATILE,	0,  1,	GNU_PASCAL},
      {"Array", 		ARRAY,		0,  0,	ANY_PASCAL},
      {"Library", 	BP_LIBRARY,	0,  1,	B_D_G_PASCAL},
      {"Forward", 	D_FORWARD,	0,  0,	U_B_D_G_PASCAL},
      {"Do", 		DO,		0,  0,	ANY_PASCAL},
      {"Div", 		DIV_,		0,  0,	ANY_PASCAL},
      {"Virtual", 	BP_VIRTUAL,	0,  1,	O_B_D_G_PASCAL},
      {"Asm", 	        ASM_KEYWORD,	0,  0,	B_D_GH_PASCAL},
      {"Downto",  	DOWNTO,		0,  0,	ANY_PASCAL},
      {"Case", 		CASE,		0,  0,	ANY_PASCAL},
      {"Class", 		OP_CLASS,	0,  1,	O_D_G_PASCAL},
      {"To", 		TO,		0,  0,	ANY_PASCAL},
      {"Destructor", 	OP_DESTRUCTOR,	0,  1,	O_B_D_G_PASCAL},
      {"Type", 		TYPE,		0,  0,	ANY_PASCAL},
      {"Then", 		THEN,		0,  0,	ANY_PASCAL},
      {"Const", 		CONST_,		0,  0,	ANY_PASCAL},
      {"Constructor", 	OP_CONSTRUCTOR,	0,  1,	O_B_D_G_PASCAL},
      {"",}, 
      {"View", 		OP_VIEW,	0,  0,	O_G_PASCAL},
};

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word (str, len)
     register char *str;
     register unsigned int len;
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
