{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Demo program for the RegEx unit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

program RegExDemo;

uses RegEx;

var
  a : String(100);
  r : RegExType;
  i, j, p, l, o : Integer;
  x, c, s, n, b, e : Boolean = False;

begin
  Writeln ('Enter options: e(X)tended, (C)ase-insensitive, no (S)ubexpressions, (N)ewlines,');
  Write ('no (B)eginning/(E)nd of line: ');
  Readln (a);
  for i := 1 to Length (a) do
    case UpCase (a [i]) of
      'X' : x := True;
      'C' : c := True;
      'S' : s := True;
      'N' : n := True;
      'B' : b := True;
      'E' : e := True;
      else Writeln ('Invalid option `', a [i], '''')
    end;
  Write ('Enter regular expression: ');
  Readln (a);
  NewRegEx (r, a, x, c, s, n);
  if r.Error <> nil then
    begin
      Writeln (CString2String (r.Error));
      Halt
    end;
  Writeln ('The regex contains ', r.SubExpressions, ' subexpressions.');
  repeat
    Writeln ('Enter a string to match (empty string to quit):');
    Readln (a);
    if a = '' then Break;
    Write ('Search from position: ');
    Readln (o);
    Writeln (a);
    if not MatchRegExFrom (r, a, b, e, o)
      then Writeln (CString2String (r.Error))
      else
        for i := 0 to r.SubExpressions do
          begin
            GetMatchRegEx (r, i, p, l);
            if p = 0
              then Writeln ('-')
              else
                begin
                  Write ('' : p - 1);
                  if l = 0
                    then Write ('0')
                    else for j := 1 to l do Write ('^');
                  Writeln
                end
          end
  until False;
  DisposeRegEx (r)
end.
