# $Id$
#
# Copyright (C) 1997  Klee Dienes <klee@mit.edu>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys, os, posix

class filter:

	def __init__ (self, f, cmd):

		(ri, wi) = os.pipe ()
		(ro, wo) = os.pipe ()
		(re, we) = os.pipe ()

		self.filter = os.fork ()
		if (self.filter == 0):
			sys.argv[0] = sys.argv[0] + "[filter]"
			for i in [ri, wi, ro, wo, re, we, 0, 1, 2]:
				if (i not in [ri, wo, we]):
					try:
						os.close (i)
					except posix.error, val: 
						pass
			os.dup2 (ri, 0)
			os.dup2 (wo, 1)
			os.dup2 (we, 2)
			os.system (cmd)
			os.close (0)
			os.close (1)
			os.close (2)
			os._exit (0)

		self.writer = os.fork ()
		if (self.writer == 0):
			sys.argv[0] = sys.argv[0] + "[source]"
			for i in [ri, wi, ro, wo, re, we, 0, 1, 2]:
				if (i not in [wi]):
					try:
						os.close (i)
					except posix.error, val: 
						pass
			nf = os.fdopen (wi, 'w')
			s = f.read ()
			nf.write (s)
			nf.flush ()
			os.close (wi)
			os._exit (0)

		for i in [ri, wi, ro, wo, re, we]:
			if (i not in [ro, re]):
				os.close (i)

		self.o = os.fdopen (ro, 'r')
		self.pos = 0
		self.blocksize = 16 * 1024

		self.e = os.fdopen (re, 'r')
		self.epos = 0

	def isatty (self):
		return 0

	def seek (self, offset, mode = 0):
		#print 'filter: seek %d (cur %d)' % (offset, self.tell ())
		while (self.tell () < offset):
			self.read (min (self.blocksize, offset - self.tell()))
		if (offset < self.tell()):
			raise ValueError, 'unable to seek backwards on stream'

	def tell (self):
		#print 'filter: tell %d' % self.pos
		return self.pos

	def read (self, n = -1):
		r = self.o.read (n)
		#print 'filter: read %d bytes from %d' % (len (r), self.pos)
		self.pos = self.pos + len (r)
		return r

	def readline (self):
		r = self.o.readline ()
		self.pos = self.pos + len (r)
		return r

	def readlines (self):
		rl = self.o.readlines ()
		for r in rl:
			self.pos = self.pos + len (r)
		return rl

	def stderr (self):
		return self.e

	def close (self):
		self.o.close ()
		self.e.close ()
		pid, status = os.wait ()
		#print pid, status
		if (status != 0):
			raise ValueError, 'sub-process returned error exit status %d' % status
		pid, status = os.wait ()
		#print pid, status
		if (status != 0):
			raise ValueError, 'sub-process returned error exit status %d' % status
