/* mouse.h				-*- C++ -*-
   $Id: mouse.h,v 1.3 1998/09/07 00:49:34 elf Exp $
   
   written by Marc Singer
   12 Nov 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   Mouse handling header

*/


#if !defined (__MOUSE_H__)
#    define   __MOUSE_H__

/* ----- Includes */

#if defined (USE_GPM_MOUSE)
extern "C" {
# include <gpm.h>
}
#endif

class LMouse {
protected:
  static bool g_fConnected;

public:
  LMouse () {
    zero (); }			// It is VERY significant that we don't init ()
  ~LMouse () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (void);
  void release_this (void);

#if defined (USE_GPM_MOUSE)
  static int handler (Gpm_Event* pEvent, void* pvUser);
#endif
};


#endif  /* __MOUSE_H__ */
