/* mouse.cxx
     $Id: mouse.cxx,v 1.3 1998/02/23 06:35:45 elf Exp $

   written by Marc Singer
   12 November 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   -----------
   DESCRIPTION
   -----------

*/

#include "std.h"

#include "mouse.h"

bool LMouse::g_fConnected;

void LMouse::init (void)
{
#if defined (USE_GPM_MOUSE)
  Gpm_Connect gpmconnect;
  memset (&gpmconnect, 0, sizeof (gpmconnect));

				// -- Trap all events
  gpmconnect.eventMask=~0;
  gpmconnect.defaultMask=0;
  gpmconnect.maxMod=~0;
  gpmconnect.minMod=0;

  if (Gpm_Open (&gpmconnect, 0) >= 0) {
    g_fConnected = true;
    gpm_handler = handler;
    TRACE((T_MOUSE_INFO, "gpm mouse handler installed"));
  }
  else
    TRACE((T_MOUSE_INFO, "failed to install gpm mouse handler"));
#endif
}

#if defined (use_gpm_mouse)
int LMouse::handler (Gpm_Event* pEvent, void* pvUser)
{
  switch (GPM_BARE_EVENTS (pEvent->type)) {
  case GPM_MOVE:
    TRACE((T_MOUSE_TRACE, "mouse move <%04x> [%2d %2d] [%3d %3d]", 
       pEvent->type,
       pEvent->x, pEvent->y, pEvent->dx, pEvent->dy));
    break;
  case GPM_DRAG:
    TRACE((T_MOUSE_TRACE, "mouse drag <%04x> [%2d %2d] [%3d %3d]", 
       pEvent->type,
       pEvent->x, pEvent->y, pEvent->dx, pEvent->dy));
    break;
  case GPM_DOWN:
    TRACE((T_MOUSE_TRACE, "mouse down <%04x> [%2d %2d] [%3d %3d] %d %d", 
       pEvent->type,
       pEvent->x, pEvent->y, pEvent->dx, pEvent->dy, 
       pEvent->buttons, pEvent->modifiers));
    break;
  case GPM_UP:
    TRACE((T_MOUSE_TRACE, "mouse up   <%04x> [%2d %2d] [%3d %3d] %d %d", 
       pEvent->type,
       pEvent->x, pEvent->y, pEvent->dx, pEvent->dy, 
       pEvent->buttons, pEvent->modifiers));
    break;
  default:
    TRACE((T_MOUSE_TRACE, "<0x%x> b %d  m %d  [%d %d] [%d %d]  t %d", 
       pvUser,
       pEvent->buttons, pEvent->modifiers, 
       pEvent->x, pEvent->y,
       pEvent->dx, pEvent->dy, pEvent->type));
    break;
  }
  return 0;
}
#endif

void LMouse::release_this (void)
{
  if (g_fConnected) {
#if defined (USE_GPM_MOUSE)
    Gpm_Close ();
#endif
    g_fConnected = false;
  }
}

