/* cvs.h							-*- C++ -*-
     $Id: cvs.h,v 1.12 1998/09/10 20:50:09 elf Exp $

   written by Marc Singer
   21 September 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

   -----------
   DESCRIPTION
   -----------

   Header for CVS specifc features.

*/

#if !defined (_CVS_H_)
#    define   _CVS_H_

#include "directory.h"

typedef enum {
  flagTag		= 0x00001,
//flagReadOnly		= 0x00002, 	// Read only in filesystem
  flagBinary		= 0x00004,	// File guessed (or implicated) binary
  flagControlled	= 0x00100,	// File is under source control
  flagIgnored		= 0x00200,	// File ignored by source control
  flagEdited		= 0x00400,	// Local copy modified since last sync
  flagAdded		= 0x00800,	// Pending add
  flagRemoved		= 0x01000,	// Pending remove
  flagCommented		= 0x02000,	// Change comment present
  flagStatusPatch	= 0x10000, 	// CVS reports file needs patch
  flagStatusMerge	= 0x20000,	// CVS reports file needs merge
  flagStatusCheckout	= 0x40000,	// CVS reports file needs checkout
  flagStatusConflict    = 0x80000, 	// CVS reports file has merge conflict
  flagTransient		= 0xf1f00,	// Flags to update during parse_status
} eFileFlag;


class LCVS {
protected:
  LDirectory* m_pDir;		// Working directory as LDirectory
  //  char* m_szPath;		//   or pathname.  Exclusive members.
  static char* g_pchIgnore;	// Global, default ignore patterns
  char* m_pchIgnore;		// List of locally ignored patterns

  char* m_szFileStatus;		// Temporary file containing status info
  
  bool m_fControlled;		// When false, this directory is not controlled
  bool m_fRemote;		// TRUE: repository is remote

  time_t m_timeEntries;		// Time stamp on CVS/Entries file
  time_t m_timeDirectory;	// Time stamp on directory (m_pDir)

  time_t recover_time (char* pch, int cch);

  bool _is_ok (int iFile) {
    return m_pDir && (iFile > 0) && (iFile < m_pDir->count_files ()); }
  bool _is_ignored (const char* szFile);

  void clear_flag (int iFile, int flag) {
    m_pDir->set_user (iFile, (void*) (int (m_pDir->user (iFile)) & ~flag)); }
  int flag (int iFile) {
    return (int) m_pDir->user (iFile); }
  static int flag (FILE_INFO* pInfo) {
    return (int) LDirectory::user (pInfo); }
  void set_flag (int iFile, int flag) {
    m_pDir->set_user (iFile, (void*) (int (m_pDir->user (iFile)) | flag)); }
  int set_version (char* pch, int cch);

  static char* _parse_ignore (char* pch);
  
public:
  LCVS () {
    zero (); }
  LCVS (LDirectory* pDir) {
    zero (); init (pDir); }
  ~LCVS () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (LDirectory* pDir);
  void release_filestatus ();
  void release_this ();

  void analyze (void);
  void fetch_status (const char* szFiles = NULL);
  bool is_controlled (void) {
    return m_fControlled != 0; }
  bool is_controlled (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagControlled) != 0); }
  static bool is_controlled (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagControlled) != 0; }
  bool is_edited (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagEdited) != 0); }
  static bool is_edited (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagEdited) != 0; }
  bool is_binary (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagBinary) != 0); }
  static bool is_binary (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagBinary) != 0; }
  bool is_ignored (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagIgnored) != 0); }
  static bool is_ignored (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagIgnored) != 0; }
  bool is_tagged (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagTag) != 0); }
  static bool is_tagged (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagTag) != 0; }
  static bool is_status_added (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagAdded) != 0; }
  static bool is_status_removed (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagRemoved) != 0; }
  bool is_status_checkout (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagStatusCheckout) != 0); }
  static bool is_status_checkout (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagStatusCheckout) != 0; }
  bool is_status_merge (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagStatusMerge) != 0); }
  static bool is_status_merge (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagStatusMerge) != 0; }
  bool is_status_patch (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagStatusPatch) != 0); }
  static bool is_status_patch (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagStatusPatch) != 0; }
  bool is_status_conflict (int iFile) {
    return _is_ok (iFile) && ((flag (iFile) & flagStatusConflict) != 0); }
  static bool is_status_conflict (FILE_INFO* pInfo) {
    return (flag (pInfo) & flagStatusConflict) != 0; }

  void parse_status (void);
  int flags (int iFile) {
    if (_is_ok (iFile))
      return (int) m_pDir->user (iFile);
    else
      return 0; }
  void tag (int iFile, bool fTag) {
    if (_is_ok (iFile)) {
      if (fTag)
	set_flag (iFile, flagTag);
      else
	clear_flag (iFile, flagTag); }}
  void binary (int iFile, bool fBinary) {
    if (_is_ok (iFile)) {
      if (fBinary)
	set_flag (iFile, flagBinary);
      else
	clear_flag (iFile, flagBinary); }}
};

#endif /* _CVS_H_ */
