#ifndef boot_fs_h
#define boot_fs_h

#include <linux/types.h>

struct bootfs {
	int	fs_type;
	int	blocksize;
	
	int	(*mount)(long dev, long partition_start, long quiet);

	int	(*open)(const char *filename);
	int	(*bread)(int fd, long blkno, long nblks, char *buf);
	void	(*close)(int fd);
} ext2fs;

#endif /* boot_fs_h */
