//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#ifndef _XOSVIEW_H_
#define _XOSVIEW_H_

#include "xwin.h"

class Meter;

class XOSView : public XWin {
public:
  XOSView( int argc, char *argv[] );
  ~XOSView( void );

  void resize( void );
  void draw( void );
  void run( void );
  void keyrelease( char *ch );
  const char *winname( void );
protected:

  class MeterNode {
  public:
    MeterNode( Meter *fm ) { meter_ = fm;  next_ = NULL; }

    Meter *meter_;
    MeterNode *next_;
  };

  MeterNode *meters_;
  
  int legend_, xoff_, yoff_, nummeters_, doterm_, usedlabels_, ints_;
  int serial_[4];
  float netmax_;

  void usleep( unsigned long usec );
  void addmeter( Meter *fm );
  void checkMeterResources( void );

  int findx( void );
  int findy( void );
  void dolegends( void );
  int newypos( void );
  void parseargs( int argc, char *argv[] );
  void resizeEvent( XEvent &event ) { resize(); draw(); }
  void exposeEvent( XExposeEvent &event ) { if ( event.count == 0 ) draw(); }
  void keyPressEvent( XKeyEvent &event );
private:
};

#endif
