#ifndef _SLRN_FEATURES_H
#define _SLRN_FEATURES_H

/* If you enable local SPOOL support, you must also enable NNTP support
 * or INEWS support.  Also, see below for filenames regarding the location
 * of the local spool and inews.  Currently only unix supports this.
 */
#define SLRN_HAS_NNTP_SUPPORT   1
#define SLRN_HAS_SPOOL_SUPPORT	0
#define SLRN_HAS_INEWS_SUPPORT	0

/* Set this to 1 to force the user to use INEWS for posting.  This also means
 * that slrn will use the hardcoded inews program pathname.
 */
#define SLRN_FORCE_INEWS	0    

#define SLRN_HAS_SPOILERS	1
#define SLRN_HAS_MIME		1

#ifdef VMS
# define SLRN_HAS_PIPING	0
# define SLRN_HAS_DECODE	0
#else
# define SLRN_HAS_DECODE	1
# define SLRN_HAS_PIPING	1
#endif

/* If non-zero, an rn style lock file will be created if .newsrc is the newsrc
 * file.
 */
#if defined(VMS) || defined(__os2__)
# define SLRN_HAS_RNLOCK	0
#else
# define SLRN_HAS_RNLOCK	1
#endif

/* ----------------  LOCAL SPOOL and INEWS filenames and configuration ----------------------- */

#if SLRN_HAS_SPOOL_SUPPORT || SLRN_HAS_INEWS_SUPPORT
  /* Note the -S flag.  slrn appends the signature to the file to be posted and
   * the -S flag tells inews not to also do this.  The -h flag must be used.
   */
# define SLRN_INEWS_PROGRAM      "/usr/local/bin/inews -S -h"

  /* Root directory names */
# define SLRN_SPOOL_ROOT	"/export/news"
  /* SLRN_NOV_ROOT gives the root directory for overview files
   * if you don't have overview files, leave as SLRN_SPOOL_ROOT for now */
# define SLRN_SPOOL_NOV_ROOT	SLRN_SPOOL_ROOT
  /* SLRN_NOV_FILE gives filename for overview file in each directory */
# define SLRN_SPOOL_NOV_FILE	".overview"

# define SLRN_SPOOL_INNROOT	"/export/opt/inn"
  /* If the following filenames are relative ones, they are considered to be
   * relative to SLRN_SPOOL_INNROOT.
   */
# define SLRN_SPOOL_ACTIVE	"data/active"
# define SLRN_SPOOL_ACTIVETIMES	"data/active.times"
# define SLRN_SPOOL_NEWSGROUPS	"data/newsgroups"

  /* set to 1 to allow scanning the active file for article ranges if there's
   * no .overview file -- if 0 or no active file, then look at filenames in
   * the spool directory instead.  0 seems best... */
# define SPOOL_ACTIVE_FOR_ART_RANGE 0
#endif

/* Default Startup mode.  Should slrn use spool or nntp?  What about default
 * posting agent?
 */
#if SLRN_HAS_NNTP_SUPPORT
# define SLRN_DEFAULT_SERVER_OBJ	SLRN_SERVER_ID_NNTP
# define SLRN_DEFAULT_POST_OBJ		SLRN_POST_ID_NNTP
#else
# define SLRN_DEFAULT_SERVER_OBJ	SLRN_SERVER_ID_SPOOL
# define SLRN_DEFAULT_POST_OBJ		SLRN_POST_ID_INEWS
#endif

#if SLRN_HAS_INEWS_SUPPORT && SLRN_FORCE_INEWS
# undef SLRN_DEFAULT_POST_OBJ
# define SLRN_DEFAULT_POST_OBJ SLRN_POST_ID_INEWS
#endif



/* ---------------- end of INEWS and LOCAL SPOOL configuration ----------- */

#ifdef VMS
/* 
 *                                                            VMS filenames
 */
# define SLRN_USER_SLRNRC_FILENAME	"slrn.rc"
# define SLRN_LETTER_FILENAME		"slrn-letter.txt"
# define SLRN_ARTICLE_FILENAME		"slrn-article.txt"
# define SLRN_FOLLOWUP_FILENAME		"slrn-followup.txt"
# define SLRN_SIGNATURE_FILE		".signature"
# ifndef SLRN_LIB_DIR
#  define SLRN_LIB_DIR			"sys$manager:"
# endif
#else
# ifdef __os2__
/*
 *                                                             OS/2 filenames
 */
#  define SLRN_USER_SLRNRC_FILENAME	"slrn.rc"
#  define SLRN_LETTER_FILENAME		"letter.txt"
#  define SLRN_ARTICLE_FILENAME		"article.txt"
#  define SLRN_FOLLOWUP_FILENAME	"followup.txt"
#  define SLRN_SIGNATURE_FILE		"signatur.txt"
#  define SLRN_SENDMAIL_COMMAND		"sendmail -t"
#  ifndef SLRN_LIB_DIR
#    define SLRN_LIB_DIR		"C:/os2"
#  endif
# else
#  ifdef unix
/* 
 *                                                             Unix filenames
 */
#   define SLRN_USER_SLRNRC_FILENAME	".slrnrc"
#   define SLRN_LETTER_FILENAME	".letter"
#   define SLRN_ARTICLE_FILENAME	".article"
#   define SLRN_FOLLOWUP_FILENAME	".followup"
#   define SLRN_SIGNATURE_FILE		".signature"
#   define SLRN_SENDMAIL_COMMAND	"/usr/lib/sendmail -oi -t -oem -odb"
#   ifndef NNTPSERVER_FILE
#    define NNTPSERVER_FILE		"/usr/local/lib/news/nntp_server"
#   endif
#   ifndef SLRN_LIB_DIR
#    define SLRN_LIB_DIR		"/usr/local/lib/slrn"
#   endif
#  endif			       /* unix */
# endif				       /* os2 */
#endif				       /* vms */

/* #define OUR_ORGANIZATION "organization-name" */
/* #define OUR_HOSTNAME "host.name.here" */
/* #define NNTPSERVER_NAME  "my.server.name" */

#endif				       /* _SLRN_FEATURES_H */
