/*********************************************************************
 *   Copyright 1993, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Header: /upc/share/CVS/netcdf/ncgen/init.c,v 1.9 1995/12/05 00:09:00 russ Exp $
 *********************************************************************/

#include <stdio.h>
#include <netcdf.h>
#include "generic.h"
#include "ncgen.h"

void init_netcdf	PROTO((
    void
    ));

extern int netcdf_flag;
extern int c_flag;
extern int fortran_flag;

struct dims *dims;		/* table of netcdf dimensions */

int ncid;			/* handle for netCDF */
int ndims;			/* number of dimensions declared for netcdf */
int nvars;			/* number of variables declared for netcdf */
int natts;			/* number of attributes */
int nvdims;			/* number of dimensions for variables */
int dimnum;			/* dimension number index for variables */
int varnum;			/* variable number index for attributes */
int valnum;			/* value number index for attributes */
int rec_dim;			/* number of the unlimited dimension, if any */
long var_len;			/* variable length (product of dimensions) */
int var_size;			/* size of each element of variable */
long netcdf_record_number;	/* current record number for variables */

struct vars *vars;		/* a malloc'ed list */

struct atts *atts;		/* table of variable and global attributes */

void
init_netcdf() {			/* initialize global counts, flags */
    extern void clearout();
    
    clearout();			/* reset symbol table to empty */
    ndims = 0;
    nvars = 0;
    rec_dim = -1;		/* means no unlimited dimension (yet) */
}
