/*-
# MOTIF-BASED PANEX(tm)
#
#  xmpanex.c
#
###
#
#  Copyright (c) 1996		David Albert Bagley, bagleyd@hertz.njit.edu
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 5.3: 96/04/30 Xt/Motif
*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#define getlogin cuserid
#else
#ifndef apollo
#include <unistd.h>
#endif
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include "Panex.h"
#include "panex.xbm"
#include "mouse-l.xbm"
#include "mouse-r.xbm"

#ifndef SCOREFILE
#define SCOREFILE "/usr/games/lib/panex.scores"
#endif

/* The following are in PanexP.h also */
#define MINTILES 1
#define HANOI 0
#define PANEX 1
#define MAXMODES 2

#define MAXTILES 10
#define MAXRECORD 65536

static void Initialize(Widget w);
static void CallbackPanex(Widget w, caddr_t clientData,
			  panexCallbackStruct * callData);

static void PrintRecord(int tiles, int mode);
static int  HandleSolved(int counter, int tiles, int mode);
static void ReadRecords(void);
static void WriteRecords(void);

static void motif_print(Widget w, char *text);
static void TileSlider(Widget w, XtPointer clientData,
		       XmScaleCallbackStruct * cbs);
static void ModeToggle(Widget w, int mode, XmToggleButtonCallbackStruct * cbs);

static Arg  arg[2];
static Widget moves, record, message, panex, modes[MAXMODES], tile;
static int  panexRecord[MAXMODES][MAXTILES - MINTILES + 1];
static int  movesDsp = 0;
static char messageDsp[128] = "Welcome";
static char buff[256];

static char *modeString[] =
{
	"Hanoi", "Panex"
};

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xmpanex\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
	"\t[-mono] [-tile {color}] [-{border|bd} {color}] [-tiles {int}]\n");
	(void) fprintf(stderr,
		 "\t[-mode {int}] [-delay msecs] [-pyramid{0|1} {color}]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*panex.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*panex.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-tile", "*panex.tileColor", XrmoptionSepArg, NULL},
	{"-border", "*panex.tileBorder", XrmoptionSepArg, NULL},
	{"-bd", "*panex.tileBorder", XrmoptionSepArg, NULL},
	{"-tiles", "*panex.tiles", XrmoptionSepArg, NULL},
	{"-mode", "*panex.mode", XrmoptionSepArg, NULL},
	{"-hanoi", "*panex.mode", XrmoptionNoArg, "0"},
	{"-panex", "*panex.mode", XrmoptionNoArg, "1"},
	{"-mono", "*panex.mono", XrmoptionNoArg, "TRUE"},
	{"-pyramid0", "*panex.pyramidColor0", XrmoptionSepArg, NULL},
	{"-pyramid1", "*panex.pyramidColor1", XrmoptionSepArg, NULL},
};

int
main(int argc, char **argv)
{
	Widget      toplevel;
	Widget      panel, panel2, rowcol, rowcol2, rowcol3;
	Pixmap      mouseLeftCursor, mouseRightCursor;
	Pixel       fg, bg;
	int         i;

	toplevel = XtInitialize(argv[0], "Panex",
				options, XtNumber(options), &argc, argv);
	if (argc != 1)
		Usage();

	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			    (char *) panex_bits, panex_width, panex_height));
	XtSetArg(arg[1], XmNkeyboardFocusPolicy, XmPOINTER);	/* not XmEXPLICIT */
	XtSetValues(toplevel, arg, 2);
	panel = XtCreateManagedWidget("panel", xmPanedWindowWidgetClass, toplevel,
				      NULL, 0);
	panel2 = XtVaCreateManagedWidget("panel2", xmPanedWindowWidgetClass, panel,
					 XmNseparatorOn, False,
					 XmNsashWidth, 1,
					 XmNsashHeight, 1,
					 NULL);

	rowcol = XtVaCreateManagedWidget("Rowcol", xmRowColumnWidgetClass, panel2,
					 XmNnumColumns, 2,
					 XmNorientation, XmHORIZONTAL,
					 XmNpacking, XmPACK_COLUMN,
					 NULL);
	XtVaGetValues(rowcol, XmNforeground, &fg, XmNbackground, &bg, NULL);
	mouseLeftCursor = XCreatePixmapFromBitmapData(XtDisplay(rowcol),
	      RootWindowOfScreen(XtScreen(rowcol)), (char *) mouse_left_bits,
				 mouse_left_width, mouse_left_height, fg, bg,
				     DefaultDepthOfScreen(XtScreen(rowcol)));
	mouseRightCursor = XCreatePixmapFromBitmapData(XtDisplay(rowcol),
	     RootWindowOfScreen(XtScreen(rowcol)), (char *) mouse_right_bits,
			       mouse_right_width, mouse_right_height, fg, bg,
				     DefaultDepthOfScreen(XtScreen(rowcol)));
	XtVaCreateManagedWidget("mouseLeftText", xmLabelGadgetClass, rowcol,
	     XtVaTypedArg, XmNlabelString, XmRString, "Move tile", 10, NULL);
	XtVaCreateManagedWidget("mouseLeft", xmLabelGadgetClass, rowcol,
	      XmNlabelType, XmPIXMAP, XmNlabelPixmap, mouseLeftCursor, NULL);
	XtVaCreateManagedWidget("mouseRightText", xmLabelGadgetClass, rowcol,
		  XtVaTypedArg, XmNlabelString, XmRString, "Reset", 6, NULL);
	XtVaCreateManagedWidget("mouseRight", xmLabelGadgetClass, rowcol,
	     XmNlabelType, XmPIXMAP, XmNlabelPixmap, mouseRightCursor, NULL);
	XtVaCreateManagedWidget("movesText", xmLabelGadgetClass, rowcol,
		  XtVaTypedArg, XmNlabelString, XmRString, "Moves", 6, NULL);
	moves = XtVaCreateManagedWidget("0", xmLabelWidgetClass, rowcol, NULL);
	XtVaCreateManagedWidget("recordText", xmLabelGadgetClass, rowcol,
		 XtVaTypedArg, XmNlabelString, XmRString, "Record", 7, NULL);
	record = XtVaCreateManagedWidget("0", xmLabelWidgetClass, rowcol, NULL);

	rowcol2 = XtVaCreateManagedWidget("Rowcol2", xmRowColumnWidgetClass, panel2,
					  NULL);
	XtVaGetValues(rowcol2, XmNforeground, &fg, XmNbackground, &bg, NULL);
	tile = XtVaCreateManagedWidget("tile", xmScaleWidgetClass, rowcol2,
			 XtVaTypedArg, XmNtitleString, XmRString, "Tiles", 6,
				       XmNminimum, MINTILES,
				       XmNmaximum, MAXTILES,
				       XmNvalue, MAXTILES,
				       XmNshowValue, True,
				       XmNorientation, XmHORIZONTAL,
				       NULL);
	XtAddCallback(tile, XmNvalueChangedCallback, (XtCallbackProc) TileSlider,
		      (XtPointer) NULL);
	rowcol3 = XtVaCreateManagedWidget("Rowcol3", xmRowColumnWidgetClass, rowcol2,
					  XmNnumColumns, 1,
					  XmNorientation, XmHORIZONTAL,
					  XmNpacking, XmPACK_COLUMN,
					  XmNradioBehavior, True,
					  NULL);
	for (i = 0; i < XtNumber(modeString); i++) {
		modes[i] = XtVaCreateManagedWidget(modeString[i],
					  xmToggleButtonGadgetClass, rowcol3,
						   XmNradioBehavior, True,
						   NULL);
		XtAddCallback(modes[i], XmNvalueChangedCallback, (XtCallbackProc) ModeToggle,
			      (XtPointer) i);
	}
	message = XtVaCreateManagedWidget("Play Panex!",
					  xmLabelWidgetClass, rowcol2,
					  NULL);

	panex = XtCreateManagedWidget("panex", panexWidgetClass, panel,
				      NULL, 0);
	XtAddCallback(panex, XtNselectCallback, (XtCallbackProc) CallbackPanex,
		      (XtPointer) NULL);
	Initialize(panex);
	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(panex), AnyButton, AnyModifier, XtWindow(panex),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(panex),
		    XCreateFontCursor(XtDisplay(panex), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void
Initialize(Widget w)
{
	int         tiles, mode;

	/*XtVaSetValues(w,
	   XtNstart, FALSE,
	   NULL); */
	XtVaGetValues(w,
		      XtNtiles, &tiles,
		      XtNmode, &mode,
		      NULL);
	if (tiles <= MAXTILES)
		XmScaleSetValue(tile, tiles);
	XmToggleButtonSetState(modes[mode - HANOI], True, False);
	ReadRecords();
	PrintRecord(tiles, mode);
}

static void
CallbackPanex(Widget w, caddr_t clientData, panexCallbackStruct * callData)
{
	int         tiles, mode;

	XtVaGetValues(w,
		      XtNtiles, &tiles,
		      XtNmode, &mode,
		      NULL);
	(void) strcpy(messageDsp, "");
	switch (callData->reason) {
		case PANEX_RESTORE:
		case PANEX_RESET:
			movesDsp = 0;
			break;
		case PANEX_ILLEGAL:
			(void) strcpy(messageDsp, "Illegal move");
			break;
		case PANEX_BLOCKED:
			(void) strcpy(messageDsp, "Blocked");
			break;
		case PANEX_SPACE:
			/*(void) strcpy(messageDsp, "Spaces can't move"); *//* Too annoying */
			break;
		case PANEX_IGNORE:
			(void) strcpy(messageDsp, "Randomize to start");
			break;
		case PANEX_MOVED:
			movesDsp++;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_SOLVED:
			if (HandleSolved(movesDsp, tiles, mode))
				(void) sprintf(messageDsp, "Congratulations %s!!", getlogin());
			else
				(void) strcpy(messageDsp, "Solved!");
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_DEC:
			movesDsp = 0;
			tiles--;
			PrintRecord(tiles, mode);
			XtSetArg(arg[0], XtNtiles, tiles);
			XtSetValues(w, arg, 1);
			if (tiles <= MAXTILES)
				XmScaleSetValue(tile, tiles);
			break;
		case PANEX_INC:
			movesDsp = 0;
			tiles++;
			PrintRecord(tiles, mode);
			XtSetArg(arg[0], XtNtiles, tiles);
			XtSetValues(w, arg, 1);
			if (tiles <= MAXTILES)
				XmScaleSetValue(tile, tiles);
			break;
		case PANEX_MODE:
			movesDsp = 0;
			mode = (mode == PANEX) ? HANOI : PANEX;
			PrintRecord(tiles, mode);
			XtSetArg(arg[0], XtNmode, mode);
			XtSetValues(w, arg, 1);
			XmToggleButtonSetState(modes[mode - HANOI], True, True);
			break;
		case PANEX_COMPUTED:
			XtSetArg(arg[0], XtNstart, FALSE);
			XtSetValues(w, arg, 1);
			break;
		case PANEX_UNDO:
			movesDsp--;
			XtSetArg(arg[0], XtNstart, TRUE);
			XtSetValues(w, arg, 1);
			break;
	}
	motif_print(message, messageDsp);
	(void) sprintf(buff, "%d", movesDsp);
	motif_print(moves, buff);
}

static void
TileSlider(Widget w, XtPointer clientData, XmScaleCallbackStruct * cbs)
{
	int         tiles = cbs->value, mode, old;

	XtVaGetValues(panex,
		      XtNtiles, &old,
		      XtNmode, &mode,
		      NULL);
	if (old != tiles) {
		XtVaSetValues(panex,
			      XtNtiles, tiles,
			      NULL);
		movesDsp = 0;
		(void) sprintf(buff, "%d", movesDsp);
		motif_print(moves, buff);
		PrintRecord(tiles, mode);
	}
}

static void
ModeToggle(Widget w, int mode, XmToggleButtonCallbackStruct * cbs)
{
	int         tiles;

	if (cbs->set) {
		XtVaGetValues(panex,
			      XtNtiles, &tiles,
			      NULL);
		XtVaSetValues(panex,
			      XtNmode, mode + HANOI,
			      NULL);
		movesDsp = 0;
		(void) sprintf(buff, "%d", movesDsp);
		motif_print(moves, buff);
		PrintRecord(tiles, mode + HANOI);
	}
}

static void
PrintRecord(int tiles, int mode)
{
	int         i = tiles - MINTILES, j = mode - HANOI;

	if (tiles > MAXTILES)
		motif_print(record, "NOT RECORDED");
	else if (panexRecord[j][i] >= MAXRECORD)
		motif_print(record, "NEVER");
	else {
		(void) sprintf(buff, "%d", panexRecord[j][i]);
	  motif_print(record, buff);
  }
}

static int
HandleSolved(int counter, int tiles, int mode)
{
	int         i = tiles - MINTILES, j = mode - HANOI;

	if (tiles <= MAXTILES && counter < panexRecord[j][i]) {
		panexRecord[j][i] = counter;
		WriteRecords();
		PrintRecord(tiles, mode);
		return TRUE;
	}
	return FALSE;
}

static void
ReadRecords(void)
{
	FILE       *fp;
	int         i, mode, n;

	for (mode = 0; mode < MAXMODES; mode++)
		for (i = 0; i < MAXTILES - MINTILES + 1; i++)
			panexRecord[mode][i] = MAXRECORD;
	if ((fp = fopen(SCOREFILE, "r")) == NULL) {
		(void) sprintf(buff, "Can not open %s, taking defaults.", SCOREFILE);
		motif_print(message, buff);
	} else {
		for (mode = 0; mode < MAXMODES; mode++)
			for (i = 0; i < MAXTILES - MINTILES + 1; i++) {
				(void) fscanf(fp, "%d", &n);
				panexRecord[mode][i] = n;
			}
		(void) fclose(fp);
	}
}

static void
WriteRecords(void)
{
	FILE       *fp;
	int         i, mode;

	if ((fp = fopen(SCOREFILE, "w")) == NULL) {
		(void) sprintf(buff, "Can not write to %s.", SCOREFILE);
		motif_print(message, buff);
	} else {
		for (mode = 0; mode < MAXMODES; mode++) {
			for (i = 0; i < MAXTILES - MINTILES + 1; i++)
				(void) fprintf(fp, "%d ", panexRecord[mode][i]);
			(void) fprintf(fp, "\n");
		}
		(void) fprintf(fp, "\n");
		(void) fclose(fp);
	}
}

static void
motif_print(Widget w, char *text)
{
	Arg         wargs[1];
	XmString    xmstr;

	if (!XtIsSubclass(w, xmLabelWidgetClass))
		XtError("motif_print() requires a Label Widget");
	xmstr = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtSetArg(wargs[0], XmNlabelString, xmstr);
	XtSetValues(w, wargs, 1);
}
