/*
 * Programm XBLAST V1.2.9 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * Ferbuary 24th 1996
 * started August 1993
 *
 * File: status.c 
 * status board handling
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#define _STATUS_C

#include "include.h"
#include "mytypes.h"
#include "const.h"
#include "graphics.h"
#include "maze.h"
#include "score.h"


#define TEXT_ATTR (FF_Large|FF_White|FF_Boxed)
#define MESSAGE_TIME TIME_STEP

/* status board text box */
static BMRectangle status_box = {
  35*BLOCK_WIDTH/8,   79*BLOCK_HEIGHT/6,
  101*BLOCK_WIDTH/16, 2*BLOCK_HEIGHT/3,
};


#define MAX_MSG 8

/*
 * local variables
 */
static int num_disp;
static int num_player;

static int game_next, time_led;
static int face_pos[MAX_PLAYER];
static int num_pos[MAX_PLAYER];
static int face_used[MAX_PLAYER];
static int num_used[MAX_PLAYER];

static int text_left;
static int text_right;

static char *default_message;
static msg_restore;

/* variables for message queue */
static int num_msg = 0;
static int first_msg;
static char *msg_queue[MAX_MSG];
static int msg_delay[MAX_MSG+1] = {
  -1, 50, 40, 20, 12, 7, 7, 7, 7
};

/*
 * local function
 */
#ifdef __STDC__
static void
set_score_block (int x,
		 int block)
#else
static void
set_score_block (x, block)
     int x;
     int block;
#endif
{
  int disp;
  for (disp = 0; disp < num_disp; disp ++) {
    draw_score_block(disp, x, block);
  }
  mark_maze(x, MAZE_H, x, MAZE_H);
}

/*
 * local function
 */
#ifdef __STDC__
static void
set_time_led (int x,
	      int val)
#else
static void
set_time_led (x, val)
     int x;
     int val;
#endif
{
  int disp;
  for (disp = 0; disp < num_disp; disp ++) {
    draw_time_led(disp, x, val);
  }
  mark_maze(x/4, MAZE_H+1, x/4, MAZE_H+1);
}

/*
 * local function set status text 
 */
#ifdef __STDC__
void 
set_status_text (char *msg)
#else
static void
set_status_text (msg)
     char *msg;
#endif
{
  int disp;

  for (disp=0; disp<num_disp; disp++) {
    draw_textbox(disp, msg, TEXT_ATTR, &status_box);
  }
  mark_maze(text_left, MAZE_H, text_right, MAZE_H);
}

/*
 * public function 
 */
#ifdef __STDC__
void
init_status_bar (int n_player,
		 int n_disp,
		 BMPlayer *ps,
		 char *msg,
		 int flag) 
#else 
void
init_status_bar (n_player, n_disp, ps, msg, flag)
     int n_player, n_disp;
     BMPlayer *ps;
     char *msg;
     int flag;
#endif
{
  int p;

  /* set player and display number */
  num_disp = n_disp;
  num_player = n_player;

  switch (num_player) {
    /* setup player four if needed */
  case 4:
    face_pos[3] = 13;
    num_pos[3]  = 14;

    /* setup player three if needed */
  case 3:
    face_pos[2] = 11;
    num_pos[2]  = 12;

    /* setup player two if needed */
  case 2:
    face_pos[1] = 2;
    num_pos[1]  = 3;

    /* setup player two if needed */
  case 1:
    face_pos[0] = 0;
    num_pos[0]  = 1;
    break;
  }

  /* clear all */
  for (p=0; p<MAZE_W; p++) {
    set_score_block(p, SBVoid);
  }

  /* player boxes */
  for (p=0; p<num_player; p++) {
    set_score_block(face_pos[p], SBPlayer+p);
    face_used[p] = SBPlayer;
    if (flag) {
      set_score_block(num_pos[p], SBLives+ps[p].lives);
      num_used[p] = ps[p].lives;
    } else {
      set_score_block(num_pos[p], SBLives+ps[p].victories);
      num_used[p] = ps[p].victories;
    }
  }
  
  /* text box */
  text_left = 4;
  text_right = 10;
  set_score_block(4, SBTextLeft);
  set_score_block(10, SBTextRight);
  for (p=5; p<10; p++) {
    set_score_block(p, SBTextMid);
  }
  default_message = msg;
#if 0
  msg_restore = 0;
#endif
  num_msg = 0;
  set_status_text(msg);

  /* set leds */
  for (p=0; p<(4*MAZE_W); p++) {
    set_time_led(p, 1);
  }
  /* set timers for leds */
  game_next = TIME_STEP;
  time_led = MAZE_W*4;

}



/* 
 * public function 
 */
#ifdef __STDC__
void
reset_status_bar (BMPlayer *ps,
		  char *msg, 
		  int flag)
#else
void
reset_status_bar (ps, msg, flag)
     BMPlayer *ps;
     char *msg;
     int flag;
#endif
{
  int p;

  /* player boxes */
  for (p=0; p<num_player; p++) {
    set_score_block(face_pos[p], SBPlayer+p);
    face_used[p] = SBPlayer;
    if (flag) {
      set_score_block(num_pos[p], SBLives+ps[p].lives);
      num_used[p] = ps[p].lives;
    } else {
      set_score_block(num_pos[p], SBLives+ps[p].victories);
      num_used[p] = ps[p].victories;
    }
  }
  
  default_message = msg;
#if 0
  msg_restore = 0;
#endif
  num_msg = 0;
  set_status_text(msg);

  /* set leds */
  for (p=0; p<(4*MAZE_W); p++) {
    set_time_led(p, 1);
  }
  /* set timers for leds */
  game_next = TIME_STEP;
  time_led = MAZE_W*4;

  /* marl all filed to be redrawed */
  mark_maze(0,MAZE_H, MAZE_W, MAZE_H+1);
}



#ifdef __STDC__
void
update_status_bar (BMPlayer *ps,
		   int game_time)
#else
void
update_status_bar (ps, game_time)
     BMPlayer *ps;
     int game_time;
#endif
{
  int p;

  for (p=0; p<num_player; p++) {
    /* if in normal mode check if player is ill or dead */
    if (face_used[p] == SBPlayer) {
      if (ps[p].dying) {
	set_score_block(face_pos[p], SBDead+p);
	face_used[p] = SBDead;
      } else if (ps[p].illness != ps[p].health) {
	set_score_block(face_pos[p], SBSick+p);
	face_used[p] = SBSick;
      }
    } else if (face_used[p] == SBSick) {
      if (ps[p].illness == ps[p].health) {
	set_score_block(face_pos[p], SBPlayer+p);
	face_used[p] = SBPlayer;
      }
    } else if (face_used[p] == SBDead) {
      if ( (!ps[p].dying) && (ps[p].lives != 0) ) {
	set_score_block(face_pos[p], SBPlayer+p);
	face_used[p] = SBPlayer;
      }
    }
    /* check player lives */
    if (num_used[p] != ps[p].lives) {
      set_score_block(num_pos[p], SBLives + ps[p].lives);
      num_used[p] = ps[p].lives;
    }
  }
  /* check leds */
  if (game_time > game_next) {
    game_next += TIME_STEP;
    time_led --;
    set_time_led(time_led, 0);
  }
  /* check message */
#if 0
  if (msg_restore > 0) {
    msg_restore --;
    if (0 == msg_restore) {
      set_status_text(default_message);
    }
  }
#endif
  /* if any message is in the queue */
  if (num_msg) {
    msg_restore ++;
#if 0
    fprintf (stderr, "T=%5d MR=%3d NM=%2d \"%s\"\n", 
	     game_time, msg_restore, num_msg, msg_queue[first_msg]);
#endif
    /* check if message is outdated */
    if (msg_restore >= msg_delay[num_msg]) {
      /* return to default message if last queued one */
      if (--num_msg) {
	/* set next message */
	first_msg = (first_msg+1) % MAX_MSG;
	set_status_text(msg_queue[first_msg]);
	msg_restore = 0;
      } else {
	/* return to default message if last queued one */
	set_status_text(default_message);
      }
    }
  }
}


/*
 * public function set_message
 */
#ifdef __STDC__
void
set_message (char *msg,
	     int perm)
#else
void
set_message (msg, perm)
	     char *msg;
	     int perm;
#endif
{
  int m;

  if (NULL != msg) {
    if (perm) {
#if 0
      msg_restore = 0;
#endif
      set_status_text(msg);
      num_msg = 0;
    } else {
      /* if no other message exists set to start of queue */
      if (0 == num_msg) {
	m = first_msg = 0;
	msg_restore = 0;
	set_status_text(msg);
      } else {
	m = (first_msg + num_msg) % MAX_MSG;
      }
      msg_queue[m] = msg;
      num_msg ++;
      /* check for queue overflow */
      if (num_msg > MAX_MSG) {
	/* remove first message */
	num_msg --;
	first_msg = (first_msg+1) % MAX_MSG;
      }
      
#if 0
      msg_restore = MESSAGE_TIME;
#endif
    }
  }
}

/*
 * public function set_message
 */
#ifdef __STDC__
void
reset_message (void)
#else
void
reset_message ()
#endif
{
  if (num_msg > 0) {
    set_status_text(msg_queue[first_msg]);
  } else {
    set_status_text(default_message);
  }
}

/*
 * end of file status.c
 */




