/* c_delete.cc
 *$Header: /al/acs/src/RCS/c_delete.cc,v 9.26 95/10/31 16:11:23 al Exp $
 * delete and clear commands
 */
#include "ap.h"
#include "e_card.h"
#include "error.h"
#include "c_comand.h"
#include "s__.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::clear(CS&);
//	void	CMD::del(CS&);
static	void	bylabel(CS&);
static	void	all();
/*--------------------------------------------------------------------------*/
/* cmd_clear: clear the whole circuit, including faults, etc
 *   equivalent to unfault; unkeep; delete all; title = (blank)
 */
void CMD::clear(CS& cmd)
{
  unfault(CS(""));
  unmark(CS(""));
  ic(CS("clear"));
  nodeset(CS("clear"));
  alarm(CS("clear"));
  plot(CS("clear"));
  print(CS("clear"));
  del(CS("all"));
  title(CS("'"));
}
/*--------------------------------------------------------------------------*/
/* cmd_delete:  delete command
 */
void CMD::del(CS& cmd)
{
  SIM::uninit();
  if (cmd.pmatch("ALL")){
    all();
  }else{
    while (cmd.more())
      bylabel(cmd);
  }
}
/*--------------------------------------------------------------------------*/
/* bylabel: delete circuit element by label
 * 	all lines with matching label (with wild cards * and ?) deleted.
 *	although it looks like a loop, it matches one label
 *	syntax warning if no match
 */
static void bylabel(CS& cmd)
{
  CARD *brh;		   /* scanning branch */
  CARD *next;		   /* look ahead because delete loses the link */
  int mark = cmd.index();  /* where we started parsing */
  int cmax = cmd.index();  /* where we got after being successful */
  
  brh = CARD::first();
  for (;;){
    cmd.reset(mark);
    brh =findbranch(cmd, brh, CARD::root());
    cmax = max(cmax, cmd.index());
    if (!exists(brh))
      break;
    next = brh->next();
    delete brh;
    brh = next;
  }
  cmd.reset(cmax);
  if (mark == cmax){
    cmd.check(bWARNING);
    cmd.skiparg();
  }
}
/*--------------------------------------------------------------------------*/
/* all: delete all parts of a circuit, line by line
 */
static void all()
{
  CARD *brh;
  CARD *next;
  for (brh=CARD::first();  brh != CARD::root();  brh=next){
    next = brh->next();
    delete brh;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
