/* sys/strace.h */

/* This file contains routines for tracing system calls and other internal
   phenomenon.

   When tracing system calls, try to use the same style throughout:

   result = syscall (arg1, arg2, arg3) [optional extra stuff]

   If a system call can block (eg: read, write, wait), print another message
   before hanging so the user will know why the program has stopped.

   Note: __seterrno will also print a trace message.  Have that printed
   *first*.  This will make it easy to always know what __seterrno is
   refering to.  For the same reason, try not to have __seterrno messages
   printed alone.
*/

#ifndef _SYS_STRACE_H
#define _SYS_STRACE_H

/* Bitmasks of tracing messages to print.  */

#define _STRACE_ALL	0x01 /* so behaviour of strace=1 is unchanged */
#define _STRACE_UHOH	0x02 /* unusual or weird phenomenon */
#define _STRACE_SYSCALL	0x04 /* system calls */
#define _STRACE_WM	0x08 /* Trace windows messages (enable _strace_wm) */
#define _STRACE_STARTUP	0x10 /* argc/envp printout at startup */
#define _STRACE_DEBUG   0x20 /* paranoid info */
#define _STRACE_PARANOID 0x40 /* very paranoid info */
#define _STRACE_TERMIOS 0x80 /* Info for debugging termios stuff */
int strace();
/* Print a message in the trace log if asked to.
   To always have the message printed set LEVEL to 0.
   Note that the optimizer will collapse the test to a few insns at most.  */

#define _STRACE(level, args) \
do { \
  if ((level == 0) || (strace() & (level | 1))) __sys_printf args; \
} while (0)

/* ??? One can argue __trace_file belongs here too.  It's a HANDLE and
   to define it correctly requires the appropriate windows header which
   I didn't really want so I punted.  */

void __sys_printf (const char *, ...);

void _strace_wm(int message, int word, int lon);


#define debug_printf if (strace() &(_STRACE_DEBUG|1)) __sys_printf
#define syscall_printf if (strace() &(_STRACE_SYSCALL|1)) __sys_printf
#define paranoid_printf if (strace() &(_STRACE_PARANOID|1)) __sys_printf
#define termios_printf if (strace() &(_STRACE_TERMIOS|1)) __sys_printf


#endif
