/* pam_start.c */

/* Creator Marc Ewing
 *
 * $Id: pam_start.c,v 1.5 1996/07/07 23:58:23 morgan Exp $
 *
 * $Log: pam_start.c,v $
 * Revision 1.5  1996/07/07 23:58:23  morgan
 * added support for pam_fail_delay function
 *
 * Revision 1.4  1996/05/21 04:39:21  morgan
 * added debugging code
 *
 *
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>

#include "pam_private.h"

#ifdef DEBUG
#define D(x) _pam_debug x
#else
#define D(x)
#endif

int pam_start (
    const char *service_name,
    const char *user,
    const struct pam_conv *pam_conversation,
    pam_handle_t **pamh)
{
    D(("called pam_start: [%s] [%s] [%lx] [%lx]"
		,service_name,user,pam_conversation,pamh));

    if ((*pamh = malloc(sizeof(**pamh))) == NULL) {
	_pam_log_error("pam_start: malloc failed for *pamh");
	return (PAM_BUF_ERR);
    }

    if (service_name) {
	if (((*pamh)->service_name = strdup(service_name)) == NULL) {
	    _pam_log_error("pam_start: strdup failed for service name");
	    DROP(*pamh);
	    return (PAM_BUF_ERR);
	}
    } else
       	(*pamh)->service_name = NULL;

    if (user) {
	if (((*pamh)->user = strdup(user)) == NULL) {
	    _pam_log_error("pam_start: strdup failed for user");
	    DROP((*pamh)->service_name);
	    DROP(*pamh);
	    return (PAM_BUF_ERR);
	}
    } else
	(*pamh)->user = NULL;

    (*pamh)->tty = NULL;
    (*pamh)->tuser = NULL;       /* temp user name for pam_get_user() */
    (*pamh)->prompt = NULL;      /* temp user name for pam_get_user() */
    (*pamh)->ruser = NULL;
    (*pamh)->rhost = NULL;
    (*pamh)->authtok = NULL;
    (*pamh)->oldauthtok = NULL;

    if (pam_conversation == NULL
	|| ((*pamh)->pam_conversation = (struct pam_conv *)
	    malloc(sizeof(struct pam_conv))) == NULL) {
	_pam_log_error("pam_start: malloc failed for pam_conv");
	DROP((*pamh)->service_name);
	DROP((*pamh)->user);
	DROP(*pamh);
	return (PAM_BUF_ERR);
    } else {
	memcpy((*pamh)->pam_conversation
	       ,pam_conversation
	       ,sizeof(struct pam_conv));
    }

    (*pamh)->data = NULL;

#ifdef PAM_FAIL_DELAY_ON
    _pam_reset_timer(*pamh);         /* initialize timer support */
#endif /* PAM_FAIL_DELAY_ON */

    _pam_start_handlers(*pamh);

    /* According to the SunOS man pages, loading modules and resolving
     * symbols happens on the first call from the application.
     * _pam_init_handlers(*pamh);
     */

    D(("exiting pam_start successfully"));
    return PAM_SUCCESS;
}
