/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*
*           Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/

/* Partly generated with fdesign */

/* If you change lyx.fd, remember to backup lyx.C and lyx.h first and 
   restore lyx.h after the lyx.c and lyx.h files have been generated.

   To get the version information right, you should also change line 52
   in this file to something like:

	obj = fl_add_text(FL_NORMAL_TEXT,30,70,240,40,VERSION);

   and to enable doubleclicks on the reference-form change line 243 to:
   
       fl_set_browser_dblclick_callback(obj,RefSelectCB,0);   
	
  (Asger Alstrup)
*/   

#include "config.h"

#include "forms.h"
#include <stdlib.h>

#include "lyx.h"
#include "version.h"

FD_form_title *create_form_form_title(void)
{
  FL_OBJECT *obj;
  FD_form_title *fdui = (FD_form_title *) fl_calloc(1, sizeof(*fdui));

  fdui->form_title = fl_bgn_form(FL_NO_BOX, 300, 300);
  obj = fl_add_box(FL_UP_BOX,0,0,300,300,"");
    fl_set_object_color(obj,FL_DARKCYAN,FL_TOP_BCOL);
  obj = fl_add_text(FL_NORMAL_TEXT,20,180,260,100,"This is free software and you are welcome\nto redistribute it under certain conditions.\nThere is ABSOLUTELY NO WARRANTY.\n\nSee \"Help->Copying/Warranty\" for details.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_frame(FL_ENGRAVED_FRAME,20,180,260,100,"");
  obj = fl_add_text(FL_NORMAL_TEXT,30,30,240,40,"LyX");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,30,70,240,40,VERSION);
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,30,110,240,30,"(C) 1995 Matthias Ettrich,");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj, 0);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  obj = fl_add_text(FL_NORMAL_TEXT,30,140,240,30,"1995, 1996 LyX Team.");
    fl_set_object_color(obj,FL_DARKCYAN,FL_MCOL);
    fl_set_object_lsize(obj, 0);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
  fdui->timer_title = obj = fl_add_timer(FL_HIDDEN_TIMER,20,220,30,60,"");
    fl_set_object_callback(obj,TimerCB,0);
  obj = fl_add_button(FL_HIDDEN_BUTTON,0,0,300,310,"");
    fl_set_button_shortcut(obj,"^M ^[",1);
    fl_set_object_callback(obj,TimerCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

FD_form_figure *create_form_form_figure(void)
{
  FL_OBJECT *obj;
  FD_form_figure *fdui = (FD_form_figure *) fl_calloc(1, sizeof(*fdui));

  fdui->form_figure = fl_bgn_form(FL_NO_BOX, 330, 230);
  obj = fl_add_box(FL_UP_BOX,0,0,330,230,"");
  obj = fl_add_text(FL_NORMAL_TEXT,10,10,90,40,"Figure");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);

  fdui->group_radio_fugre = fl_bgn_group();
  fdui->radio_postscript = obj = fl_add_checkbutton(FL_RADIO_BUTTON,10,80,290,30,"Encapsulated Postscript (*.eps, *.ps)");
    fl_set_button_shortcut(obj,"#E",1);
    fl_set_object_lsize(obj,0);
  fdui->radio_inline = obj = fl_add_checkbutton(FL_RADIO_BUTTON,10,110,290,30,"Inlined EPS (*.eps, *.ps)");
    fl_set_button_shortcut(obj,"#I",1);
    fl_set_object_lsize(obj,0);
  fdui->radio_latex = obj = fl_add_checkbutton(FL_RADIO_BUTTON,10,140,290,30,"LaTeX or TeX (*.tex, *.latex)");
    fl_set_button_shortcut(obj,"#L",1);
    fl_set_object_lsize(obj,0);
  fl_end_group();

  obj = fl_add_button(FL_RETURN_BUTTON,10,190,90,30,"OK");
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,FigureOKCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,120,190,90,30,"Apply");
    fl_set_button_shortcut(obj,"#A",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,FigureApplyCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,230,190,90,30,"Cancel");
    fl_set_button_shortcut(obj,"#C^[",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,FigureCancelCB,0);
  obj = fl_add_frame(FL_ENGRAVED_FRAME,10,70,310,100,"");
  obj = fl_add_text(FL_NORMAL_TEXT,20,60,50,20,"Type");
    fl_set_object_lsize(obj,0);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

FD_form_screen *create_form_form_screen(void)
{
  FL_OBJECT *obj;
  FD_form_screen *fdui = (FD_form_screen *) fl_calloc(1, sizeof(*fdui));

  fdui->form_screen = fl_bgn_form(FL_NO_BOX, 420, 440);
  obj = fl_add_box(FL_UP_BOX,0,0,420,440,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,10,240,400,140,"");
  obj = fl_add_text(FL_NORMAL_TEXT,10,10,180,40,"Screen Options");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
  fdui->input_roman = obj = fl_add_input(FL_NORMAL_INPUT,130,70,270,30,"Roman Font");
    fl_set_input_shortcut(obj,"#R",1);
    fl_set_object_lsize(obj,0);
  fdui->input_sans = obj = fl_add_input(FL_NORMAL_INPUT,130,110,270,30,"Sans Serif Font");
    fl_set_input_shortcut(obj,"#S",1);
    fl_set_object_lsize(obj,0);
  fdui->input_typewriter = obj = fl_add_input(FL_NORMAL_INPUT,130,150,270,30,"Typewriter Font");
    fl_set_input_shortcut(obj,"#W",1);
    fl_set_object_lsize(obj,0);
  fdui->input_font_norm = obj = fl_add_input(FL_NORMAL_INPUT,130,190,270,30,"Font Norm");
    fl_set_input_shortcut(obj,"#F",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_size = obj = fl_add_input(FL_INT_INPUT,350,20,50,30,"Normal Size");
    fl_set_input_shortcut(obj,"#N",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_tiny = obj = fl_add_input(FL_INT_INPUT,80,260,50,30,"Tiny");
    fl_set_input_shortcut(obj,"#Y",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_small = obj = fl_add_input(FL_INT_INPUT,80,300,50,30,"Small");
    fl_set_input_shortcut(obj,"#M",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_normal = obj = fl_add_input(FL_INT_INPUT,80,340,50,30,"Normal");
    fl_set_input_shortcut(obj,"#O",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_large = obj = fl_add_input(FL_INT_INPUT,200,260,50,30,"Large");
    fl_set_input_shortcut(obj,"#L",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_larger = obj = fl_add_input(FL_INT_INPUT,200,300,50,30,"Larger");
    fl_set_input_shortcut(obj,"#E",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_largest = obj = fl_add_input(FL_INT_INPUT,200,340,50,30,"Largest");
    fl_set_input_shortcut(obj,"#T",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_huge = obj = fl_add_input(FL_INT_INPUT,320,260,50,30,"Huge");
    fl_set_input_shortcut(obj,"#H",1);
    fl_set_object_lsize(obj,0);
  fdui->intinput_giant = obj = fl_add_input(FL_INT_INPUT,320,300,50,30,"Giant");
    fl_set_input_shortcut(obj,"#G",1);
    fl_set_object_lsize(obj,0);
  obj = fl_add_text(FL_NORMAL_TEXT,20,230,200,20,"Reference Sizes for Scaling");
    fl_set_object_lsize(obj,0);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_button(FL_RETURN_BUTTON,10,400,120,30,"OK");
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,ScreenOKCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,150,400,120,30,"Apply");
    fl_set_button_shortcut(obj,"#A",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,ScreenApplyCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,290,400,120,30,"Cancel");
    fl_set_button_shortcut(obj,"#C^[",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_callback(obj,ScreenCancelCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

FD_form_toc *create_form_form_toc(void)
{
  FL_OBJECT *obj;
  FD_form_toc *fdui = (FD_form_toc *) fl_calloc(1, sizeof(*fdui));

  fdui->form_toc = fl_bgn_form(FL_NO_BOX, 420, 380);
  obj = fl_add_box(FL_UP_BOX,0,0,420,380,"");
  obj = fl_add_text(FL_NORMAL_TEXT,10,10,210,40,"Table of Contents");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
  fdui->browser_toc = obj = fl_add_browser(FL_HOLD_BROWSER,10,50,400,280,"");
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
    fl_set_object_callback(obj,TocSelectCB,0);
  obj = fl_add_button(FL_RETURN_BUTTON,260,340,150,30,"Close");
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj,TocCancelCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,90,340,150,30,"Update");
    fl_set_button_shortcut(obj,"Uu#u",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj,TocUpdateCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

FD_form_ref *create_form_form_ref(void)
{
  FL_OBJECT *obj;
  FD_form_ref *fdui = (FD_form_ref *) fl_calloc(1, sizeof(*fdui));

  fdui->form_ref = fl_bgn_form(FL_NO_BOX, 420, 330);
  obj = fl_add_box(FL_UP_BOX,0,0,420,330,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,10,230,240,40,"");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
  fdui->radio_ref = obj = fl_add_checkbutton(FL_RADIO_BUTTON,10,240,110,30,"Reference");
    fl_set_button_shortcut(obj,"#R",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
  obj = fl_add_text(FL_NORMAL_TEXT,10,10,280,40,"Insert Cross-Reference");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
  fdui->browser_ref = obj = fl_add_browser(FL_HOLD_BROWSER,10,60,400,150,"");
    fl_set_browser_dblclick_callback(obj,RefSelectCB,0);
    fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
  obj = fl_add_button(FL_NORMAL_BUTTON,90,290,150,30,"Update");
    fl_set_button_shortcut(obj,"Uu#U",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj,RefUpdateCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,260,290,150,30,"Close");
    fl_set_button_shortcut(obj,"#C^[",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj,RefHideCB,0);
  fdui->radio_pageref = obj = fl_add_checkbutton(FL_RADIO_BUTTON,120,240,130,30,"Page number");
    fl_set_button_shortcut(obj,"#P",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
  obj = fl_add_text(FL_NORMAL_TEXT,20,220,50,20,"Type");
    fl_set_object_lsize(obj,0);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
  obj = fl_add_button(FL_NORMAL_BUTTON,260,230,150,30,"Insert Reference");
    fl_set_button_shortcut(obj,"#I^M",1);
    fl_set_object_lsize(obj,0);
    fl_set_object_gravity(obj, FL_SouthEast, FL_SouthEast);
    fl_set_object_callback(obj,RefSelectCB,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

