/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#include "autocor.h"
#include "lyxparameters.h"
LyXTextParameters* autocorrparameters = NULL;




// if AutoCorrect returns True, posend contains the new
// cursor position in this paragraph
bool  AutoCorrect(LyXParagraph* par, int &pos, int &posend){
  if (autocorrparameters){
    LyXParagraph* tmppar = autocorrparameters->paragraph;;
    int i;
    // char c; // unused

    while (tmppar){
      i = 0;
      while (i < tmppar->Last()
	     && tmppar != par
	     && pos+i<=posend
	     && !tmppar->IsSeparator(i)
	     && tmppar->GetChar(i) == par->GetChar(pos+i)
	     && (tmppar->GetChar(i) != LYX_META_INSET
		 || (tmppar->GetInset(i)
		     && tmppar->GetInset(i)->IsEqual(par->GetInset(i))))){
	i++;
      }

      // check wether we found it
      if (pos+i > posend && tmppar->IsSeparator(i)) {
	// remove the old stuff from the paragraph
	int a;
	for (a=0; a<i; a++){
	  par->Erase(pos);
	  posend--;
	}
	// insert the new stuff
	posend++;
	i++;
	while (i < tmppar->Last() && tmppar->GetChar(i) != LYX_META_NEWLINE){
	  tmppar->CopyIntoMinibuffer(i);
	  par->InsertFromMinibuffer(posend);
	  posend++;
	  i++;
	}
	posend--;
	return true;
      }
      tmppar = tmppar->next;
    }
    
  }
  return false;
}



