/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** quantifierNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ quantifierNodeList
quantifierNodeList_new ()
{
  quantifierNodeList s = (quantifierNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = quantifierNodeListBASESIZE;
  s->elements = (quantifierNode *) 
    dmalloc (sizeof (*s->elements) * quantifierNodeListBASESIZE);

  return (s);
}

static void
quantifierNodeList_grow (quantifierNodeList s)
{
  int i;
  quantifierNode *newelements; 

  s->nspace = quantifierNodeListBASESIZE + s->nspace;

  newelements = (quantifierNode *) dmalloc (sizeof (*newelements)
					    * (s->nelements + quantifierNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }

  sfree (s->elements);
  s->elements = newelements;
}

quantifierNodeList 
quantifierNodeList_add (quantifierNodeList s, quantifierNode el)
{
  if (s->nspace <= 0)
    quantifierNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ quantifierNodeList 
quantifierNodeList_copy (quantifierNodeList s)
{
  quantifierNodeList r = quantifierNodeList_new ();

  quantifierNodeList_elements (s, x)
    {
      r = quantifierNodeList_add (r, quantifierNode_copy (x));
    } end_quantifierNodeList_elements;
  
  return r;
}

/*@only@*/ cstring
quantifierNodeList_unparse (quantifierNodeList s)
{
  cstring st = cstring_undefined;

  quantifierNodeList_elements (s, current)
  {
    st = message ("%q%s %q", 
		  st, ltoken_getRawString (current->quant),
		  varNodeList_unparse (current->vars));
  } end_quantifierNodeList_elements;

  return st;
}

void
quantifierNodeList_free (quantifierNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      quantifierNode_free (s->elements[i]); 
    }

  sfree (s->elements); 
  sfree (s);
}
