/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** intSet.c
**
** based on set_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "basic.h"
# include "intSet.h"

/*@only@*/ intSet
intSet_new ()
{
  intSet s = (intSet) dmalloc (sizeof (*s));
  
  s->entries = 0;
  s->nspace = intSetBASESIZE;
  s->elements = (int *) dmalloc (sizeof (*s->elements) * intSetBASESIZE);

  return (s);
}

static void
intSet_grow (intSet s)
{
  int i;
  int *newelements;

  s->nspace = intSetBASESIZE;
  newelements = (int *) dmalloc (sizeof (*newelements) * (s->entries + intSetBASESIZE));

  for (i = 0; i < s->entries; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements; 
}

/*
** Ensures: if *e \in *s
**          then unchanged (*s) & result = false
**          else *s' = insert (*s, *e) & result = true
** Modifies: *s
*/

bool
intSet_insert (intSet s, int el)
{
  int i;

  for (i = 0; i < s->entries; i++)
    {
      if (s->elements[i] >= el)
	break;
    }

  if (s->entries > 0 && s->elements[i] == el)
    {
      return FALSE;
    }
  else
    {
      if (s->nspace <= 0)
	intSet_grow (s);

      s->nspace--;

      if (i == (s->entries - 1))
	{
	  s->elements[s->entries] = el;
	}
      else
	{
	  int j;
	  
	  for (j = s->entries; j > i; j--)
	    {
	      s->elements[j] = s->elements[j-1];
	    }
	  s->elements[i] = el;
	}
      
      s->entries++;      
      return TRUE;
    }
}

bool
intSet_member (intSet s, int el)
{
  int i;

  for (i = 0; i < s->entries; i++)
    {
      if (el == s->elements[i])
	{
	  return TRUE;
	}
      if (el > s->elements[i]) 
	{
	  return FALSE;
	}
    }
  return FALSE;
}

/*@only@*/ cstring
intSet_unparseText (intSet s)
{
  int i;
  cstring st = cstring_undefined;
  int lastentry = s->entries - 1;

  for (i = 0; i < s->entries; i++)
    {
      if (i == 0)
	st = message ("%d", s->elements[i]);
      else if (i == lastentry)
	st = message ("%q or %d", st, s->elements[i]);
      else
	st = message ("%q, %d", st, s->elements[i]);
    }

  return st;
}
  
/*@only@*/ cstring
intSet_unparse (intSet s)
{
  int i;
  cstring st = cstring_makeLiteral ("{");

  for (i = 0; i < s->entries; i++)
    {
      st = message ("%q %d", st, s->elements[i]);
    }

  st = message ("%q}", st);
  return st;
}

void
intSet_free (intSet s)
{
  sfree (s->elements); 
  sfree (s);
}
