/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/

typedef enum {
  SRN_TERM, SRN_TYPE, SRN_OBJ, SRN_SPECIAL
  } storeRefNodeKind;

typedef struct _storeRefNode {
  storeRefNodeKind kind;
  union {
    struct _termNode *term;         /* for SRN_TERM */
    lclTypeSpecNode type;  /* for SRN_OBJ and SRN_TYPE */
    sRef ref;                       /* for SRN_SPECIAL */
  } content;
} *storeRefNode;

extern storeRefNode storeRefNode_copy (storeRefNode x);

extern bool storeRefNode_isTerm (storeRefNode x);
# define storeRefNode_isTerm(x) ((x)->kind == SRN_TERM)

extern bool storeRefNode_isObj (storeRefNode x);
# define storeRefNode_isObj(x) ((x)->kind == SRN_OBJ)

extern bool storeRefNode_isType (storeRefNode x);
# define storeRefNode_isType(x) ((x)->kind == SRN_TYPE)

extern bool storeRefNode_isSpecial (storeRefNode x);
# define storeRefNode_isSpecial(x) ((x)->kind == SRN_SPECIAL)

extern void storeRefNode_free (/*@only@*/ /*@null@*/ storeRefNode x);
