/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** macrocache.h
*/

# ifndef MACROCACHE_H
# define MACROCACHE_H

typedef struct _mce
{
  fileloc fl;
  cstring def;
  bool defined;
  bool scomment;
} *mce;

typedef /*@only@*/ mce o_mce;

typedef struct _mcelist
{
  int nspace;
  int entries;
  /*@reldef@*/ /*@only@*/ o_mce *contents;
} *macrocache;

extern void 
  macrocache_processUndefinedElements (macrocache m) ; /* modifies externalState */

extern /*@observer@*/ fileloc
  macrocache_processFileElements (macrocache m, cstring base) ;

extern /*@only@*/ /*@unused@*/ cstring macrocache_unparse (macrocache m) /*@*/ ;
extern /*@only@*/ macrocache macrocache_create (void) /*@*/ ;

extern void 
  macrocache_addEntry (macrocache s, /*@only@*/ fileloc fl, /*@only@*/ cstring def);

extern void 
  macrocache_addComment (macrocache s, /*@only@*/ fileloc fl, /*@only@*/ cstring def);

extern void macrocache_free (/*@only@*/ macrocache s);

# else
# error "Multiple include"
# endif
