/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** lsymbolSet.h
**
** based on set_template.h
*/

# ifndef LSYMBOLSET_H
# define LSYMBOLSET_H

abst_typedef /*@null@*/ struct _lsymbolSet
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ lsymbol  *elements;
} *lsymbolSet ;

/*@constant null lsymbolSet lsymbolSet_undefined; @*/
# define lsymbolSet_undefined (NULL)

extern /*@falsenull@*/ bool lsymbolSet_isDefined (lsymbolSet l) /*@*/ ;
# define lsymbolSet_isDefined(l) ((l) != lsymbolSet_undefined)
 
/*@iter lsymbolSet_elements (sef lsymbolSet s, yield lsymbol el); @*/
# define lsymbolSet_elements(x, m_el) \
     if (lsymbolSet_isDefined (x)) \
      { int m_ind; \
        for (m_ind = 0 ; m_ind < (x)->entries; m_ind++) \
         { lsymbol m_el = (x)->elements[m_ind]; 

# define end_lsymbolSet_elements }}

extern /*@only@*/ lsymbolSet lsymbolSet_new(void) /*@*/ ;
extern bool lsymbolSet_insert (lsymbolSet s, lsymbol el) /*@modifies s@*/ ;
extern bool lsymbolSet_member (lsymbolSet s, lsymbol el) /*@*/ ;
extern /*@unused@*/ /*@only@*/ cstring lsymbolSet_unparse (lsymbolSet s) /*@*/ ;
extern void lsymbolSet_free (/*@only@*/ lsymbolSet s);

/*@constant int lsymbolSetBASESIZE;@*/
# define lsymbolSetBASESIZE MIDBASESIZE

# else
# error "Multiple include"
# endif
