// $Id: options.h,v 1.1 1996/01/20 15:24:10 zeller Exp $ -*- C++ -*-
// Options

// Copyright (C) 1996 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller (zeller@ips.cs.tu-bs.de).
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.

#ifndef _DDD_options_h
#define _DDD_options_h

#ifdef __GNUG__
#pragma interface
#endif

#include "strclass.h"
#include "bool.h"
#include <X11/Intrinsic.h>

// Options
string options_file();
void save_options(Widget origin);

extern void sourceToggleFindWordsOnlyCB    (Widget, XtPointer, XtPointer);
extern void sourceToggleCacheSourceFilesCB (Widget, XtPointer, XtPointer);
extern void sourceToggleCacheMachineCodeCB (Widget, XtPointer, XtPointer);
extern void sourceToggleDisplayGlyphsCB    (Widget, XtPointer, XtPointer);
extern void sourceToggleDisassembleCB      (Widget, XtPointer, XtPointer);

extern void graphToggleShowGridCB         (Widget, XtPointer, XtPointer);
extern void graphToggleShowHintsCB        (Widget, XtPointer, XtPointer);
extern void graphToggleSnapToGridCB       (Widget, XtPointer, XtPointer);
extern void graphToggleCompactLayoutCB    (Widget, XtPointer, XtPointer);
extern void graphToggleAutoLayoutCB       (Widget, XtPointer, XtPointer);

extern void dddToggleGroupIconifyCB       (Widget, XtPointer, XtPointer);
extern void dddToggleGlobalTabCompletionCB(Widget, XtPointer, XtPointer);
extern void dddToggleSeparateExecWindowCB (Widget, XtPointer, XtPointer);
extern void dddToggleSaveOptionsOnExitCB  (Widget, XtPointer, XtPointer);
extern void dddToggleSaveHistoryOnExitCB  (Widget, XtPointer, XtPointer);
extern void dddToggleSuppressWarningsCB   (Widget, XtPointer, XtPointer);
extern void dddSetSeparateWindowsCB       (Widget, XtPointer, XtPointer);
extern void dddSetKeyboardFocusPolicyCB   (Widget, XtPointer, XtPointer);
extern void dddSetPannerCB                (Widget, XtPointer, XtPointer);
extern void dddSetDebuggerCB              (Widget, XtPointer, XtPointer);

extern void DDDSaveOptionsCB              (Widget, XtPointer, XtPointer);

// True if options were changed
extern bool options_changed;
extern bool startup_options_changed;

#endif // _DDD_options_h
// DON'T ADD ANYTHING BEHIND THIS #endif
