#! /bin/sh

me=`basename $0`

if [ $# -lt 6 -o $# -gt 7 ]
then
    >&2 echo usage: $me "package version kind where source [ dest ]"
    exit 1
fi

package=$1
version=$2
kind=$3
where=$4
source=$5
dest=$6

: ${dest:=$source}

makescripts() {
    for what
    do
	rm -f "$dest"/${what}

	if [ -f $source/${what}.begin -a -f $source/${what}.end ]
	then
            sed "s,@package@,${package},g" $source/${what}.begin \
	    	$source/functions >>"$dest"/${what}
    	    echo "commands='$commands'" >>"$dest"/${what}
    	    echo "manuals='$manuals'" >>"$dest"/${what}
    	    sed -e "s,@package@,${package},g" -e "s,@version@,${version},g" \
	    	-e "s,@kind@,${kind},g" $source/${what}.end >>"$dest"/${what}
	else
	    if [ -f $source/${what}.in ]
	    then
		if [ "`grep '# @functions@' $source/${what}.in`" != "" ]
		then
		    (
    	    	    	sed -e '/# @functions@/,$d' \
			    -e "s,@package@,${package},g" \
		            -e "s,@version@,${version},g" \
			    -e "s,@kind@,${kind},g" $source/${what}.in
			cat $source/functions
    	    	    	sed -e '1,/# @functions@/d' \
			    -e "s,@package@,${package},g" \
		            -e "s,@version@,${version},g" \
			    -e "s,@kind@,${kind},g" $source/${what}.in
		    ) >"$dest"/${what}
		else
    	    	    sed -e "s,@package@,${package},g" \
		        -e "s,@version@,${version},g" \
	    		-e "s,@kind@,${kind},g" \
			    $source/${what}.in >"$dest"/${what}
		fi
	    else
		>&2 echo $me: cannot find source to build $what in $source
		exit 2
	    fi
	fi
    done
}

commands=`find $where/usr/bin ! -type d -print | sed "s,^$where,,"`
manuals=`find $where/usr/man/man1 ! -type d -print | sed "s,^$where,,"`

if [ -z "$commands$manuals" ]; then exit 2; fi

test -d "$dest" || mkdir -p "$dest"

makescripts postinst prerm
if [ ! -z "$kind" ]
then
    makescripts preinst postrm
else
    rm -f "$dest"/preinst "$dest"/postrm
fi


