/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: show_point_values.c,v 1.2 1998/03/10 04:15:55 lance Exp $ */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>

#include "xwin.h"
#include "data.h"

extern GC band_gc;

extern int get_window_size(Display *display, Window window, 
			    unsigned int *width, 
			    unsigned int *height);

extern int check_popWig(PlotXwins *win, Plot *plot);


/* get_pointer_postion() returns 1 on failure */
extern int get_pointer_postion(PlotXwins *win, int *xi, int *yi);
extern void show_fn_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int h1);
extern void show_true_fn_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int h1);

/* redraw flag */
static int show_point_values_undraw = 0;
static int sp_xi=-2,sp_yi=-2;/* last position of cross center */

void unset_show_pt_vals_undraw(void)
{
  show_point_values_undraw = 0;
}

void show_pt_vals_undraw(PlotXwins *win, Plot *plot,
			 unsigned int width, unsigned int height,
			 unsigned int w1, unsigned int h1)
{
  if(show_point_values_undraw)
    {
      if(sp_xi>-1 && sp_xi<width)
	XDrawLine(win->display,win->plotwin,band_gc, sp_xi,0,sp_xi,h1);
      if(sp_yi>-1 && sp_yi<height)
	XDrawLine(win->display,win->plotwin,band_gc, 0,sp_yi,w1,sp_yi);
      show_point_values_undraw = 0;
    }
}

/* Blocks until it get an event */
/* returns 0 if Button 3 is pressed or released else returns 1 */
static int look_for_Button(PlotXwins *win)
{
  XEvent event;

  XWindowEvent(win->display,win->plotwin,
	       PointerMotionMask | ButtonReleaseMask | ButtonPressMask,&event);
  switch(event.type)
    {
    case ButtonPress:
    case ButtonRelease:
      if(event.xbutton.button == Button3)
	return 0;
      return 1;
    default:
      return 1;
    }
}

void print_point_values(PlotXwins *win, Plot *plot, int xi, int yi)
{
  int i;
  char str[100];
  double x,y;

  for(i=0;i<plot->num_plots;i++)
    {

      x = ((xi - plot->z_shift[plot->zoom_count][X])/
	       plot->z_scale[plot->zoom_count][X] -
	       plot->shift[i][X])/plot->scale[i][X];
      y = ((yi - plot->z_shift[plot->zoom_count][Y])/
	       plot->z_scale[plot->zoom_count][Y] -
	       plot->shift[i][Y])/plot->scale[i][Y];
      sprintf(str,"%15.15g %15.15g = (%s X, %s Y )",
		     x,y,plot->label[plot->list[i][X]],
	      plot->label[plot->list[i][Y]]);
      XtVaSetValues(win->valueWig[i],XtNstring,str, NULL);
    }
}


void show_point_values(PlotXwins *win, Plot *plot)
{
  int x,y,do_print;
  unsigned int width, height,w1,h1;


  get_window_size(win->display,win->plotwin,&width,&height);
  if(get_pointer_postion(win,&x,&y))
    {
      fprintf(stderr,"can't get pointer position: file %s line %d\n",
	      __FILE__,__LINE__ -3);
      return;
    }
  h1 = height-1;
  w1 = width-1;

  show_fn_vals_undraw(win,plot,width,height,h1);
  show_pt_vals_undraw(win,plot,width,height,w1,h1);
  show_true_fn_vals_undraw(win,plot,width,height,h1);

  if(x>-1 && x<width)
    XDrawLine(win->display,win->plotwin,band_gc, x,0,x,h1);
  if(y>-1 && y<height)
    XDrawLine(win->display,win->plotwin,band_gc, 0,y,w1,y);

  if(check_popWig(win,plot))
    XFlush(win->display);

  print_point_values(win,plot,x,y);

  XFlush(win->display);
  sp_xi = x;
  sp_yi = y;
  do_print=1;
  while(look_for_Button(win))
    {
      if(get_pointer_postion(win,&x,&y))
	{
	  fprintf(stderr,"can't get pointer position: file %s line %d\n",
		  __FILE__,__LINE__ -3);
	  return;
	}
      if(x!=sp_xi && x>-1 && x<width)
	{
	  XDrawLine(win->display,win->plotwin,band_gc, sp_xi,0,sp_xi,h1);
	  XDrawLine(win->display,win->plotwin,band_gc, x,0,x,h1);
	  sp_xi = x; do_print=1;
	}
      if(y!=sp_yi && y>-1 && y<height)
	{
	  XDrawLine(win->display,win->plotwin,band_gc, 0,sp_yi,w1,sp_yi);
	  XDrawLine(win->display,win->plotwin,band_gc, 0,y,w1,y);
	  sp_yi = y; do_print=1;
	}
      if(do_print)
	{
	  print_point_values(win,plot,x,y);
      	  XFlush(win->display);
	  do_print=0;
	}
    }

  XFlush(win->display);
  show_point_values_undraw = 1;
}
