// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qlabel.h>
#include <qpushbt.h>
#include "YesNoCancelDlg.h"

YesNoCancelDlg::YesNoCancelDlg( const QString& title, const QString& text, QWidget* parent, const char* name )
        : QDialog( parent, name, TRUE )
{
    setCaption( title );
    setIconText( title );

    QLabel* label = new QLabel( text, this );
    label->setAlignment( AlignCenter );
    
    QPushButton* yes    = new QPushButton( "Yes"   , this );
    QPushButton* no     = new QPushButton( "No"    , this );
    QPushButton* cancel = new QPushButton( "Cancel", this );

    connect( yes   , SIGNAL( clicked() ), this, SLOT( yes() ) );
    connect( no    , SIGNAL( clicked() ), this, SLOT( no() ) );
    connect( cancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );

    const int pad = 4;
    const int bw  = 50;
    const int bh  = 24;
    int w = 3 * bw + 4 * pad;
    int h = 3 * pad + bh + label->sizeHint().height();
    if ( label->sizeHint().width() + 2 * pad > w ) {
        w = label->sizeHint().width() + 2 * pad;
    }

    label->setGeometry( pad, pad, label->sizeHint().width(), label->sizeHint().height() );
    yes->setGeometry( pad, h - pad - bh, bw, bh );
    no->setGeometry( ( w - bw ) / 2, h - pad - bh, bw, bh );
    cancel->setGeometry( w - pad - bw, h - pad - bh, bw, bh );
    
    resize( w, h );
}

YesNoCancelDlg::~YesNoCancelDlg()
{
}

void YesNoCancelDlg::yes()
{
    done( Yes );
}

void YesNoCancelDlg::no()
{
    done( No );
}

void YesNoCancelDlg::cancel()
{
    done( Cancel );
}
