// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "Cache.h"
#include "Canvas.h"
#include "Request.h"

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
Request::Request( QString url, Canvas* canvas )
        : _url( url ),
          _totalSize( 0 ),
          _totalRead( 0 ),
          _canvas( canvas )
{
    if ( _canvas ) {
        _canvas->registerRequest( this );
    }
}

Request::Request( const Url& url, Canvas* canvas )
        : _url( url ),
          _totalSize( 0 ),
          _totalRead( 0 ),
          _canvas( canvas )
{
    if ( _canvas ) {
        _canvas->registerRequest( this );
    }
}

Request::~Request()
{
    if ( _canvas ) {
        _canvas->requestDone( this );
    }
    emit done( this );
}

bool Request::open()
{
    if ( _canvas ) {
        return cache->getUrl( this, _url, _canvas->reload() );
    } else {
        return cache->getUrl( this, _url, FALSE );
    }
}

//=============================================================================
// Public slots.
//-----------------------------------------------------------------------------
void Request::abort()
{
    startTimer( 0 );
}

void Request::fwdData( const char* bytes, int length )
{
    _totalRead += length;
    QString msg;
    if ( _totalSize > -1 ) {
        msg.sprintf( "%d%% of %d bytes read", _totalRead * 100 / _totalSize, _totalSize );
    } else {
        msg.sprintf( "%d bytes read", _totalRead );
    }
    emit status( msg );
    emit data( bytes, length );
}

void Request::fwdEndOfData()
{
    emit endOfData();
    delete this;
}

void Request::fwdStartOfData( QString mediaType, QString mediaSubtype, int totalSize )
{
    _totalSize = totalSize;
    emit startOfData( this, mediaType, mediaSubtype, totalSize );
}

void Request::fwdStatus( QString msg )
{
    emit status( msg );
}

void Request::fwdUrlChanged( const Url& url )
{
    emit urlChanged( url );
}

void Request::timerEvent( QTimerEvent* )
{
    killTimers();
    fwdEndOfData();
}
