// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <strings.h>

#ifndef __linux
// For Solaris ... sheesh!
void bcopy(const void *s1, void *s2, size_t n);
#endif
}
#include <qmsgbox.h>
#include "qweb.h"
#include "ConsoleWindow.h"
#include "HostCache.h"
#include "HttpConn.h"
#include "Poller.h"

extern int errno;
#if 0
extern int h_errno;
#endif

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
HttpConn::HttpConn( const Url& url )
        : Connection( url ),
          _state( Init )
{
//    printf( "HttpConn::HttpConn()\n" );
}

//=============================================================================
// Public slots.
//-----------------------------------------------------------------------------
bool HttpConn::open()
{
    _state = Init;
    
    QString msg;

    // Clear redirect location.
    _location = "";

    // Clear headers.
    _header = "";

    // Check for a hostname.
    if ( _url.hostname().length() == 0 ) {
        QString error;
        error.sprintf( "No host name given!" );
        QMessageBox::message( "QWeb: Error", error );
        return FALSE;
    }
	
    // Get remote host address.
    msg.sprintf( "Looking up host %s...", _url.hostname().data() );
    emit status( msg );
#if 0
    struct hostent* remote = gethostbyname( _url.hostname().data() );
    if ( !remote ) {
        QString error;
        error.sprintf( "Cannot find address for host '%s'.\nh_errno = %d.", _url.hostname().data(), h_errno );
        QMessageBox::message( "QWeb: Error", error );
        return FALSE;
    }
#endif
	
    // Create a socket.
    if ( ( _fd = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 ) {
        QString error;
        error.sprintf( "Cannot open socket.\nerrno = %d.", errno );
        QMessageBox::message( "QWeb: Error", error );
        return FALSE;
    }
	
    // Create the remote address.
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    if ( _url.port() < 0 ) {
        addr.sin_port = htons( 80 );
    } else {
        addr.sin_port = htons( _url.port() );
    }
//    bcopy( remote->h_addr_list[0], (void*)(&addr.sin_addr), sizeof( addr.sin_addr ) );
    struct in_addr* a = hostCache->addr( _url.hostname().data() );
    if ( a ) {
        bcopy( a, (void*)(&addr.sin_addr), sizeof( addr.sin_addr ) );
    } else {
        return FALSE;
    }

    // Set socket for non-blocking mode.
    if ( fcntl( _fd, F_SETFL, O_NONBLOCK ) < 0 ) {
//        printf( "Connection::httpOpen() -- fcntl() failed, errno = %d\n", errno );
    }
	
    // Connect to the remote host.
    msg.sprintf( "Connecting to %s...", _url.hostname().data() );
    emit status( msg );
    int foo = ::connect ( _fd, (struct sockaddr*)&addr, sizeof( addr ) );
//    printf( "connect result = %d, errno = %d\n", foo, errno );
#if 0
    if ( ::connect ( _fd, (struct sockaddr*)&addr, sizeof( addr ) ) < 0 ) {
        _fd = -1;
        QString error;
        error.sprintf( "Cannot connect to host '%s'.\nerrno = %d.", _url.hostname().data(), errno );
        QMessageBox::message( "QWeb: Error", error );
        return FALSE;
    }

    // Send HTTP request.
    QString req;

    // Request method.
    req += "GET ";

    if ( _url.path().length() == 0 ) {
        _url.setPath( "/" );
        emit urlChanged( _url );
    }
    
    req += _url.path();

    if ( _url.parameters().length() ) {
        req += ";";
        req += _url.parameters();
    }
    if ( _url.query().length() ) {
        req += "?";
        req += _url.query();
    }
//    if ( _url.fragment().length() ) {
//        req += "#";
//        req += _url.fragment();
//    }
    req += " HTTP/1.0\n";
	
    // User-Agent
    req += "User-Agent: QWeb/";
    req += QWEB_VERSION_STRING;
    req += "\n";

    // List of data types that we can handle.
    req += "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n";
	
    // End of request.
    req += "\n";
    
    msg.sprintf( "Sending HTTP request..." );
    emit status( msg );
    if ( send( _fd, (const char*)req, req.length(), 0 ) < 0 ) {
        QString error;
        error.sprintf( "Send of HTTP request failed.\nerrno = %d.", errno );
        QMessageBox::message( "QWeb: Error", error );
    }
	
    msg.sprintf( "HTTP request sent, waiting for response..." );
    emit status( msg );
	
    // Set socket for non-blocking mode.
    if ( fcntl( _fd, F_SETFL, O_NONBLOCK ) < 0 ) {
//        printf( "Connection::httpOpen() -- fcntl() failed, errno = %d\n", errno );
    }
#endif
	
    poller->reg( this, _fd );
    return TRUE;
}

void HttpConn::readable()
{
    int i, length;
	
    if ( ( length = read( _fd, _bytes, 1024 ) ) < 0 ) {
        abort();
        emit endOfData();
        console->warning( "HttpConn::readable(%d) -- read() failed, errno = %d", _fd, errno );
        delete this;
    } else {
        if ( _state == RequestSent ) {
            _state = Setup;
        }
        if ( length > 0 ) {
            switch ( _state ) {
                case Setup:
                    for ( i = 0; i < length; i++ ) {
                        for ( ; ( i < length ) && ( _bytes[i] != '\n' ); i++ ) {
                            if ( _bytes[i] != '\r' ) {
                                _header += _bytes[i];
                            }
                        }
                        if ( _bytes[i] == '\n' ) {
                            if ( _header.length() > 0 ) {
//                                printf( "HttpConn::readable() -- Header = '%s'\n", (const char*)_header );
                                procHeader();
                                _header = "";
                            } else {
//                                printf( "HttpConn::readable() -- End of headers\n" );
                                if ( _reqStatus == 302 ) {
                                    // 302 -- HTTP Redirect
                                    if ( _location.length() ) {
//                                        printf( "Redirecting to '%s'\n", _location.data() );
                                        poller->dereg( this, _fd );
                                        close( _fd );
                                        _fd = -1;
                                        _url = Url( &_url, _location );
//                                        printf( "Redirecting to '%s'\n", _url.url().data() );
                                        emit urlChanged( _url );
                                        open();
                                        break;
                                    }
                                } else {
//                                if ( _bytes[i+1] == '\r' ) printf( "HttpConn::readable() -- Forgot to eat a \\r\n" );
//                                if ( _bytes[i+1] == '\n' ) printf( "HttpConn::readable() -- Forgot to eat a \\n\n" );
                                    i++; // Skip line feed.
                                    _state = Data;
                                    emit startOfData( _mediaType, _mediaSubtype, _size );
                                    emit data( _bytes + i, length - i );
                                    i = length;
                                }
                            }
                        }
                    }
                    break;
				
                case Data:
                    emit data( _bytes, length );
                    break;

                default:
                    break;
            }
        } else if ( _state == Data ) {
            poller->dereg( this, _fd );
            emit endOfData();
            delete this;
        }
    }
}

void HttpConn::writable()
{
    if ( _state != Init ) return;
    
    // Send HTTP request.
    QString req;

    // Request method.
    req += "GET ";

    if ( _url.path().length() == 0 ) {
        _url.setPath( "/" );
        emit urlChanged( _url );
    } else if ( _url.path()[0] != '/' ) {
        req += '/';
    }
    
    req += _url.path();

    if ( _url.parameters().length() ) {
        req += ";";
        req += _url.parameters();
    }
    if ( _url.query().length() ) {
        req += "?";
        req += _url.query();
    }
//    if ( _url.fragment().length() ) {
//        req += "#";
//        req += _url.fragment();
//    }
    req += " HTTP/1.0\n";
	
    // User-Agent
    req += "User-Agent: QWeb/";
    req += QWEB_VERSION_STRING;
    req += "\n";

    // List of data types that we can handle.
    req += "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n";
	
    // End of request.
    req += "\n";

    QString msg;
    msg.sprintf( "Sending HTTP request..." );
    emit status( msg );
//    printf( "HTTP req = '%s'\n", req.data() );
    if ( send( _fd, (const char*)req, req.length(), 0 ) < 0 ) {
        if ( errno == EAGAIN ) {
            // Try again later...
            return;
        } else {
//            printf( "Send of HTTP request failed, errno = %d.\n", errno );
            return;
        }
    }
	
    msg.sprintf( "HTTP request sent, waiting for response..." );
    emit status( msg );

    _state = RequestSent;
}

//=============================================================================
// Private methods.
//-----------------------------------------------------------------------------
void HttpConn::procHeader()
{
//    printf( "HttpConn::procHeader() -- header = '%s'\n", _header.data() );

    int idx1, idx2;
	
    if ( _header.left( 5 ) == "HTTP/" ) {
        // Request status.
        idx1 = _header.find( '.', 6 );
        idx2 = _header.find( ' ', idx1 );
//		_verMajor = atoi( (const char*)_header.mid( 5, idx1 - 5 ) );
//		_verMinor = atoi( (const char*)_header.mid( idx1, idx2 - idx1 ) );
//		printf( "HttpConn::procHeader() -- Major HTTP version = %d, minor HTTP version = %d\n", _verMajor, _verMinor );
		
        _reqStatus = atoi( _header.mid( idx2 + 1, 3 ) );
//        printf( "HttpConn::procHeader() -- Request status = %d\n", _reqStatus );

        _reqStatusText = _header.mid( idx2 + 5, _header.length() );
//        printf( "HttpConn::procHeader() -- Request status text = '%s'\n", (const char*)_reqStatusText );
    } else {
        if ( ( idx1 = _header.find( ':' ) ) > 0 ) {
            if ( _header.left( idx1 ) == "Server" ) {
//				_server = _header.mid( idx1 + 2, _header.length() );
//				printf( "HttpConn::procHeader() -- Server = '%s'\n", (const char*)_server );
            } else if ( _header.lower().left( idx1 ) == "content-length" ) {
                _size = atoi( (const char*)_header.mid( idx1 + 1, _header.length() ) );
//                printf( "HttpConn::procHeader() -- Content-length = %d\n", _size );
            } else if ( _header.lower().left( idx1 ) == "content-type" ) {
                idx2 = _header.find( '/', idx1 );
                _mediaType = _header.mid( idx1 + 2, idx2 - idx1 - 2 );
                _mediaSubtype = _header.mid( idx2 + 1, _header.length() );
//                printf( "HttpConn::procHeader() -- Media type = '%s', subtype = '%s'\n", (const char*)_mediaType, (const char*)_mediaSubtype );
            } else if ( _header.lower().left( idx1 ) == "location" ) {
                _location = _header.mid( idx1 + 1, _header.length() ).stripWhiteSpace();
//                printf( "HttpConn::procHeader() -- location = '%s'\n", _location.data() );
            }
        }
    }
}
