// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C"
{
#include <ctype.h>
}
#include <qradiobt.h>
#include "Canvas.h"
#include "FormRenderer.h"
#include "Style.h"

FormRenderer::FormRenderer( Canvas*            canvas,
                            SgmlParser*        parser,
                            int                clipWidth,
                            QObject*           parent,
                            const char*        name )
        : VerticalRenderer( canvas, parser, clipWidth, parent, name )
{
}

FormRenderer::~FormRenderer()
{
}

void FormRenderer::startTag()
{
    QString tmp;
    const QString* action = 0;
    const QString* method = 0;
    if ( style()->stringValue( "action-attr", tmp ) ) {
        action = tagStack().getLast()->find( tmp );
    }
    if ( style()->stringValue( "method-attr", tmp ) ) {
        method = tagStack().getLast()->find( tmp );
    }
    
    if ( action ) {
        _action = action->copy();
    }

    if ( method ) {
        _method = method->copy();
    }

    VerticalRenderer::startTag();
}

void FormRenderer::registerFormObject( FormObjectRenderer* formObject )
{
    _formObjects.append( formObject );
}

void FormRenderer::registerRadioButton( QRadioButton* radio )
{
    // Add it to an existing group, if possible.
    QButtonGroup* bg;
    for ( bg = _buttonGroups.first(); bg; bg = _buttonGroups.next() ) {
        if ( !strcmp( bg->name(), radio->name() ) ) {
            bg->insert( radio );
            if ( radio->isChecked() ) {
                // Uncheck any checked buttons in this group.
                int      i;
                QButton* b;
                for ( i = 0; ( b = bg->find( i ) ); i++ ) {
                    if ( !strcmp( b->className(), "QRadioButton" ) ) {
                        if ( b != radio ) {
                            ((QRadioButton*)b)->setChecked( FALSE );
                        }
                    }
                }
            }
            return;
        }
    }

    // Create a new button group.
    bg = new QButtonGroup( /*this*/0, radio->name() );
    bg->insert( radio );
    radio->setChecked( TRUE );
    _buttonGroups.append( bg );
}

void FormRenderer::reset()
{
    QListIterator<FormObjectRenderer> i( _formObjects );
    for ( i.toFirst(); i.current(); ++i ) {
        i.current()->reset();
    }
}

void FormRenderer::submit( FormObjectRenderer* formObject )
{
    // Construct the query.
    QString query;
    QString tmp;

    if ( !strcmp( formObject->className(), "ButtonRenderer" ) ) {
        query += formObject->value();
    } else if ( !strcmp( formObject->className(), "ImageRenderer" ) ) {
        query += formObject->value();
    } else if ( !strcmp( formObject->className(), "EntryRenderer" ) ) {
        // Make sure there is only one entry field before submitting.
        FormObjectRenderer* f;
        for ( f = _formObjects.first(); f; f = _formObjects.next() ) {
            if ( ( f != formObject ) && ( !strcmp( f->className(), "EntryRenderer" ) ) ) {
                // More than one entry field.  Do not submit, but move to next entry field.
//                f->setFocus();
                return;
            }
        }
    }

    // Hidden values first.
    for ( _hiddenNames.first(), _hiddenValues.first();
          _hiddenNames.current() && _hiddenValues.current();
          _hiddenNames.next(), _hiddenValues.next() ) {
//        printf( "FormRenderer::submit() -- name = '%s', value = '%s'\n", _hiddenNames.current(), _hiddenValues.current() );
        if ( query.length() ) {
            query += "&";
        }
        tmp = _hiddenNames.current();
        Url::encode( tmp );
        query += tmp;
        query += "=";
        tmp = _hiddenValues.current();
        Url::encode( tmp );
        query += tmp;
    }
    
    FormObjectRenderer* f;
    for ( f = _formObjects.first(); f; f = _formObjects.next() ) {
        if ( ( strcmp( f->className(), "ButtonRenderer" ) ) && ( strcmp( f->className(), "ImageRenderer" ) ) && ( f->value().length() > 0 ) ) {
//            printf( "FormRenderer::submit() -- value = '%s'\n", f->value().data() );
            if ( query.length() ) {
                query += "&";
            }
            query += f->value();
        }
    }
    
//    printf( "FormRenderer::submit() -- query = '%s'\n", query.data() );

    Url url( &canvas()->baseUrl(), _action );
    url.setQuery( query );
    canvas()->openUrl( url );
}

void FormRenderer::addHidden( const char* name,
                              const char* value )
{
    _hiddenNames.append( name );
    _hiddenValues.append( value );
}
