// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ContentModel_h_
#define _ContentModel_h_

#include "ContentModelState.h"

//: The ContentModel class provides a container for ContentModelStates.
//. The entire list of states taken together form a discrete finite automata
//. that can be used to validate the content model of an SGML element.  A
//. DFA was used because a content model is really just a glorified regular
//. expression, with elements instead of letters for its alphabet.
class ContentModel {
    QList<ContentModelState> _states;
public:
    ContentModel() {}
    ~ContentModel();

    //. Add the given state to the content model.
    void addState( ContentModelState* state );

    //. Search for a state in the content model that is <EM>exactly</EM> the
    //. same as the given state.  Return the dentical state, if found.
    ContentModelState* find( ContentModelState* state );

    //. Return the starting state for the DFA.
    ContentModelState* start() { return _states.first(); }
};

#endif
