/*
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 */

#include "types.h"

#ifdef VIC20

/* VIC20 character ROM. */
BYTE chargen_rom[] = {
    0x1c, 0x22, 0x4a, 0x56, 0x4c, 0x20, 0x1e, 0x00, 	/* 0000 */
    0x18, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0008 */
    0x7c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x7c, 0x00, 	/* 0010 */
    0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 	/* 0018 */
    0x78, 0x24, 0x22, 0x22, 0x22, 0x24, 0x78, 0x00, 	/* 0020 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7e, 0x00, 	/* 0028 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 	/* 0030 */
    0x1c, 0x22, 0x40, 0x4e, 0x42, 0x22, 0x1c, 0x00, 	/* 0038 */
    0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0040 */
    0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0048 */
    0x0e, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 	/* 0050 */
    0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 	/* 0058 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 	/* 0060 */
    0x42, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 	/* 0068 */
    0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x00, 	/* 0070 */
    0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 0078 */
    0x7c, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 	/* 0080 */
    0x18, 0x24, 0x42, 0x42, 0x4a, 0x24, 0x1a, 0x00, 	/* 0088 */
    0x7c, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x00, 	/* 0090 */
    0x3c, 0x42, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 	/* 0098 */
    0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 	/* 00a0 */
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 00a8 */
    0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 	/* 00b0 */
    0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x42, 0x00, 	/* 00b8 */
    0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 	/* 00c0 */
    0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 	/* 00c8 */
    0x7e, 0x02, 0x04, 0x18, 0x20, 0x40, 0x7e, 0x00, 	/* 00d0 */
    0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 	/* 00d8 */
    0x0c, 0x10, 0x10, 0x3c, 0x10, 0x70, 0x6e, 0x00, 	/* 00e0 */
    0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 	/* 00e8 */
    0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 	/* 00f0 */
    0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 	/* 00f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0100 */
    0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 	/* 0108 */
    0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0110 */
    0x24, 0x24, 0x7e, 0x24, 0x7e, 0x24, 0x24, 0x00, 	/* 0118 */
    0x08, 0x1e, 0x28, 0x1c, 0x0a, 0x3c, 0x08, 0x00, 	/* 0120 */
    0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00, 	/* 0128 */
    0x30, 0x48, 0x48, 0x30, 0x4a, 0x44, 0x3a, 0x00, 	/* 0130 */
    0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0138 */
    0x04, 0x08, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 	/* 0140 */
    0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 	/* 0148 */
    0x08, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x00, 	/* 0150 */
    0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 	/* 0158 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 0160 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 	/* 0168 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 	/* 0170 */
    0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 	/* 0178 */
    0x3c, 0x42, 0x46, 0x5a, 0x62, 0x42, 0x3c, 0x00, 	/* 0180 */
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x3e, 0x00, 	/* 0188 */
    0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x7e, 0x00, 	/* 0190 */
    0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 	/* 0198 */
    0x04, 0x0c, 0x14, 0x24, 0x7e, 0x04, 0x04, 0x00, 	/* 01a0 */
    0x7e, 0x40, 0x78, 0x04, 0x02, 0x44, 0x38, 0x00, 	/* 01a8 */
    0x1c, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x3c, 0x00, 	/* 01b0 */
    0x7e, 0x42, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00, 	/* 01b8 */
    0x3c, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x3c, 0x00, 	/* 01c0 */
    0x3c, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x38, 0x00, 	/* 01c8 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 	/* 01d0 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 01d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00, 	/* 01e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 	/* 01e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00, 	/* 01f0 */
    0x3c, 0x42, 0x02, 0x0c, 0x10, 0x00, 0x10, 0x00, 	/* 01f8 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 	/* 0200 */
    0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x1c, 0x3e, 0x00, 	/* 0208 */
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 	/* 0210 */
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0218 */
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0220 */
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0228 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 	/* 0230 */
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 	/* 0238 */
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 	/* 0240 */
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x08, 0x08, 	/* 0248 */
    0x08, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00, 	/* 0250 */
    0x08, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x00, 	/* 0258 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 	/* 0260 */
    0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 	/* 0268 */
    0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 	/* 0270 */
    0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0278 */
    0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0280 */
    0x00, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x00, 	/* 0288 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 	/* 0290 */
    0x36, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 	/* 0298 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 	/* 02a0 */
    0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08, 	/* 02a8 */
    0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81, 	/* 02b0 */
    0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 02b8 */
    0x08, 0x1c, 0x2a, 0x77, 0x2a, 0x08, 0x08, 0x00, 	/* 02c0 */
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 	/* 02c8 */
    0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 	/* 02d0 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 	/* 02d8 */
    0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 	/* 02e0 */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 	/* 02e8 */
    0x00, 0x00, 0x01, 0x3e, 0x54, 0x14, 0x14, 0x00, 	/* 02f0 */
    0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 	/* 02f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0300 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0308 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0310 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0318 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 	/* 0320 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0328 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 	/* 0330 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0338 */
    0x00, 0x00, 0x00, 0x00, 0xaa, 0x55, 0xaa, 0x55, 	/* 0340 */
    0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 	/* 0348 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 	/* 0350 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 	/* 0358 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0360 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 	/* 0368 */
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 	/* 0370 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 	/* 0378 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 	/* 0380 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 	/* 0388 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 	/* 0390 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 	/* 0398 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 	/* 03a0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 	/* 03a8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 	/* 03b0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 03b8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 03c0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 	/* 03c8 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff, 	/* 03d0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 03d8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 	/* 03e0 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 	/* 03e8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 	/* 03f0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 03f8 */
    0xe3, 0xdd, 0xb5, 0xa9, 0xb3, 0xdf, 0xe1, 0xff, 	/* 0400 */
    0xe7, 0xdb, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0408 */
    0x83, 0xdd, 0xdd, 0xc3, 0xdd, 0xdd, 0x83, 0xff, 	/* 0410 */
    0xe3, 0xdd, 0xbf, 0xbf, 0xbf, 0xdd, 0xe3, 0xff, 	/* 0418 */
    0x87, 0xdb, 0xdd, 0xdd, 0xdd, 0xdb, 0x87, 0xff, 	/* 0420 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0x81, 0xff, 	/* 0428 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0430 */
    0xe3, 0xdd, 0xbf, 0xb1, 0xbd, 0xdd, 0xe3, 0xff, 	/* 0438 */
    0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0440 */
    0xe3, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0448 */
    0xf1, 0xfb, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 0xff, 	/* 0450 */
    0xbd, 0xbb, 0xb7, 0x8f, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0458 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0x81, 0xff, 	/* 0460 */
    0xbd, 0x99, 0xa5, 0xa5, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0468 */
    0xbd, 0x9d, 0xad, 0xb5, 0xb9, 0xbd, 0xbd, 0xff, 	/* 0470 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0478 */
    0x83, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0480 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xb5, 0xdb, 0xe5, 0xff, 	/* 0488 */
    0x83, 0xbd, 0xbd, 0x83, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0490 */
    0xc3, 0xbd, 0xbf, 0xc3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0498 */
    0xc1, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xff, 	/* 04a0 */
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 04a8 */
    0xbd, 0xbd, 0xbd, 0xdb, 0xdb, 0xe7, 0xe7, 0xff, 	/* 04b0 */
    0xbd, 0xbd, 0xbd, 0xa5, 0xa5, 0x99, 0xbd, 0xff, 	/* 04b8 */
    0xbd, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xbd, 0xff, 	/* 04c0 */
    0xdd, 0xdd, 0xdd, 0xe3, 0xf7, 0xf7, 0xf7, 0xff, 	/* 04c8 */
    0x81, 0xfd, 0xfb, 0xe7, 0xdf, 0xbf, 0x81, 0xff, 	/* 04d0 */
    0xc3, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xc3, 0xff, 	/* 04d8 */
    0xf3, 0xef, 0xef, 0xc3, 0xef, 0x8f, 0x91, 0xff, 	/* 04e0 */
    0xc3, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xc3, 0xff, 	/* 04e8 */
    0xff, 0xf7, 0xe3, 0xd5, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 04f0 */
    0xff, 0xff, 0xef, 0xdf, 0x80, 0xdf, 0xef, 0xff, 	/* 04f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0500 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xff, 0xff, 0xf7, 0xff, 	/* 0508 */
    0xdb, 0xdb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0510 */
    0xdb, 0xdb, 0x81, 0xdb, 0x81, 0xdb, 0xdb, 0xff, 	/* 0518 */
    0xf7, 0xe1, 0xd7, 0xe3, 0xf5, 0xc3, 0xf7, 0xff, 	/* 0520 */
    0xff, 0x9d, 0x9b, 0xf7, 0xef, 0xd9, 0xb9, 0xff, 	/* 0528 */
    0xcf, 0xb7, 0xb7, 0xcf, 0xb5, 0xbb, 0xc5, 0xff, 	/* 0530 */
    0xfb, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0538 */
    0xfb, 0xf7, 0xef, 0xef, 0xef, 0xf7, 0xfb, 0xff, 	/* 0540 */
    0xdf, 0xef, 0xf7, 0xf7, 0xf7, 0xef, 0xdf, 0xff, 	/* 0548 */
    0xf7, 0xd5, 0xe3, 0xc1, 0xe3, 0xd5, 0xf7, 0xff, 	/* 0550 */
    0xff, 0xf7, 0xf7, 0xc1, 0xf7, 0xf7, 0xff, 0xff, 	/* 0558 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0560 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 	/* 0568 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff, 	/* 0570 */
    0xff, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0xff, 	/* 0578 */
    0xc3, 0xbd, 0xb9, 0xa5, 0x9d, 0xbd, 0xc3, 0xff, 	/* 0580 */
    0xf7, 0xe7, 0xd7, 0xf7, 0xf7, 0xf7, 0xc1, 0xff, 	/* 0588 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xcf, 0xbf, 0x81, 0xff, 	/* 0590 */
    0xc3, 0xbd, 0xfd, 0xe3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0598 */
    0xfb, 0xf3, 0xeb, 0xdb, 0x81, 0xfb, 0xfb, 0xff, 	/* 05a0 */
    0x81, 0xbf, 0x87, 0xfb, 0xfd, 0xbb, 0xc7, 0xff, 	/* 05a8 */
    0xe3, 0xdf, 0xbf, 0x83, 0xbd, 0xbd, 0xc3, 0xff, 	/* 05b0 */
    0x81, 0xbd, 0xfb, 0xf7, 0xef, 0xef, 0xef, 0xff, 	/* 05b8 */
    0xc3, 0xbd, 0xbd, 0xc3, 0xbd, 0xbd, 0xc3, 0xff, 	/* 05c0 */
    0xc3, 0xbd, 0xbd, 0xc1, 0xfd, 0xfb, 0xc7, 0xff, 	/* 05c8 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xff, 0xff, 	/* 05d0 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 05d8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff, 	/* 05e0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff, 	/* 05e8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff, 	/* 05f0 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xef, 0xff, 0xef, 0xff, 	/* 05f8 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 	/* 0600 */
    0xf7, 0xe3, 0xc1, 0x80, 0x80, 0xe3, 0xc1, 0xff, 	/* 0608 */
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 	/* 0610 */
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0618 */
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0620 */
    0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0628 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 	/* 0630 */
    0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 	/* 0638 */
    0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 	/* 0640 */
    0xff, 0xff, 0xff, 0xff, 0x1f, 0xef, 0xf7, 0xf7, 	/* 0648 */
    0xf7, 0xf7, 0xf7, 0xfb, 0xfc, 0xff, 0xff, 0xff, 	/* 0650 */
    0xf7, 0xf7, 0xf7, 0xef, 0x1f, 0xff, 0xff, 0xff, 	/* 0658 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 	/* 0660 */
    0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe, 	/* 0668 */
    0xfe, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7f, 	/* 0670 */
    0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0678 */
    0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0680 */
    0xff, 0xc3, 0x81, 0x81, 0x81, 0x81, 0xc3, 0xff, 	/* 0688 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 	/* 0690 */
    0xc9, 0x80, 0x80, 0x80, 0xc1, 0xe3, 0xf7, 0xff, 	/* 0698 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 	/* 06a0 */
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xfb, 0xf7, 0xf7, 	/* 06a8 */
    0x7e, 0xbd, 0xdb, 0xe7, 0xe7, 0xdb, 0xbd, 0x7e, 	/* 06b0 */
    0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 06b8 */
    0xf7, 0xe3, 0xd5, 0x88, 0xd5, 0xf7, 0xf7, 0xff, 	/* 06c0 */
    0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 	/* 06c8 */
    0xf7, 0xe3, 0xc1, 0x80, 0xc1, 0xe3, 0xf7, 0xff, 	/* 06d0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf7, 	/* 06d8 */
    0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 	/* 06e0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 06e8 */
    0xff, 0xff, 0xfe, 0xc1, 0xab, 0xeb, 0xeb, 0xff, 	/* 06f0 */
    0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 	/* 06f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0700 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0708 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0710 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0718 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 	/* 0720 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0728 */
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 	/* 0730 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0738 */
    0xff, 0xff, 0xff, 0xff, 0x55, 0xaa, 0x55, 0xaa, 	/* 0740 */
    0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 	/* 0748 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 	/* 0750 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0758 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0760 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xff, 0xff, 0xff, 	/* 0768 */
    0xff, 0xff, 0xff, 0xff, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0770 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 	/* 0778 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0780 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xff, 0xff, 0xff, 	/* 0788 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0790 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0798 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 	/* 07a0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 	/* 07a8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 	/* 07b0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 07b8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 07c0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 	/* 07c8 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 	/* 07d0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 07d8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 	/* 07e0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xff, 0xff, 0xff, 	/* 07e8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 	/* 07f0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 07f8 */
    0x1c, 0x22, 0x4a, 0x56, 0x4c, 0x20, 0x1e, 0x00, 	/* 0800 */
    0x00, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3a, 0x00, 	/* 0808 */
    0x40, 0x40, 0x5c, 0x62, 0x42, 0x62, 0x5c, 0x00, 	/* 0810 */
    0x00, 0x00, 0x3c, 0x42, 0x40, 0x42, 0x3c, 0x00, 	/* 0818 */
    0x02, 0x02, 0x3a, 0x46, 0x42, 0x46, 0x3a, 0x00, 	/* 0820 */
    0x00, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00, 	/* 0828 */
    0x0c, 0x12, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x00, 	/* 0830 */
    0x00, 0x00, 0x3a, 0x46, 0x46, 0x3a, 0x02, 0x3c, 	/* 0838 */
    0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x00, 	/* 0840 */
    0x08, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0848 */
    0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x44, 0x38, 	/* 0850 */
    0x40, 0x40, 0x44, 0x48, 0x50, 0x68, 0x44, 0x00, 	/* 0858 */
    0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0860 */
    0x00, 0x00, 0x76, 0x49, 0x49, 0x49, 0x49, 0x00, 	/* 0868 */
    0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x00, 	/* 0870 */
    0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 0878 */
    0x00, 0x00, 0x5c, 0x62, 0x62, 0x5c, 0x40, 0x40, 	/* 0880 */
    0x00, 0x00, 0x3a, 0x46, 0x46, 0x3a, 0x02, 0x02, 	/* 0888 */
    0x00, 0x00, 0x5c, 0x62, 0x40, 0x40, 0x40, 0x00, 	/* 0890 */
    0x00, 0x00, 0x3e, 0x40, 0x3c, 0x02, 0x7c, 0x00, 	/* 0898 */
    0x10, 0x10, 0x7c, 0x10, 0x10, 0x12, 0x0c, 0x00, 	/* 08a0 */
    0x00, 0x00, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 	/* 08a8 */
    0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 08b0 */
    0x00, 0x00, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00, 	/* 08b8 */
    0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 	/* 08c0 */
    0x00, 0x00, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x3c, 	/* 08c8 */
    0x00, 0x00, 0x7e, 0x04, 0x18, 0x20, 0x7e, 0x00, 	/* 08d0 */
    0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 	/* 08d8 */
    0x0c, 0x10, 0x10, 0x3c, 0x10, 0x70, 0x6e, 0x00, 	/* 08e0 */
    0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 	/* 08e8 */
    0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 	/* 08f0 */
    0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 	/* 08f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0900 */
    0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 	/* 0908 */
    0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0910 */
    0x24, 0x24, 0x7e, 0x24, 0x7e, 0x24, 0x24, 0x00, 	/* 0918 */
    0x08, 0x1e, 0x28, 0x1c, 0x0a, 0x3c, 0x08, 0x00, 	/* 0920 */
    0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00, 	/* 0928 */
    0x30, 0x48, 0x48, 0x30, 0x4a, 0x44, 0x3a, 0x00, 	/* 0930 */
    0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0938 */
    0x04, 0x08, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 	/* 0940 */
    0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 	/* 0948 */
    0x08, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x00, 	/* 0950 */
    0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 	/* 0958 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 0960 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 	/* 0968 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 	/* 0970 */
    0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 	/* 0978 */
    0x3c, 0x42, 0x46, 0x5a, 0x62, 0x42, 0x3c, 0x00, 	/* 0980 */
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x3e, 0x00, 	/* 0988 */
    0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x7e, 0x00, 	/* 0990 */
    0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 	/* 0998 */
    0x04, 0x0c, 0x14, 0x24, 0x7e, 0x04, 0x04, 0x00, 	/* 09a0 */
    0x7e, 0x40, 0x78, 0x04, 0x02, 0x44, 0x38, 0x00, 	/* 09a8 */
    0x1c, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x3c, 0x00, 	/* 09b0 */
    0x7e, 0x42, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00, 	/* 09b8 */
    0x3c, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x3c, 0x00, 	/* 09c0 */
    0x3c, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x38, 0x00, 	/* 09c8 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 	/* 09d0 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 09d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00, 	/* 09e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 	/* 09e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00, 	/* 09f0 */
    0x3c, 0x42, 0x02, 0x0c, 0x10, 0x00, 0x10, 0x00, 	/* 09f8 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 	/* 0a00 */
    0x18, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0a08 */
    0x7c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x7c, 0x00, 	/* 0a10 */
    0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 	/* 0a18 */
    0x78, 0x24, 0x22, 0x22, 0x22, 0x24, 0x78, 0x00, 	/* 0a20 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7e, 0x00, 	/* 0a28 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 	/* 0a30 */
    0x1c, 0x22, 0x40, 0x4e, 0x42, 0x22, 0x1c, 0x00, 	/* 0a38 */
    0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0a40 */
    0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0a48 */
    0x0e, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 	/* 0a50 */
    0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 	/* 0a58 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 	/* 0a60 */
    0x42, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 	/* 0a68 */
    0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x00, 	/* 0a70 */
    0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 0a78 */
    0x7c, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 	/* 0a80 */
    0x18, 0x24, 0x42, 0x42, 0x4a, 0x24, 0x1a, 0x00, 	/* 0a88 */
    0x7c, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x00, 	/* 0a90 */
    0x3c, 0x42, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 	/* 0a98 */
    0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 	/* 0aa0 */
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 0aa8 */
    0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 	/* 0ab0 */
    0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x42, 0x00, 	/* 0ab8 */
    0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 	/* 0ac0 */
    0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 	/* 0ac8 */
    0x7e, 0x02, 0x04, 0x18, 0x20, 0x40, 0x7e, 0x00, 	/* 0ad0 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 	/* 0ad8 */
    0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 	/* 0ae0 */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 	/* 0ae8 */
    0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 	/* 0af0 */
    0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 0x33, 0x99, 	/* 0af8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0b00 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0b08 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0b10 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0b18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 	/* 0b20 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0b28 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 	/* 0b30 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0b38 */
    0x00, 0x00, 0x00, 0x00, 0xaa, 0x55, 0xaa, 0x55, 	/* 0b40 */
    0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc, 	/* 0b48 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 	/* 0b50 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 	/* 0b58 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0b60 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 	/* 0b68 */
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 	/* 0b70 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 	/* 0b78 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 	/* 0b80 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 	/* 0b88 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 	/* 0b90 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 	/* 0b98 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 	/* 0ba0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 	/* 0ba8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 	/* 0bb0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0bb8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0bc0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 	/* 0bc8 */
    0x01, 0x02, 0x44, 0x48, 0x50, 0x60, 0x40, 0x00, 	/* 0bd0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0bd8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 	/* 0be0 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 	/* 0be8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 	/* 0bf0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0bf8 */
    0xe3, 0xdd, 0xb5, 0xa9, 0xb3, 0xdf, 0xe1, 0xff, 	/* 0c00 */
    0xff, 0xff, 0xc7, 0xfb, 0xc3, 0xbb, 0xc5, 0xff, 	/* 0c08 */
    0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0x9d, 0xa3, 0xff, 	/* 0c10 */
    0xff, 0xff, 0xc3, 0xbd, 0xbf, 0xbd, 0xc3, 0xff, 	/* 0c18 */
    0xfd, 0xfd, 0xc5, 0xb9, 0xbd, 0xb9, 0xc5, 0xff, 	/* 0c20 */
    0xff, 0xff, 0xc3, 0xbd, 0x81, 0xbf, 0xc3, 0xff, 	/* 0c28 */
    0xf3, 0xed, 0xef, 0x83, 0xef, 0xef, 0xef, 0xff, 	/* 0c30 */
    0xff, 0xff, 0xc5, 0xb9, 0xb9, 0xc5, 0xfd, 0xc3, 	/* 0c38 */
    0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0c40 */
    0xf7, 0xff, 0xe7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0c48 */
    0xfb, 0xff, 0xf3, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 	/* 0c50 */
    0xbf, 0xbf, 0xbb, 0xb7, 0xaf, 0x97, 0xbb, 0xff, 	/* 0c58 */
    0xe7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0c60 */
    0xff, 0xff, 0x89, 0xb6, 0xb6, 0xb6, 0xb6, 0xff, 	/* 0c68 */
    0xff, 0xff, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0c70 */
    0xff, 0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0c78 */
    0xff, 0xff, 0xa3, 0x9d, 0x9d, 0xa3, 0xbf, 0xbf, 	/* 0c80 */
    0xff, 0xff, 0xc5, 0xb9, 0xb9, 0xc5, 0xfd, 0xfd, 	/* 0c88 */
    0xff, 0xff, 0xa3, 0x9d, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0c90 */
    0xff, 0xff, 0xc1, 0xbf, 0xc3, 0xfd, 0x83, 0xff, 	/* 0c98 */
    0xef, 0xef, 0x83, 0xef, 0xef, 0xed, 0xf3, 0xff, 	/* 0ca0 */
    0xff, 0xff, 0xbd, 0xbd, 0xbd, 0xb9, 0xc5, 0xff, 	/* 0ca8 */
    0xff, 0xff, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0cb0 */
    0xff, 0xff, 0xbe, 0xb6, 0xb6, 0xb6, 0xc9, 0xff, 	/* 0cb8 */
    0xff, 0xff, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xff, 	/* 0cc0 */
    0xff, 0xff, 0xbd, 0xbd, 0xb9, 0xc5, 0xfd, 0xc3, 	/* 0cc8 */
    0xff, 0xff, 0x81, 0xfb, 0xe7, 0xdf, 0x81, 0xff, 	/* 0cd0 */
    0xc3, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xc3, 0xff, 	/* 0cd8 */
    0xf3, 0xef, 0xef, 0xc3, 0xef, 0x8f, 0x91, 0xff, 	/* 0ce0 */
    0xc3, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xc3, 0xff, 	/* 0ce8 */
    0xff, 0xf7, 0xe3, 0xd5, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 0cf0 */
    0xff, 0xff, 0xef, 0xdf, 0x80, 0xdf, 0xef, 0xff, 	/* 0cf8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d00 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xff, 0xff, 0xf7, 0xff, 	/* 0d08 */
    0xdb, 0xdb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d10 */
    0xdb, 0xdb, 0x81, 0xdb, 0x81, 0xdb, 0xdb, 0xff, 	/* 0d18 */
    0xf7, 0xe1, 0xd7, 0xe3, 0xf5, 0xc3, 0xf7, 0xff, 	/* 0d20 */
    0xff, 0x9d, 0x9b, 0xf7, 0xef, 0xd9, 0xb9, 0xff, 	/* 0d28 */
    0xcf, 0xb7, 0xb7, 0xcf, 0xb5, 0xbb, 0xc5, 0xff, 	/* 0d30 */
    0xfb, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d38 */
    0xfb, 0xf7, 0xef, 0xef, 0xef, 0xf7, 0xfb, 0xff, 	/* 0d40 */
    0xdf, 0xef, 0xf7, 0xf7, 0xf7, 0xef, 0xdf, 0xff, 	/* 0d48 */
    0xf7, 0xd5, 0xe3, 0xc1, 0xe3, 0xd5, 0xf7, 0xff, 	/* 0d50 */
    0xff, 0xf7, 0xf7, 0xc1, 0xf7, 0xf7, 0xff, 0xff, 	/* 0d58 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0d60 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 	/* 0d68 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff, 	/* 0d70 */
    0xff, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0xff, 	/* 0d78 */
    0xc3, 0xbd, 0xb9, 0xa5, 0x9d, 0xbd, 0xc3, 0xff, 	/* 0d80 */
    0xf7, 0xe7, 0xd7, 0xf7, 0xf7, 0xf7, 0xc1, 0xff, 	/* 0d88 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xcf, 0xbf, 0x81, 0xff, 	/* 0d90 */
    0xc3, 0xbd, 0xfd, 0xe3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0d98 */
    0xfb, 0xf3, 0xeb, 0xdb, 0x81, 0xfb, 0xfb, 0xff, 	/* 0da0 */
    0x81, 0xbf, 0x87, 0xfb, 0xfd, 0xbb, 0xc7, 0xff, 	/* 0da8 */
    0xe3, 0xdf, 0xbf, 0x83, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0db0 */
    0x81, 0xbd, 0xfb, 0xf7, 0xef, 0xef, 0xef, 0xff, 	/* 0db8 */
    0xc3, 0xbd, 0xbd, 0xc3, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0dc0 */
    0xc3, 0xbd, 0xbd, 0xc1, 0xfd, 0xfb, 0xc7, 0xff, 	/* 0dc8 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xff, 0xff, 	/* 0dd0 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0dd8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff, 	/* 0de0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff, 	/* 0de8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff, 	/* 0df0 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xef, 0xff, 0xef, 0xff, 	/* 0df8 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 	/* 0e00 */
    0xe7, 0xdb, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e08 */
    0x83, 0xdd, 0xdd, 0xc3, 0xdd, 0xdd, 0x83, 0xff, 	/* 0e10 */
    0xe3, 0xdd, 0xbf, 0xbf, 0xbf, 0xdd, 0xe3, 0xff, 	/* 0e18 */
    0x87, 0xdb, 0xdd, 0xdd, 0xdd, 0xdb, 0x87, 0xff, 	/* 0e20 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0x81, 0xff, 	/* 0e28 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0e30 */
    0xe3, 0xdd, 0xbf, 0xb1, 0xbd, 0xdd, 0xe3, 0xff, 	/* 0e38 */
    0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e40 */
    0xe3, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0e48 */
    0xf1, 0xfb, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 0xff, 	/* 0e50 */
    0xbd, 0xbb, 0xb7, 0x8f, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0e58 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0x81, 0xff, 	/* 0e60 */
    0xbd, 0x99, 0xa5, 0xa5, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e68 */
    0xbd, 0x9d, 0xad, 0xb5, 0xb9, 0xbd, 0xbd, 0xff, 	/* 0e70 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0e78 */
    0x83, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0e80 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xb5, 0xdb, 0xe5, 0xff, 	/* 0e88 */
    0x83, 0xbd, 0xbd, 0x83, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0e90 */
    0xc3, 0xbd, 0xbf, 0xc3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0e98 */
    0xc1, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xff, 	/* 0ea0 */
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0ea8 */
    0xbd, 0xbd, 0xbd, 0xdb, 0xdb, 0xe7, 0xe7, 0xff, 	/* 0eb0 */
    0xbd, 0xbd, 0xbd, 0xa5, 0xa5, 0x99, 0xbd, 0xff, 	/* 0eb8 */
    0xbd, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xbd, 0xff, 	/* 0ec0 */
    0xdd, 0xdd, 0xdd, 0xe3, 0xf7, 0xf7, 0xf7, 0xff, 	/* 0ec8 */
    0x81, 0xfd, 0xfb, 0xe7, 0xdf, 0xbf, 0x81, 0xff, 	/* 0ed0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0ed8 */
    0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 	/* 0ee0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 0ee8 */
    0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 	/* 0ef0 */
    0x33, 0x99, 0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 	/* 0ef8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0f00 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0f08 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0f10 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0f18 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 	/* 0f20 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0f28 */
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 	/* 0f30 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0f38 */
    0xff, 0xff, 0xff, 0xff, 0x55, 0xaa, 0x55, 0xaa, 	/* 0f40 */
    0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 	/* 0f48 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 	/* 0f50 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0f58 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0f60 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xff, 0xff, 0xff, 	/* 0f68 */
    0xff, 0xff, 0xff, 0xff, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0f70 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 	/* 0f78 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0f80 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xff, 0xff, 0xff, 	/* 0f88 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0f90 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0f98 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 	/* 0fa0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 	/* 0fa8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 	/* 0fb0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0fb8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0fc0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 	/* 0fc8 */
    0xfe, 0xfd, 0xbb, 0xb7, 0xaf, 0x9f, 0xbf, 0xff, 	/* 0fd0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0fd8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 	/* 0fe0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xff, 0xff, 0xff, 	/* 0fe8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 	/* 0ff0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0 	/* 0ff8 */
};

#elif defined(PET)

/* Commodore PET 3032/4032/8032 character ROM. */
BYTE chargen_rom[] = {
    0x1c, 0x22, 0x4a, 0x56, 0x4c, 0x20, 0x1e, 0x00, 	/* 0000 */
    0x18, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0008 */
    0x7c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x7c, 0x00, 	/* 0010 */
    0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 	/* 0018 */
    0x78, 0x24, 0x22, 0x22, 0x22, 0x24, 0x78, 0x00, 	/* 0020 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7e, 0x00, 	/* 0028 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 	/* 0030 */
    0x1c, 0x22, 0x40, 0x4e, 0x42, 0x22, 0x1c, 0x00, 	/* 0038 */
    0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0040 */
    0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0048 */
    0x0e, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 	/* 0050 */
    0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 	/* 0058 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 	/* 0060 */
    0x42, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 	/* 0068 */
    0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x00, 	/* 0070 */
    0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 0078 */
    0x7c, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 	/* 0080 */
    0x18, 0x24, 0x42, 0x42, 0x4a, 0x24, 0x1a, 0x00, 	/* 0088 */
    0x7c, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x00, 	/* 0090 */
    0x3c, 0x42, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 	/* 0098 */
    0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 	/* 00a0 */
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 00a8 */
    0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 	/* 00b0 */
    0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x42, 0x00, 	/* 00b8 */
    0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 	/* 00c0 */
    0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 	/* 00c8 */
    0x7e, 0x02, 0x04, 0x18, 0x20, 0x40, 0x7e, 0x00, 	/* 00d0 */
    0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 	/* 00d8 */
    0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 	/* 00e0 */
    0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 	/* 00e8 */
    0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 	/* 00f0 */
    0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 	/* 00f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0100 */
    0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 	/* 0108 */
    0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0110 */
    0x24, 0x24, 0x7e, 0x24, 0x7e, 0x24, 0x24, 0x00, 	/* 0118 */
    0x08, 0x1e, 0x28, 0x1c, 0x0a, 0x3c, 0x08, 0x00, 	/* 0120 */
    0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00, 	/* 0128 */
    0x30, 0x48, 0x48, 0x30, 0x4a, 0x44, 0x3a, 0x00, 	/* 0130 */
    0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0138 */
    0x04, 0x08, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 	/* 0140 */
    0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 	/* 0148 */
    0x08, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x00, 	/* 0150 */
    0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 	/* 0158 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 0160 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 	/* 0168 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 	/* 0170 */
    0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 	/* 0178 */
    0x3c, 0x42, 0x46, 0x5a, 0x62, 0x42, 0x3c, 0x00, 	/* 0180 */
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x3e, 0x00, 	/* 0188 */
    0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x7e, 0x00, 	/* 0190 */
    0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 	/* 0198 */
    0x04, 0x0c, 0x14, 0x24, 0x7e, 0x04, 0x04, 0x00, 	/* 01a0 */
    0x7e, 0x40, 0x78, 0x04, 0x02, 0x44, 0x38, 0x00, 	/* 01a8 */
    0x1c, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x3c, 0x00, 	/* 01b0 */
    0x7e, 0x42, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00, 	/* 01b8 */
    0x3c, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x3c, 0x00, 	/* 01c0 */
    0x3c, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x38, 0x00, 	/* 01c8 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 	/* 01d0 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 01d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00, 	/* 01e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 	/* 01e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00, 	/* 01f0 */
    0x3c, 0x42, 0x02, 0x0c, 0x10, 0x00, 0x10, 0x00, 	/* 01f8 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 	/* 0200 */
    0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x1c, 0x3e, 0x00, 	/* 0208 */
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 	/* 0210 */
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0218 */
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0220 */
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0228 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 	/* 0230 */
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 	/* 0238 */
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 	/* 0240 */
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x08, 0x08, 	/* 0248 */
    0x08, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00, 	/* 0250 */
    0x08, 0x08, 0x08, 0x10, 0xe0, 0x00, 0x00, 0x00, 	/* 0258 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 	/* 0260 */
    0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 	/* 0268 */
    0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 	/* 0270 */
    0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0278 */
    0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0280 */
    0x00, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x00, 	/* 0288 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 	/* 0290 */
    0x36, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 	/* 0298 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 	/* 02a0 */
    0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08, 	/* 02a8 */
    0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81, 	/* 02b0 */
    0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 02b8 */
    0x08, 0x1c, 0x2a, 0x77, 0x2a, 0x08, 0x08, 0x00, 	/* 02c0 */
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 	/* 02c8 */
    0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 	/* 02d0 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 	/* 02d8 */
    0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 	/* 02e0 */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 	/* 02e8 */
    0x00, 0x00, 0x01, 0x3e, 0x54, 0x14, 0x14, 0x00, 	/* 02f0 */
    0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 	/* 02f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0300 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0308 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0310 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0318 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 	/* 0320 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0328 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 	/* 0330 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0338 */
    0x00, 0x00, 0x00, 0x00, 0xaa, 0x55, 0xaa, 0x55, 	/* 0340 */
    0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 	/* 0348 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 	/* 0350 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 	/* 0358 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0360 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 	/* 0368 */
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 	/* 0370 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 	/* 0378 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 	/* 0380 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 	/* 0388 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 	/* 0390 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 	/* 0398 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 	/* 03a0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 	/* 03a8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 	/* 03b0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 03b8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 03c0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 	/* 03c8 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff, 	/* 03d0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 03d8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 	/* 03e0 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 	/* 03e8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 	/* 03f0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 03f8 */
    0xe3, 0xdd, 0xb5, 0xa9, 0xb3, 0xdf, 0xe1, 0xff, 	/* 0400 */
    0xe7, 0xdb, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0408 */
    0x83, 0xdd, 0xdd, 0xc3, 0xdd, 0xdd, 0x83, 0xff, 	/* 0410 */
    0xe3, 0xdd, 0xbf, 0xbf, 0xbf, 0xdd, 0xe3, 0xff, 	/* 0418 */
    0x87, 0xdb, 0xdd, 0xdd, 0xdd, 0xdb, 0x87, 0xff, 	/* 0420 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0x81, 0xff, 	/* 0428 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0430 */
    0xe3, 0xdd, 0xbf, 0xb1, 0xbd, 0xdd, 0xe3, 0xff, 	/* 0438 */
    0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0440 */
    0xe3, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0448 */
    0xf1, 0xfb, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 0xff, 	/* 0450 */
    0xbd, 0xbb, 0xb7, 0x8f, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0458 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0x81, 0xff, 	/* 0460 */
    0xbd, 0x99, 0xa5, 0xa5, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0468 */
    0xbd, 0x9d, 0xad, 0xb5, 0xb9, 0xbd, 0xbd, 0xff, 	/* 0470 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0478 */
    0x83, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0480 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xb5, 0xdb, 0xe5, 0xff, 	/* 0488 */
    0x83, 0xbd, 0xbd, 0x83, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0490 */
    0xc3, 0xbd, 0xbf, 0xc3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0498 */
    0xc1, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xff, 	/* 04a0 */
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 04a8 */
    0xbd, 0xbd, 0xbd, 0xdb, 0xdb, 0xe7, 0xe7, 0xff, 	/* 04b0 */
    0xbd, 0xbd, 0xbd, 0xa5, 0xa5, 0x99, 0xbd, 0xff, 	/* 04b8 */
    0xbd, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xbd, 0xff, 	/* 04c0 */
    0xdd, 0xdd, 0xdd, 0xe3, 0xf7, 0xf7, 0xf7, 0xff, 	/* 04c8 */
    0x81, 0xfd, 0xfb, 0xe7, 0xdf, 0xbf, 0x81, 0xff, 	/* 04d0 */
    0xc3, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xc3, 0xff, 	/* 04d8 */
    0xff, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xff, 	/* 04e0 */
    0xc3, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xc3, 0xff, 	/* 04e8 */
    0xff, 0xf7, 0xe3, 0xd5, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 04f0 */
    0xff, 0xff, 0xef, 0xdf, 0x80, 0xdf, 0xef, 0xff, 	/* 04f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0500 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xff, 0xff, 0xf7, 0xff, 	/* 0508 */
    0xdb, 0xdb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0510 */
    0xdb, 0xdb, 0x81, 0xdb, 0x81, 0xdb, 0xdb, 0xff, 	/* 0518 */
    0xf7, 0xe1, 0xd7, 0xe3, 0xf5, 0xc3, 0xf7, 0xff, 	/* 0520 */
    0xff, 0x9d, 0x9b, 0xf7, 0xef, 0xd9, 0xb9, 0xff, 	/* 0528 */
    0xcf, 0xb7, 0xb7, 0xcf, 0xb5, 0xbb, 0xc5, 0xff, 	/* 0530 */
    0xfb, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0538 */
    0xfb, 0xf7, 0xef, 0xef, 0xef, 0xf7, 0xfb, 0xff, 	/* 0540 */
    0xdf, 0xef, 0xf7, 0xf7, 0xf7, 0xef, 0xdf, 0xff, 	/* 0548 */
    0xf7, 0xd5, 0xe3, 0xc1, 0xe3, 0xd5, 0xf7, 0xff, 	/* 0550 */
    0xff, 0xf7, 0xf7, 0xc1, 0xf7, 0xf7, 0xff, 0xff, 	/* 0558 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0560 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 	/* 0568 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff, 	/* 0570 */
    0xff, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0xff, 	/* 0578 */
    0xc3, 0xbd, 0xb9, 0xa5, 0x9d, 0xbd, 0xc3, 0xff, 	/* 0580 */
    0xf7, 0xe7, 0xd7, 0xf7, 0xf7, 0xf7, 0xc1, 0xff, 	/* 0588 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xcf, 0xbf, 0x81, 0xff, 	/* 0590 */
    0xc3, 0xbd, 0xfd, 0xe3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0598 */
    0xfb, 0xf3, 0xeb, 0xdb, 0x81, 0xfb, 0xfb, 0xff, 	/* 05a0 */
    0x81, 0xbf, 0x87, 0xfb, 0xfd, 0xbb, 0xc7, 0xff, 	/* 05a8 */
    0xe3, 0xdf, 0xbf, 0x83, 0xbd, 0xbd, 0xc3, 0xff, 	/* 05b0 */
    0x81, 0xbd, 0xfb, 0xf7, 0xef, 0xef, 0xef, 0xff, 	/* 05b8 */
    0xc3, 0xbd, 0xbd, 0xc3, 0xbd, 0xbd, 0xc3, 0xff, 	/* 05c0 */
    0xc3, 0xbd, 0xbd, 0xc1, 0xfd, 0xfb, 0xc7, 0xff, 	/* 05c8 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xff, 0xff, 	/* 05d0 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 05d8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff, 	/* 05e0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff, 	/* 05e8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff, 	/* 05f0 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xef, 0xff, 0xef, 0xff, 	/* 05f8 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 	/* 0600 */
    0xf7, 0xe3, 0xc1, 0x80, 0x80, 0xe3, 0xc1, 0xff, 	/* 0608 */
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 	/* 0610 */
    0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0618 */
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0620 */
    0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0628 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 	/* 0630 */
    0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 	/* 0638 */
    0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 	/* 0640 */
    0xff, 0xff, 0xff, 0xff, 0x1f, 0xef, 0xf7, 0xf7, 	/* 0648 */
    0xf7, 0xf7, 0xf7, 0xfb, 0xfc, 0xff, 0xff, 0xff, 	/* 0650 */
    0xf7, 0xf7, 0xf7, 0xef, 0x1f, 0xff, 0xff, 0xff, 	/* 0658 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x00, 	/* 0660 */
    0x7f, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xfe, 	/* 0668 */
    0xfe, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7f, 	/* 0670 */
    0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0678 */
    0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0680 */
    0xff, 0xc3, 0x81, 0x81, 0x81, 0x81, 0xc3, 0xff, 	/* 0688 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 	/* 0690 */
    0xc9, 0x80, 0x80, 0x80, 0xc1, 0xe3, 0xf7, 0xff, 	/* 0698 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 	/* 06a0 */
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xfb, 0xf7, 0xf7, 	/* 06a8 */
    0x7e, 0xbd, 0xdb, 0xe7, 0xe7, 0xdb, 0xbd, 0x7e, 	/* 06b0 */
    0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 06b8 */
    0xf7, 0xe3, 0xd5, 0x88, 0xd5, 0xf7, 0xf7, 0xff, 	/* 06c0 */
    0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 	/* 06c8 */
    0xf7, 0xe3, 0xc1, 0x80, 0xc1, 0xe3, 0xf7, 0xff, 	/* 06d0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf7, 	/* 06d8 */
    0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 	/* 06e0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 06e8 */
    0xff, 0xff, 0xfe, 0xc1, 0xab, 0xeb, 0xeb, 0xff, 	/* 06f0 */
    0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 	/* 06f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0700 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0708 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0710 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0718 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 	/* 0720 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0728 */
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 	/* 0730 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0738 */
    0xff, 0xff, 0xff, 0xff, 0x55, 0xaa, 0x55, 0xaa, 	/* 0740 */
    0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 	/* 0748 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 	/* 0750 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0758 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0760 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xff, 0xff, 0xff, 	/* 0768 */
    0xff, 0xff, 0xff, 0xff, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0770 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 	/* 0778 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0780 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xff, 0xff, 0xff, 	/* 0788 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0790 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0798 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 	/* 07a0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 	/* 07a8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 	/* 07b0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 07b8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 07c0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 	/* 07c8 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 	/* 07d0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 07d8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 	/* 07e0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xff, 0xff, 0xff, 	/* 07e8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 	/* 07f0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 07f8 */
    0x1c, 0x22, 0x4a, 0x56, 0x4c, 0x20, 0x1e, 0x00, 	/* 0800 */
    0x00, 0x00, 0x38, 0x04, 0x3c, 0x44, 0x3a, 0x00, 	/* 0808 */
    0x40, 0x40, 0x5c, 0x62, 0x42, 0x62, 0x5c, 0x00, 	/* 0810 */
    0x00, 0x00, 0x3c, 0x42, 0x40, 0x42, 0x3c, 0x00, 	/* 0818 */
    0x02, 0x02, 0x3a, 0x46, 0x42, 0x46, 0x3a, 0x00, 	/* 0820 */
    0x00, 0x00, 0x3c, 0x42, 0x7e, 0x40, 0x3c, 0x00, 	/* 0828 */
    0x0c, 0x12, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x00, 	/* 0830 */
    0x00, 0x00, 0x3a, 0x46, 0x46, 0x3a, 0x02, 0x3c, 	/* 0838 */
    0x40, 0x40, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x00, 	/* 0840 */
    0x08, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0848 */
    0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x44, 0x38, 	/* 0850 */
    0x40, 0x40, 0x44, 0x48, 0x50, 0x68, 0x44, 0x00, 	/* 0858 */
    0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0860 */
    0x00, 0x00, 0x76, 0x49, 0x49, 0x49, 0x49, 0x00, 	/* 0868 */
    0x00, 0x00, 0x5c, 0x62, 0x42, 0x42, 0x42, 0x00, 	/* 0870 */
    0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 0878 */
    0x00, 0x00, 0x5c, 0x62, 0x62, 0x5c, 0x40, 0x40, 	/* 0880 */
    0x00, 0x00, 0x3a, 0x46, 0x46, 0x3a, 0x02, 0x02, 	/* 0888 */
    0x00, 0x00, 0x5c, 0x62, 0x40, 0x40, 0x40, 0x00, 	/* 0890 */
    0x00, 0x00, 0x3e, 0x40, 0x3c, 0x02, 0x7c, 0x00, 	/* 0898 */
    0x10, 0x10, 0x7c, 0x10, 0x10, 0x12, 0x0c, 0x00, 	/* 08a0 */
    0x00, 0x00, 0x42, 0x42, 0x42, 0x46, 0x3a, 0x00, 	/* 08a8 */
    0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 08b0 */
    0x00, 0x00, 0x41, 0x49, 0x49, 0x49, 0x36, 0x00, 	/* 08b8 */
    0x00, 0x00, 0x42, 0x24, 0x18, 0x24, 0x42, 0x00, 	/* 08c0 */
    0x00, 0x00, 0x42, 0x42, 0x46, 0x3a, 0x02, 0x3c, 	/* 08c8 */
    0x00, 0x00, 0x7e, 0x04, 0x18, 0x20, 0x7e, 0x00, 	/* 08d0 */
    0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x00, 	/* 08d8 */
    0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 	/* 08e0 */
    0x3c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3c, 0x00, 	/* 08e8 */
    0x00, 0x08, 0x1c, 0x2a, 0x08, 0x08, 0x08, 0x08, 	/* 08f0 */
    0x00, 0x00, 0x10, 0x20, 0x7f, 0x20, 0x10, 0x00, 	/* 08f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0900 */
    0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 	/* 0908 */
    0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0910 */
    0x24, 0x24, 0x7e, 0x24, 0x7e, 0x24, 0x24, 0x00, 	/* 0918 */
    0x08, 0x1e, 0x28, 0x1c, 0x0a, 0x3c, 0x08, 0x00, 	/* 0920 */
    0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00, 	/* 0928 */
    0x30, 0x48, 0x48, 0x30, 0x4a, 0x44, 0x3a, 0x00, 	/* 0930 */
    0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0938 */
    0x04, 0x08, 0x10, 0x10, 0x10, 0x08, 0x04, 0x00, 	/* 0940 */
    0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 	/* 0948 */
    0x08, 0x2a, 0x1c, 0x3e, 0x1c, 0x2a, 0x08, 0x00, 	/* 0950 */
    0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00, 	/* 0958 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 0960 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 	/* 0968 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 	/* 0970 */
    0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 	/* 0978 */
    0x3c, 0x42, 0x46, 0x5a, 0x62, 0x42, 0x3c, 0x00, 	/* 0980 */
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x3e, 0x00, 	/* 0988 */
    0x3c, 0x42, 0x02, 0x0c, 0x30, 0x40, 0x7e, 0x00, 	/* 0990 */
    0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 	/* 0998 */
    0x04, 0x0c, 0x14, 0x24, 0x7e, 0x04, 0x04, 0x00, 	/* 09a0 */
    0x7e, 0x40, 0x78, 0x04, 0x02, 0x44, 0x38, 0x00, 	/* 09a8 */
    0x1c, 0x20, 0x40, 0x7c, 0x42, 0x42, 0x3c, 0x00, 	/* 09b0 */
    0x7e, 0x42, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00, 	/* 09b8 */
    0x3c, 0x42, 0x42, 0x3c, 0x42, 0x42, 0x3c, 0x00, 	/* 09c0 */
    0x3c, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x38, 0x00, 	/* 09c8 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 	/* 09d0 */
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08, 0x10, 	/* 09d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00, 	/* 09e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00, 	/* 09e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00, 	/* 09f0 */
    0x3c, 0x42, 0x02, 0x0c, 0x10, 0x00, 0x10, 0x00, 	/* 09f8 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 	/* 0a00 */
    0x18, 0x24, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0a08 */
    0x7c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x7c, 0x00, 	/* 0a10 */
    0x1c, 0x22, 0x40, 0x40, 0x40, 0x22, 0x1c, 0x00, 	/* 0a18 */
    0x78, 0x24, 0x22, 0x22, 0x22, 0x24, 0x78, 0x00, 	/* 0a20 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7e, 0x00, 	/* 0a28 */
    0x7e, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 	/* 0a30 */
    0x1c, 0x22, 0x40, 0x4e, 0x42, 0x22, 0x1c, 0x00, 	/* 0a38 */
    0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 	/* 0a40 */
    0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c, 0x00, 	/* 0a48 */
    0x0e, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 	/* 0a50 */
    0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 	/* 0a58 */
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 	/* 0a60 */
    0x42, 0x66, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x00, 	/* 0a68 */
    0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x00, 	/* 0a70 */
    0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 	/* 0a78 */
    0x7c, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00, 	/* 0a80 */
    0x18, 0x24, 0x42, 0x42, 0x4a, 0x24, 0x1a, 0x00, 	/* 0a88 */
    0x7c, 0x42, 0x42, 0x7c, 0x48, 0x44, 0x42, 0x00, 	/* 0a90 */
    0x3c, 0x42, 0x40, 0x3c, 0x02, 0x42, 0x3c, 0x00, 	/* 0a98 */
    0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 	/* 0aa0 */
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 	/* 0aa8 */
    0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x00, 	/* 0ab0 */
    0x42, 0x42, 0x42, 0x5a, 0x5a, 0x66, 0x42, 0x00, 	/* 0ab8 */
    0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 	/* 0ac0 */
    0x22, 0x22, 0x22, 0x1c, 0x08, 0x08, 0x08, 0x00, 	/* 0ac8 */
    0x7e, 0x02, 0x04, 0x18, 0x20, 0x40, 0x7e, 0x00, 	/* 0ad0 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, 	/* 0ad8 */
    0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 0xa0, 0x50, 	/* 0ae0 */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 	/* 0ae8 */
    0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 	/* 0af0 */
    0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 0x33, 0x99, 	/* 0af8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0b00 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0b08 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 	/* 0b10 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0b18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 	/* 0b20 */
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 	/* 0b28 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 	/* 0b30 */
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 	/* 0b38 */
    0x00, 0x00, 0x00, 0x00, 0xaa, 0x55, 0xaa, 0x55, 	/* 0b40 */
    0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc, 	/* 0b48 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 	/* 0b50 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08, 	/* 0b58 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0b60 */
    0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00, 	/* 0b68 */
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08, 	/* 0b70 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 	/* 0b78 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 	/* 0b80 */
    0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00, 	/* 0b88 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08, 	/* 0b90 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08, 	/* 0b98 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 	/* 0ba0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 	/* 0ba8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 	/* 0bb0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0bb8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 	/* 0bc0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 	/* 0bc8 */
    0x01, 0x02, 0x44, 0x48, 0x50, 0x60, 0x40, 0x00, 	/* 0bd0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0bd8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 	/* 0be0 */
    0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00, 	/* 0be8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 	/* 0bf0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0bf8 */
    0xe3, 0xdd, 0xb5, 0xa9, 0xb3, 0xdf, 0xe1, 0xff, 	/* 0c00 */
    0xff, 0xff, 0xc7, 0xfb, 0xc3, 0xbb, 0xc5, 0xff, 	/* 0c08 */
    0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0x9d, 0xa3, 0xff, 	/* 0c10 */
    0xff, 0xff, 0xc3, 0xbd, 0xbf, 0xbd, 0xc3, 0xff, 	/* 0c18 */
    0xfd, 0xfd, 0xc5, 0xb9, 0xbd, 0xb9, 0xc5, 0xff, 	/* 0c20 */
    0xff, 0xff, 0xc3, 0xbd, 0x81, 0xbf, 0xc3, 0xff, 	/* 0c28 */
    0xf3, 0xed, 0xef, 0x83, 0xef, 0xef, 0xef, 0xff, 	/* 0c30 */
    0xff, 0xff, 0xc5, 0xb9, 0xb9, 0xc5, 0xfd, 0xc3, 	/* 0c38 */
    0xbf, 0xbf, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0c40 */
    0xf7, 0xff, 0xe7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0c48 */
    0xfb, 0xff, 0xf3, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 	/* 0c50 */
    0xbf, 0xbf, 0xbb, 0xb7, 0xaf, 0x97, 0xbb, 0xff, 	/* 0c58 */
    0xe7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0c60 */
    0xff, 0xff, 0x89, 0xb6, 0xb6, 0xb6, 0xb6, 0xff, 	/* 0c68 */
    0xff, 0xff, 0xa3, 0x9d, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0c70 */
    0xff, 0xff, 0xc3, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0c78 */
    0xff, 0xff, 0xa3, 0x9d, 0x9d, 0xa3, 0xbf, 0xbf, 	/* 0c80 */
    0xff, 0xff, 0xc5, 0xb9, 0xb9, 0xc5, 0xfd, 0xfd, 	/* 0c88 */
    0xff, 0xff, 0xa3, 0x9d, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0c90 */
    0xff, 0xff, 0xc1, 0xbf, 0xc3, 0xfd, 0x83, 0xff, 	/* 0c98 */
    0xef, 0xef, 0x83, 0xef, 0xef, 0xed, 0xf3, 0xff, 	/* 0ca0 */
    0xff, 0xff, 0xbd, 0xbd, 0xbd, 0xb9, 0xc5, 0xff, 	/* 0ca8 */
    0xff, 0xff, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0cb0 */
    0xff, 0xff, 0xbe, 0xb6, 0xb6, 0xb6, 0xc9, 0xff, 	/* 0cb8 */
    0xff, 0xff, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xff, 	/* 0cc0 */
    0xff, 0xff, 0xbd, 0xbd, 0xb9, 0xc5, 0xfd, 0xc3, 	/* 0cc8 */
    0xff, 0xff, 0x81, 0xfb, 0xe7, 0xdf, 0x81, 0xff, 	/* 0cd0 */
    0xc3, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xc3, 0xff, 	/* 0cd8 */
    0xff, 0xbf, 0xdf, 0xef, 0xf7, 0xfb, 0xfd, 0xff, 	/* 0ce0 */
    0xc3, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xc3, 0xff, 	/* 0ce8 */
    0xff, 0xf7, 0xe3, 0xd5, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 0cf0 */
    0xff, 0xff, 0xef, 0xdf, 0x80, 0xdf, 0xef, 0xff, 	/* 0cf8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d00 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xff, 0xff, 0xf7, 0xff, 	/* 0d08 */
    0xdb, 0xdb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d10 */
    0xdb, 0xdb, 0x81, 0xdb, 0x81, 0xdb, 0xdb, 0xff, 	/* 0d18 */
    0xf7, 0xe1, 0xd7, 0xe3, 0xf5, 0xc3, 0xf7, 0xff, 	/* 0d20 */
    0xff, 0x9d, 0x9b, 0xf7, 0xef, 0xd9, 0xb9, 0xff, 	/* 0d28 */
    0xcf, 0xb7, 0xb7, 0xcf, 0xb5, 0xbb, 0xc5, 0xff, 	/* 0d30 */
    0xfb, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0d38 */
    0xfb, 0xf7, 0xef, 0xef, 0xef, 0xf7, 0xfb, 0xff, 	/* 0d40 */
    0xdf, 0xef, 0xf7, 0xf7, 0xf7, 0xef, 0xdf, 0xff, 	/* 0d48 */
    0xf7, 0xd5, 0xe3, 0xc1, 0xe3, 0xd5, 0xf7, 0xff, 	/* 0d50 */
    0xff, 0xf7, 0xf7, 0xc1, 0xf7, 0xf7, 0xff, 0xff, 	/* 0d58 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0d60 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 	/* 0d68 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff, 	/* 0d70 */
    0xff, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0xff, 	/* 0d78 */
    0xc3, 0xbd, 0xb9, 0xa5, 0x9d, 0xbd, 0xc3, 0xff, 	/* 0d80 */
    0xf7, 0xe7, 0xd7, 0xf7, 0xf7, 0xf7, 0xc1, 0xff, 	/* 0d88 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xcf, 0xbf, 0x81, 0xff, 	/* 0d90 */
    0xc3, 0xbd, 0xfd, 0xe3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0d98 */
    0xfb, 0xf3, 0xeb, 0xdb, 0x81, 0xfb, 0xfb, 0xff, 	/* 0da0 */
    0x81, 0xbf, 0x87, 0xfb, 0xfd, 0xbb, 0xc7, 0xff, 	/* 0da8 */
    0xe3, 0xdf, 0xbf, 0x83, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0db0 */
    0x81, 0xbd, 0xfb, 0xf7, 0xef, 0xef, 0xef, 0xff, 	/* 0db8 */
    0xc3, 0xbd, 0xbd, 0xc3, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0dc0 */
    0xc3, 0xbd, 0xbd, 0xc1, 0xfd, 0xfb, 0xc7, 0xff, 	/* 0dc8 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xff, 0xff, 	/* 0dd0 */
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xf7, 0xf7, 0xef, 	/* 0dd8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff, 	/* 0de0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff, 	/* 0de8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff, 	/* 0df0 */
    0xc3, 0xbd, 0xfd, 0xf3, 0xef, 0xff, 0xef, 0xff, 	/* 0df8 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 	/* 0e00 */
    0xe7, 0xdb, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e08 */
    0x83, 0xdd, 0xdd, 0xc3, 0xdd, 0xdd, 0x83, 0xff, 	/* 0e10 */
    0xe3, 0xdd, 0xbf, 0xbf, 0xbf, 0xdd, 0xe3, 0xff, 	/* 0e18 */
    0x87, 0xdb, 0xdd, 0xdd, 0xdd, 0xdb, 0x87, 0xff, 	/* 0e20 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0x81, 0xff, 	/* 0e28 */
    0x81, 0xbf, 0xbf, 0x87, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0e30 */
    0xe3, 0xdd, 0xbf, 0xb1, 0xbd, 0xdd, 0xe3, 0xff, 	/* 0e38 */
    0xbd, 0xbd, 0xbd, 0x81, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e40 */
    0xe3, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xe3, 0xff, 	/* 0e48 */
    0xf1, 0xfb, 0xfb, 0xfb, 0xfb, 0xbb, 0xc7, 0xff, 	/* 0e50 */
    0xbd, 0xbb, 0xb7, 0x8f, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0e58 */
    0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0x81, 0xff, 	/* 0e60 */
    0xbd, 0x99, 0xa5, 0xa5, 0xbd, 0xbd, 0xbd, 0xff, 	/* 0e68 */
    0xbd, 0x9d, 0xad, 0xb5, 0xb9, 0xbd, 0xbd, 0xff, 	/* 0e70 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xbd, 0xdb, 0xe7, 0xff, 	/* 0e78 */
    0x83, 0xbd, 0xbd, 0x83, 0xbf, 0xbf, 0xbf, 0xff, 	/* 0e80 */
    0xe7, 0xdb, 0xbd, 0xbd, 0xb5, 0xdb, 0xe5, 0xff, 	/* 0e88 */
    0x83, 0xbd, 0xbd, 0x83, 0xb7, 0xbb, 0xbd, 0xff, 	/* 0e90 */
    0xc3, 0xbd, 0xbf, 0xc3, 0xfd, 0xbd, 0xc3, 0xff, 	/* 0e98 */
    0xc1, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xff, 	/* 0ea0 */
    0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xc3, 0xff, 	/* 0ea8 */
    0xbd, 0xbd, 0xbd, 0xdb, 0xdb, 0xe7, 0xe7, 0xff, 	/* 0eb0 */
    0xbd, 0xbd, 0xbd, 0xa5, 0xa5, 0x99, 0xbd, 0xff, 	/* 0eb8 */
    0xbd, 0xbd, 0xdb, 0xe7, 0xdb, 0xbd, 0xbd, 0xff, 	/* 0ec0 */
    0xdd, 0xdd, 0xdd, 0xe3, 0xf7, 0xf7, 0xf7, 0xff, 	/* 0ec8 */
    0x81, 0xfd, 0xfb, 0xe7, 0xdf, 0xbf, 0x81, 0xff, 	/* 0ed0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0ed8 */
    0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 0x5f, 0xaf, 	/* 0ee0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 	/* 0ee8 */
    0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 	/* 0ef0 */
    0x33, 0x99, 0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 	/* 0ef8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0f00 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0f08 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 	/* 0f10 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0f18 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 	/* 0f20 */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 	/* 0f28 */
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 	/* 0f30 */
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 	/* 0f38 */
    0xff, 0xff, 0xff, 0xff, 0x55, 0xaa, 0x55, 0xaa, 	/* 0f40 */
    0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 	/* 0f48 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 	/* 0f50 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0f58 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0, 	/* 0f60 */
    0xf7, 0xf7, 0xf7, 0xf7, 0xf0, 0xff, 0xff, 0xff, 	/* 0f68 */
    0xff, 0xff, 0xff, 0xff, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0f70 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 	/* 0f78 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf7, 0xf7, 0xf7, 	/* 0f80 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x00, 0xff, 0xff, 0xff, 	/* 0f88 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0xf7, 0xf7, 0xf7, 	/* 0f90 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xf7, 0xf7, 0xf7, 	/* 0f98 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 	/* 0fa0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 	/* 0fa8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 	/* 0fb0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0fb8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 	/* 0fc0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 	/* 0fc8 */
    0xfe, 0xfd, 0xbb, 0xb7, 0xaf, 0x9f, 0xbf, 0xff, 	/* 0fd0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 	/* 0fd8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 	/* 0fe0 */
    0xf7, 0xf7, 0xf7, 0xf7, 0x07, 0xff, 0xff, 0xff, 	/* 0fe8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 	/* 0ff0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0 	/* 0ff8 */
};

#else 

/* C64 character ROM. */
BYTE chargen_rom[] = {
    0x3c, 0x66, 0x6e, 0x6e, 0x60, 0x62, 0x3c, 0x00,	/* 0000 */
    0x18, 0x3c, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00,	/* 0008 */
    0x7c, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x7c, 0x00,	/* 0010 */
    0x3c, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3c, 0x00,	/* 0018 */
    0x78, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0x78, 0x00,	/* 0020 */
    0x7e, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7e, 0x00,	/* 0028 */
    0x7e, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00,	/* 0030 */
    0x3c, 0x66, 0x60, 0x6e, 0x66, 0x66, 0x3c, 0x00,	/* 0038 */
    0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00,	/* 0040 */
    0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00,	/* 0048 */
    0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00,	/* 0050 */
    0x66, 0x6c, 0x78, 0x70, 0x78, 0x6c, 0x66, 0x00,	/* 0058 */
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7e, 0x00,	/* 0060 */
    0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x00,	/* 0068 */
    0x66, 0x76, 0x7e, 0x7e, 0x6e, 0x66, 0x66, 0x00,	/* 0070 */
    0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,	/* 0078 */
    0x7c, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x00,	/* 0080 */
    0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x0e, 0x00,	/* 0088 */
    0x7c, 0x66, 0x66, 0x7c, 0x78, 0x6c, 0x66, 0x00,	/* 0090 */
    0x3c, 0x66, 0x60, 0x3c, 0x06, 0x66, 0x3c, 0x00,	/* 0098 */
    0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 00a0 */
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,	/* 00a8 */
    0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00,	/* 00b0 */
    0x63, 0x63, 0x63, 0x6b, 0x7f, 0x77, 0x63, 0x00,	/* 00b8 */
    0x66, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x66, 0x00,	/* 00c0 */
    0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x00,	/* 00c8 */
    0x7e, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x7e, 0x00,	/* 00d0 */
    0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00,	/* 00d8 */
    0x0c, 0x12, 0x30, 0x7c, 0x30, 0x62, 0xfc, 0x00,	/* 00e0 */
    0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00,	/* 00e8 */
    0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18,	/* 00f0 */
    0x00, 0x10, 0x30, 0x7f, 0x7f, 0x30, 0x10, 0x00,	/* 00f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0100 */
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00,	/* 0108 */
    0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0110 */
    0x66, 0x66, 0xff, 0x66, 0xff, 0x66, 0x66, 0x00,	/* 0118 */
    0x18, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x18, 0x00,	/* 0120 */
    0x62, 0x66, 0x0c, 0x18, 0x30, 0x66, 0x46, 0x00,	/* 0128 */
    0x3c, 0x66, 0x3c, 0x38, 0x67, 0x66, 0x3f, 0x00,	/* 0130 */
    0x06, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0138 */
    0x0c, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00,	/* 0140 */
    0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00,	/* 0148 */
    0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00,	/* 0150 */
    0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00,	/* 0158 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30,	/* 0160 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,	/* 0168 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,	/* 0170 */
    0x00, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00,	/* 0178 */
    0x3c, 0x66, 0x6e, 0x76, 0x66, 0x66, 0x3c, 0x00,	/* 0180 */
    0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7e, 0x00,	/* 0188 */
    0x3c, 0x66, 0x06, 0x0c, 0x30, 0x60, 0x7e, 0x00,	/* 0190 */
    0x3c, 0x66, 0x06, 0x1c, 0x06, 0x66, 0x3c, 0x00,	/* 0198 */
    0x06, 0x0e, 0x1e, 0x66, 0x7f, 0x06, 0x06, 0x00,	/* 01a0 */
    0x7e, 0x60, 0x7c, 0x06, 0x06, 0x66, 0x3c, 0x00,	/* 01a8 */
    0x3c, 0x66, 0x60, 0x7c, 0x66, 0x66, 0x3c, 0x00,	/* 01b0 */
    0x7e, 0x66, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 01b8 */
    0x3c, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x3c, 0x00,	/* 01c0 */
    0x3c, 0x66, 0x66, 0x3e, 0x06, 0x66, 0x3c, 0x00,	/* 01c8 */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00,	/* 01d0 */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30,	/* 01d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00,	/* 01e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00,	/* 01e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00,	/* 01f0 */
    0x3c, 0x66, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x00,	/* 01f8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0200 */
    0x08, 0x1c, 0x3e, 0x7f, 0x7f, 0x1c, 0x3e, 0x00,	/* 0208 */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* 0210 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0218 */
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,	/* 0220 */
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0228 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,	/* 0230 */
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,	/* 0238 */
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,	/* 0240 */
    0x00, 0x00, 0x00, 0xe0, 0xf0, 0x38, 0x18, 0x18,	/* 0248 */
    0x18, 0x18, 0x1c, 0x0f, 0x07, 0x00, 0x00, 0x00,	/* 0250 */
    0x18, 0x18, 0x38, 0xf0, 0xe0, 0x00, 0x00, 0x00,	/* 0258 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff,	/* 0260 */
    0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x0e, 0x07, 0x03,	/* 0268 */
    0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70, 0xe0, 0xc0,	/* 0270 */
    0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,	/* 0278 */
    0xff, 0xff, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,	/* 0280 */
    0x00, 0x3c, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c, 0x00,	/* 0288 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,	/* 0290 */
    0x36, 0x7f, 0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00,	/* 0298 */
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,	/* 02a0 */
    0x00, 0x00, 0x00, 0x07, 0x0f, 0x1c, 0x18, 0x18,	/* 02a8 */
    0xc3, 0xe7, 0x7e, 0x3c, 0x3c, 0x7e, 0xe7, 0xc3,	/* 02b0 */
    0x00, 0x3c, 0x7e, 0x66, 0x66, 0x7e, 0x3c, 0x00,	/* 02b8 */
    0x18, 0x18, 0x66, 0x66, 0x18, 0x18, 0x3c, 0x00,	/* 02c0 */
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,	/* 02c8 */
    0x08, 0x1c, 0x3e, 0x7f, 0x3e, 0x1c, 0x08, 0x00,	/* 02d0 */
    0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18,	/* 02d8 */
    0xc0, 0xc0, 0x30, 0x30, 0xc0, 0xc0, 0x30, 0x30,	/* 02e0 */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* 02e8 */
    0x00, 0x00, 0x03, 0x3e, 0x76, 0x36, 0x36, 0x00,	/* 02f0 */
    0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01,	/* 02f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0300 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,	/* 0308 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,	/* 0310 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0318 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* 0320 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,	/* 0328 */
    0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33,	/* 0330 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,	/* 0338 */
    0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0x33, 0x33,	/* 0340 */
    0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80,	/* 0348 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,	/* 0350 */
    0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18,	/* 0358 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0360 */
    0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00,	/* 0368 */
    0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18,	/* 0370 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,	/* 0378 */
    0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18,	/* 0380 */
    0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0388 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18,	/* 0390 */
    0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18,	/* 0398 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,	/* 03a0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,	/* 03a8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,	/* 03b0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 03b8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 03c0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 03c8 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xff, 0xff,	/* 03d0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,	/* 03d8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,	/* 03e0 */
    0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00,	/* 03e8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,	/* 03f0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f,	/* 03f8 */
    0xc3, 0x99, 0x91, 0x91, 0x9f, 0x99, 0xc3, 0xff,	/* 0400 */
    0xe7, 0xc3, 0x99, 0x81, 0x99, 0x99, 0x99, 0xff,	/* 0408 */
    0x83, 0x99, 0x99, 0x83, 0x99, 0x99, 0x83, 0xff,	/* 0410 */
    0xc3, 0x99, 0x9f, 0x9f, 0x9f, 0x99, 0xc3, 0xff,	/* 0418 */
    0x87, 0x93, 0x99, 0x99, 0x99, 0x93, 0x87, 0xff,	/* 0420 */
    0x81, 0x9f, 0x9f, 0x87, 0x9f, 0x9f, 0x81, 0xff,	/* 0428 */
    0x81, 0x9f, 0x9f, 0x87, 0x9f, 0x9f, 0x9f, 0xff,	/* 0430 */
    0xc3, 0x99, 0x9f, 0x91, 0x99, 0x99, 0xc3, 0xff,	/* 0438 */
    0x99, 0x99, 0x99, 0x81, 0x99, 0x99, 0x99, 0xff,	/* 0440 */
    0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xff,	/* 0448 */
    0xe1, 0xf3, 0xf3, 0xf3, 0xf3, 0x93, 0xc7, 0xff,	/* 0450 */
    0x99, 0x93, 0x87, 0x8f, 0x87, 0x93, 0x99, 0xff,	/* 0458 */
    0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x81, 0xff,	/* 0460 */
    0x9c, 0x88, 0x80, 0x94, 0x9c, 0x9c, 0x9c, 0xff,	/* 0468 */
    0x99, 0x89, 0x81, 0x81, 0x91, 0x99, 0x99, 0xff,	/* 0470 */
    0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xff,	/* 0478 */
    0x83, 0x99, 0x99, 0x83, 0x9f, 0x9f, 0x9f, 0xff,	/* 0480 */
    0xc3, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xf1, 0xff,	/* 0488 */
    0x83, 0x99, 0x99, 0x83, 0x87, 0x93, 0x99, 0xff,	/* 0490 */
    0xc3, 0x99, 0x9f, 0xc3, 0xf9, 0x99, 0xc3, 0xff,	/* 0498 */
    0x81, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xff,	/* 04a0 */
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xff,	/* 04a8 */
    0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xe7, 0xff,	/* 04b0 */
    0x9c, 0x9c, 0x9c, 0x94, 0x80, 0x88, 0x9c, 0xff,	/* 04b8 */
    0x99, 0x99, 0xc3, 0xe7, 0xc3, 0x99, 0x99, 0xff,	/* 04c0 */
    0x99, 0x99, 0x99, 0xc3, 0xe7, 0xe7, 0xe7, 0xff,	/* 04c8 */
    0x81, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0x81, 0xff,	/* 04d0 */
    0xc3, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xc3, 0xff,	/* 04d8 */
    0xf3, 0xed, 0xcf, 0x83, 0xcf, 0x9d, 0x03, 0xff,	/* 04e0 */
    0xc3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xc3, 0xff,	/* 04e8 */
    0xff, 0xe7, 0xc3, 0x81, 0xe7, 0xe7, 0xe7, 0xe7,	/* 04f0 */
    0xff, 0xef, 0xcf, 0x80, 0x80, 0xcf, 0xef, 0xff,	/* 04f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0500 */
    0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0xff, 0xe7, 0xff,	/* 0508 */
    0x99, 0x99, 0x99, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0510 */
    0x99, 0x99, 0x00, 0x99, 0x00, 0x99, 0x99, 0xff,	/* 0518 */
    0xe7, 0xc1, 0x9f, 0xc3, 0xf9, 0x83, 0xe7, 0xff,	/* 0520 */
    0x9d, 0x99, 0xf3, 0xe7, 0xcf, 0x99, 0xb9, 0xff,	/* 0528 */
    0xc3, 0x99, 0xc3, 0xc7, 0x98, 0x99, 0xc0, 0xff,	/* 0530 */
    0xf9, 0xf3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0538 */
    0xf3, 0xe7, 0xcf, 0xcf, 0xcf, 0xe7, 0xf3, 0xff,	/* 0540 */
    0xcf, 0xe7, 0xf3, 0xf3, 0xf3, 0xe7, 0xcf, 0xff,	/* 0548 */
    0xff, 0x99, 0xc3, 0x00, 0xc3, 0x99, 0xff, 0xff,	/* 0550 */
    0xff, 0xe7, 0xe7, 0x81, 0xe7, 0xe7, 0xff, 0xff,	/* 0558 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xcf,	/* 0560 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff,	/* 0568 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff,	/* 0570 */
    0xff, 0xfc, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0xff,	/* 0578 */
    0xc3, 0x99, 0x91, 0x89, 0x99, 0x99, 0xc3, 0xff,	/* 0580 */
    0xe7, 0xe7, 0xc7, 0xe7, 0xe7, 0xe7, 0x81, 0xff,	/* 0588 */
    0xc3, 0x99, 0xf9, 0xf3, 0xcf, 0x9f, 0x81, 0xff,	/* 0590 */
    0xc3, 0x99, 0xf9, 0xe3, 0xf9, 0x99, 0xc3, 0xff,	/* 0598 */
    0xf9, 0xf1, 0xe1, 0x99, 0x80, 0xf9, 0xf9, 0xff,	/* 05a0 */
    0x81, 0x9f, 0x83, 0xf9, 0xf9, 0x99, 0xc3, 0xff,	/* 05a8 */
    0xc3, 0x99, 0x9f, 0x83, 0x99, 0x99, 0xc3, 0xff,	/* 05b0 */
    0x81, 0x99, 0xf3, 0xe7, 0xe7, 0xe7, 0xe7, 0xff,	/* 05b8 */
    0xc3, 0x99, 0x99, 0xc3, 0x99, 0x99, 0xc3, 0xff,	/* 05c0 */
    0xc3, 0x99, 0x99, 0xc1, 0xf9, 0x99, 0xc3, 0xff,	/* 05c8 */
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xe7, 0xff, 0xff,	/* 05d0 */
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xe7, 0xe7, 0xcf,	/* 05d8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff,	/* 05e0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff,	/* 05e8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff,	/* 05f0 */
    0xc3, 0x99, 0xf9, 0xf3, 0xe7, 0xff, 0xe7, 0xff,	/* 05f8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0600 */
    0xf7, 0xe3, 0xc1, 0x80, 0x80, 0xe3, 0xc1, 0xff,	/* 0608 */
    0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7,	/* 0610 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0618 */
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,	/* 0620 */
    0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0628 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff,	/* 0630 */
    0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf,	/* 0638 */
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,	/* 0640 */
    0xff, 0xff, 0xff, 0x1f, 0x0f, 0xc7, 0xe7, 0xe7,	/* 0648 */
    0xe7, 0xe7, 0xe3, 0xf0, 0xf8, 0xff, 0xff, 0xff,	/* 0650 */
    0xe7, 0xe7, 0xc7, 0x0f, 0x1f, 0xff, 0xff, 0xff,	/* 0658 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x00, 0x00,	/* 0660 */
    0x3f, 0x1f, 0x8f, 0xc7, 0xe3, 0xf1, 0xf8, 0xfc,	/* 0668 */
    0xfc, 0xf8, 0xf1, 0xe3, 0xc7, 0x8f, 0x1f, 0x3f,	/* 0670 */
    0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,	/* 0678 */
    0x00, 0x00, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,	/* 0680 */
    0xff, 0xc3, 0x81, 0x81, 0x81, 0x81, 0xc3, 0xff,	/* 0688 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,	/* 0690 */
    0xc9, 0x80, 0x80, 0x80, 0xc1, 0xe3, 0xf7, 0xff,	/* 0698 */
    0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f,	/* 06a0 */
    0xff, 0xff, 0xff, 0xf8, 0xf0, 0xe3, 0xe7, 0xe7,	/* 06a8 */
    0x3c, 0x18, 0x81, 0xc3, 0xc3, 0x81, 0x18, 0x3c,	/* 06b0 */
    0xff, 0xc3, 0x81, 0x99, 0x99, 0x81, 0xc3, 0xff,	/* 06b8 */
    0xe7, 0xe7, 0x99, 0x99, 0xe7, 0xe7, 0xc3, 0xff,	/* 06c0 */
    0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9,	/* 06c8 */
    0xf7, 0xe3, 0xc1, 0x80, 0xc1, 0xe3, 0xf7, 0xff,	/* 06d0 */
    0xe7, 0xe7, 0xe7, 0x00, 0x00, 0xe7, 0xe7, 0xe7,	/* 06d8 */
    0x3f, 0x3f, 0xcf, 0xcf, 0x3f, 0x3f, 0xcf, 0xcf,	/* 06e0 */
    0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7,	/* 06e8 */
    0xff, 0xff, 0xfc, 0xc1, 0x89, 0xc9, 0xc9, 0xff,	/* 06f0 */
    0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe,	/* 06f8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0700 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0708 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,	/* 0710 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0718 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,	/* 0720 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,	/* 0728 */
    0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,	/* 0730 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,	/* 0738 */
    0xff, 0xff, 0xff, 0xff, 0x33, 0x33, 0xcc, 0xcc,	/* 0740 */
    0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f,	/* 0748 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,	/* 0750 */
    0xe7, 0xe7, 0xe7, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7,	/* 0758 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0,	/* 0760 */
    0xe7, 0xe7, 0xe7, 0xe0, 0xe0, 0xff, 0xff, 0xff,	/* 0768 */
    0xff, 0xff, 0xff, 0x07, 0x07, 0xe7, 0xe7, 0xe7,	/* 0770 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,	/* 0778 */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7,	/* 0780 */
    0xe7, 0xe7, 0xe7, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0788 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0xe7, 0xe7, 0xe7,	/* 0790 */
    0xe7, 0xe7, 0xe7, 0x07, 0x07, 0xe7, 0xe7, 0xe7,	/* 0798 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,	/* 07a0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,	/* 07a8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,	/* 07b0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 07b8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 07c0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 07c8 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x00, 0x00,	/* 07d0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f,	/* 07d8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff,	/* 07e0 */
    0xe7, 0xe7, 0xe7, 0x07, 0x07, 0xff, 0xff, 0xff,	/* 07e8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff,	/* 07f0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0,	/* 07f8 */
    0x3c, 0x66, 0x6e, 0x6e, 0x60, 0x62, 0x3c, 0x00,	/* 0800 */
    0x00, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00,	/* 0808 */
    0x00, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x7c, 0x00,	/* 0810 */
    0x00, 0x00, 0x3c, 0x60, 0x60, 0x60, 0x3c, 0x00,	/* 0818 */
    0x00, 0x06, 0x06, 0x3e, 0x66, 0x66, 0x3e, 0x00,	/* 0820 */
    0x00, 0x00, 0x3c, 0x66, 0x7e, 0x60, 0x3c, 0x00,	/* 0828 */
    0x00, 0x0e, 0x18, 0x3e, 0x18, 0x18, 0x18, 0x00,	/* 0830 */
    0x00, 0x00, 0x3e, 0x66, 0x66, 0x3e, 0x06, 0x7c,	/* 0838 */
    0x00, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x00,	/* 0840 */
    0x00, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3c, 0x00,	/* 0848 */
    0x00, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x3c,	/* 0850 */
    0x00, 0x60, 0x60, 0x6c, 0x78, 0x6c, 0x66, 0x00,	/* 0858 */
    0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00,	/* 0860 */
    0x00, 0x00, 0x66, 0x7f, 0x7f, 0x6b, 0x63, 0x00,	/* 0868 */
    0x00, 0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x00,	/* 0870 */
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x00,	/* 0878 */
    0x00, 0x00, 0x7c, 0x66, 0x66, 0x7c, 0x60, 0x60,	/* 0880 */
    0x00, 0x00, 0x3e, 0x66, 0x66, 0x3e, 0x06, 0x06,	/* 0888 */
    0x00, 0x00, 0x7c, 0x66, 0x60, 0x60, 0x60, 0x00,	/* 0890 */
    0x00, 0x00, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x00,	/* 0898 */
    0x00, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x0e, 0x00,	/* 08a0 */
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3e, 0x00,	/* 08a8 */
    0x00, 0x00, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00,	/* 08b0 */
    0x00, 0x00, 0x63, 0x6b, 0x7f, 0x3e, 0x36, 0x00,	/* 08b8 */
    0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x00,	/* 08c0 */
    0x00, 0x00, 0x66, 0x66, 0x66, 0x3e, 0x0c, 0x78,	/* 08c8 */
    0x00, 0x00, 0x7e, 0x0c, 0x18, 0x30, 0x7e, 0x00,	/* 08d0 */
    0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00,	/* 08d8 */
    0x0c, 0x12, 0x30, 0x7c, 0x30, 0x62, 0xfc, 0x00,	/* 08e0 */
    0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00,	/* 08e8 */
    0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18,	/* 08f0 */
    0x00, 0x10, 0x30, 0x7f, 0x7f, 0x30, 0x10, 0x00,	/* 08f8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0900 */
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00,	/* 0908 */
    0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0910 */
    0x66, 0x66, 0xff, 0x66, 0xff, 0x66, 0x66, 0x00,	/* 0918 */
    0x18, 0x3e, 0x60, 0x3c, 0x06, 0x7c, 0x18, 0x00,	/* 0920 */
    0x62, 0x66, 0x0c, 0x18, 0x30, 0x66, 0x46, 0x00,	/* 0928 */
    0x3c, 0x66, 0x3c, 0x38, 0x67, 0x66, 0x3f, 0x00,	/* 0930 */
    0x06, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0938 */
    0x0c, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00,	/* 0940 */
    0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00,	/* 0948 */
    0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00,	/* 0950 */
    0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00,	/* 0958 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30,	/* 0960 */
    0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,	/* 0968 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,	/* 0970 */
    0x00, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00,	/* 0978 */
    0x3c, 0x66, 0x6e, 0x76, 0x66, 0x66, 0x3c, 0x00,	/* 0980 */
    0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7e, 0x00,	/* 0988 */
    0x3c, 0x66, 0x06, 0x0c, 0x30, 0x60, 0x7e, 0x00,	/* 0990 */
    0x3c, 0x66, 0x06, 0x1c, 0x06, 0x66, 0x3c, 0x00,	/* 0998 */
    0x06, 0x0e, 0x1e, 0x66, 0x7f, 0x06, 0x06, 0x00,	/* 09a0 */
    0x7e, 0x60, 0x7c, 0x06, 0x06, 0x66, 0x3c, 0x00,	/* 09a8 */
    0x3c, 0x66, 0x60, 0x7c, 0x66, 0x66, 0x3c, 0x00,	/* 09b0 */
    0x7e, 0x66, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 09b8 */
    0x3c, 0x66, 0x66, 0x3c, 0x66, 0x66, 0x3c, 0x00,	/* 09c0 */
    0x3c, 0x66, 0x66, 0x3e, 0x06, 0x66, 0x3c, 0x00,	/* 09c8 */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00,	/* 09d0 */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30,	/* 09d8 */
    0x0e, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0e, 0x00,	/* 09e0 */
    0x00, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x00, 0x00,	/* 09e8 */
    0x70, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x70, 0x00,	/* 09f0 */
    0x3c, 0x66, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x00,	/* 09f8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0a00 */
    0x18, 0x3c, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00,	/* 0a08 */
    0x7c, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x7c, 0x00,	/* 0a10 */
    0x3c, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3c, 0x00,	/* 0a18 */
    0x78, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0x78, 0x00,	/* 0a20 */
    0x7e, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7e, 0x00,	/* 0a28 */
    0x7e, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x00,	/* 0a30 */
    0x3c, 0x66, 0x60, 0x6e, 0x66, 0x66, 0x3c, 0x00,	/* 0a38 */
    0x66, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x00,	/* 0a40 */
    0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00,	/* 0a48 */
    0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x6c, 0x38, 0x00,	/* 0a50 */
    0x66, 0x6c, 0x78, 0x70, 0x78, 0x6c, 0x66, 0x00,	/* 0a58 */
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7e, 0x00,	/* 0a60 */
    0x63, 0x77, 0x7f, 0x6b, 0x63, 0x63, 0x63, 0x00,	/* 0a68 */
    0x66, 0x76, 0x7e, 0x7e, 0x6e, 0x66, 0x66, 0x00,	/* 0a70 */
    0x3c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,	/* 0a78 */
    0x7c, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x00,	/* 0a80 */
    0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x0e, 0x00,	/* 0a88 */
    0x7c, 0x66, 0x66, 0x7c, 0x78, 0x6c, 0x66, 0x00,	/* 0a90 */
    0x3c, 0x66, 0x60, 0x3c, 0x06, 0x66, 0x3c, 0x00,	/* 0a98 */
    0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 0aa0 */
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00,	/* 0aa8 */
    0x66, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x00,	/* 0ab0 */
    0x63, 0x63, 0x63, 0x6b, 0x7f, 0x77, 0x63, 0x00,	/* 0ab8 */
    0x66, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x66, 0x00,	/* 0ac0 */
    0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x00,	/* 0ac8 */
    0x7e, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x7e, 0x00,	/* 0ad0 */
    0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18,	/* 0ad8 */
    0xc0, 0xc0, 0x30, 0x30, 0xc0, 0xc0, 0x30, 0x30,	/* 0ae0 */
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	/* 0ae8 */
    0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,	/* 0af0 */
    0x33, 0x99, 0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66,	/* 0af8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0b00 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,	/* 0b08 */
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,	/* 0b10 */
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0b18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,	/* 0b20 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,	/* 0b28 */
    0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33,	/* 0b30 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,	/* 0b38 */
    0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0x33, 0x33,	/* 0b40 */
    0xcc, 0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 0x66,	/* 0b48 */
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,	/* 0b50 */
    0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18,	/* 0b58 */
    0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0b60 */
    0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00,	/* 0b68 */
    0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18,	/* 0b70 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,	/* 0b78 */
    0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18,	/* 0b80 */
    0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0b88 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18,	/* 0b90 */
    0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18,	/* 0b98 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,	/* 0ba0 */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,	/* 0ba8 */
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,	/* 0bb0 */
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0bb8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0bc0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0bc8 */
    0x01, 0x03, 0x06, 0x6c, 0x78, 0x70, 0x60, 0x00,	/* 0bd0 */
    0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,	/* 0bd8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,	/* 0be0 */
    0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00,	/* 0be8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,	/* 0bf0 */
    0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0bf8 */
    0xc3, 0x99, 0x91, 0x91, 0x9f, 0x99, 0xc3, 0xff,	/* 0c00 */
    0xff, 0xff, 0xc3, 0xf9, 0xc1, 0x99, 0xc1, 0xff,	/* 0c08 */
    0xff, 0x9f, 0x9f, 0x83, 0x99, 0x99, 0x83, 0xff,	/* 0c10 */
    0xff, 0xff, 0xc3, 0x9f, 0x9f, 0x9f, 0xc3, 0xff,	/* 0c18 */
    0xff, 0xf9, 0xf9, 0xc1, 0x99, 0x99, 0xc1, 0xff,	/* 0c20 */
    0xff, 0xff, 0xc3, 0x99, 0x81, 0x9f, 0xc3, 0xff,	/* 0c28 */
    0xff, 0xf1, 0xe7, 0xc1, 0xe7, 0xe7, 0xe7, 0xff,	/* 0c30 */
    0xff, 0xff, 0xc1, 0x99, 0x99, 0xc1, 0xf9, 0x83,	/* 0c38 */
    0xff, 0x9f, 0x9f, 0x83, 0x99, 0x99, 0x99, 0xff,	/* 0c40 */
    0xff, 0xe7, 0xff, 0xc7, 0xe7, 0xe7, 0xc3, 0xff,	/* 0c48 */
    0xff, 0xf9, 0xff, 0xf9, 0xf9, 0xf9, 0xf9, 0xc3,	/* 0c50 */
    0xff, 0x9f, 0x9f, 0x93, 0x87, 0x93, 0x99, 0xff,	/* 0c58 */
    0xff, 0xc7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xff,	/* 0c60 */
    0xff, 0xff, 0x99, 0x80, 0x80, 0x94, 0x9c, 0xff,	/* 0c68 */
    0xff, 0xff, 0x83, 0x99, 0x99, 0x99, 0x99, 0xff,	/* 0c70 */
    0xff, 0xff, 0xc3, 0x99, 0x99, 0x99, 0xc3, 0xff,	/* 0c78 */
    0xff, 0xff, 0x83, 0x99, 0x99, 0x83, 0x9f, 0x9f,	/* 0c80 */
    0xff, 0xff, 0xc1, 0x99, 0x99, 0xc1, 0xf9, 0xf9,	/* 0c88 */
    0xff, 0xff, 0x83, 0x99, 0x9f, 0x9f, 0x9f, 0xff,	/* 0c90 */
    0xff, 0xff, 0xc1, 0x9f, 0xc3, 0xf9, 0x83, 0xff,	/* 0c98 */
    0xff, 0xe7, 0x81, 0xe7, 0xe7, 0xe7, 0xf1, 0xff,	/* 0ca0 */
    0xff, 0xff, 0x99, 0x99, 0x99, 0x99, 0xc1, 0xff,	/* 0ca8 */
    0xff, 0xff, 0x99, 0x99, 0x99, 0xc3, 0xe7, 0xff,	/* 0cb0 */
    0xff, 0xff, 0x9c, 0x94, 0x80, 0xc1, 0xc9, 0xff,	/* 0cb8 */
    0xff, 0xff, 0x99, 0xc3, 0xe7, 0xc3, 0x99, 0xff,	/* 0cc0 */
    0xff, 0xff, 0x99, 0x99, 0x99, 0xc1, 0xf3, 0x87,	/* 0cc8 */
    0xff, 0xff, 0x81, 0xf3, 0xe7, 0xcf, 0x81, 0xff,	/* 0cd0 */
    0xc3, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xc3, 0xff,	/* 0cd8 */
    0xf3, 0xed, 0xcf, 0x83, 0xcf, 0x9d, 0x03, 0xff,	/* 0ce0 */
    0xc3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xc3, 0xff,	/* 0ce8 */
    0xff, 0xe7, 0xc3, 0x81, 0xe7, 0xe7, 0xe7, 0xe7,	/* 0cf0 */
    0xff, 0xef, 0xcf, 0x80, 0x80, 0xcf, 0xef, 0xff,	/* 0cf8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0d00 */
    0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0xff, 0xe7, 0xff,	/* 0d08 */
    0x99, 0x99, 0x99, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0d10 */
    0x99, 0x99, 0x00, 0x99, 0x00, 0x99, 0x99, 0xff,	/* 0d18 */
    0xe7, 0xc1, 0x9f, 0xc3, 0xf9, 0x83, 0xe7, 0xff,	/* 0d20 */
    0x9d, 0x99, 0xf3, 0xe7, 0xcf, 0x99, 0xb9, 0xff,	/* 0d28 */
    0xc3, 0x99, 0xc3, 0xc7, 0x98, 0x99, 0xc0, 0xff,	/* 0d30 */
    0xf9, 0xf3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0d38 */
    0xf3, 0xe7, 0xcf, 0xcf, 0xcf, 0xe7, 0xf3, 0xff,	/* 0d40 */
    0xcf, 0xe7, 0xf3, 0xf3, 0xf3, 0xe7, 0xcf, 0xff,	/* 0d48 */
    0xff, 0x99, 0xc3, 0x00, 0xc3, 0x99, 0xff, 0xff,	/* 0d50 */
    0xff, 0xe7, 0xe7, 0x81, 0xe7, 0xe7, 0xff, 0xff,	/* 0d58 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xcf,	/* 0d60 */
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff,	/* 0d68 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xe7, 0xff,	/* 0d70 */
    0xff, 0xfc, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0xff,	/* 0d78 */
    0xc3, 0x99, 0x91, 0x89, 0x99, 0x99, 0xc3, 0xff,	/* 0d80 */
    0xe7, 0xe7, 0xc7, 0xe7, 0xe7, 0xe7, 0x81, 0xff,	/* 0d88 */
    0xc3, 0x99, 0xf9, 0xf3, 0xcf, 0x9f, 0x81, 0xff,	/* 0d90 */
    0xc3, 0x99, 0xf9, 0xe3, 0xf9, 0x99, 0xc3, 0xff,	/* 0d98 */
    0xf9, 0xf1, 0xe1, 0x99, 0x80, 0xf9, 0xf9, 0xff,	/* 0da0 */
    0x81, 0x9f, 0x83, 0xf9, 0xf9, 0x99, 0xc3, 0xff,	/* 0da8 */
    0xc3, 0x99, 0x9f, 0x83, 0x99, 0x99, 0xc3, 0xff,	/* 0db0 */
    0x81, 0x99, 0xf3, 0xe7, 0xe7, 0xe7, 0xe7, 0xff,	/* 0db8 */
    0xc3, 0x99, 0x99, 0xc3, 0x99, 0x99, 0xc3, 0xff,	/* 0dc0 */
    0xc3, 0x99, 0x99, 0xc1, 0xf9, 0x99, 0xc3, 0xff,	/* 0dc8 */
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xe7, 0xff, 0xff,	/* 0dd0 */
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xe7, 0xe7, 0xcf,	/* 0dd8 */
    0xf1, 0xe7, 0xcf, 0x9f, 0xcf, 0xe7, 0xf1, 0xff,	/* 0de0 */
    0xff, 0xff, 0x81, 0xff, 0x81, 0xff, 0xff, 0xff,	/* 0de8 */
    0x8f, 0xe7, 0xf3, 0xf9, 0xf3, 0xe7, 0x8f, 0xff,	/* 0df0 */
    0xc3, 0x99, 0xf9, 0xf3, 0xe7, 0xff, 0xe7, 0xff,	/* 0df8 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0e00 */
    0xe7, 0xc3, 0x99, 0x81, 0x99, 0x99, 0x99, 0xff,	/* 0e08 */
    0x83, 0x99, 0x99, 0x83, 0x99, 0x99, 0x83, 0xff,	/* 0e10 */
    0xc3, 0x99, 0x9f, 0x9f, 0x9f, 0x99, 0xc3, 0xff,	/* 0e18 */
    0x87, 0x93, 0x99, 0x99, 0x99, 0x93, 0x87, 0xff,	/* 0e20 */
    0x81, 0x9f, 0x9f, 0x87, 0x9f, 0x9f, 0x81, 0xff,	/* 0e28 */
    0x81, 0x9f, 0x9f, 0x87, 0x9f, 0x9f, 0x9f, 0xff,	/* 0e30 */
    0xc3, 0x99, 0x9f, 0x91, 0x99, 0x99, 0xc3, 0xff,	/* 0e38 */
    0x99, 0x99, 0x99, 0x81, 0x99, 0x99, 0x99, 0xff,	/* 0e40 */
    0xc3, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xc3, 0xff,	/* 0e48 */
    0xe1, 0xf3, 0xf3, 0xf3, 0xf3, 0x93, 0xc7, 0xff,	/* 0e50 */
    0x99, 0x93, 0x87, 0x8f, 0x87, 0x93, 0x99, 0xff,	/* 0e58 */
    0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x81, 0xff,	/* 0e60 */
    0x9c, 0x88, 0x80, 0x94, 0x9c, 0x9c, 0x9c, 0xff,	/* 0e68 */
    0x99, 0x89, 0x81, 0x81, 0x91, 0x99, 0x99, 0xff,	/* 0e70 */
    0xc3, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xff,	/* 0e78 */
    0x83, 0x99, 0x99, 0x83, 0x9f, 0x9f, 0x9f, 0xff,	/* 0e80 */
    0xc3, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xf1, 0xff,	/* 0e88 */
    0x83, 0x99, 0x99, 0x83, 0x87, 0x93, 0x99, 0xff,	/* 0e90 */
    0xc3, 0x99, 0x9f, 0xc3, 0xf9, 0x99, 0xc3, 0xff,	/* 0e98 */
    0x81, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xff,	/* 0ea0 */
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xff,	/* 0ea8 */
    0x99, 0x99, 0x99, 0x99, 0x99, 0xc3, 0xe7, 0xff,	/* 0eb0 */
    0x9c, 0x9c, 0x9c, 0x94, 0x80, 0x88, 0x9c, 0xff,	/* 0eb8 */
    0x99, 0x99, 0xc3, 0xe7, 0xc3, 0x99, 0x99, 0xff,	/* 0ec0 */
    0x99, 0x99, 0x99, 0xc3, 0xe7, 0xe7, 0xe7, 0xff,	/* 0ec8 */
    0x81, 0xf9, 0xf3, 0xe7, 0xcf, 0x9f, 0x81, 0xff,	/* 0ed0 */
    0xe7, 0xe7, 0xe7, 0x00, 0x00, 0xe7, 0xe7, 0xe7,	/* 0ed8 */
    0x3f, 0x3f, 0xcf, 0xcf, 0x3f, 0x3f, 0xcf, 0xcf,	/* 0ee0 */
    0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7,	/* 0ee8 */
    0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33,	/* 0ef0 */
    0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 0x33, 0x99,	/* 0ef8 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0f00 */
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0f08 */
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,	/* 0f10 */
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0f18 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,	/* 0f20 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,	/* 0f28 */
    0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,	/* 0f30 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,	/* 0f38 */
    0xff, 0xff, 0xff, 0xff, 0x33, 0x33, 0xcc, 0xcc,	/* 0f40 */
    0x33, 0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc, 0x99,	/* 0f48 */
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,	/* 0f50 */
    0xe7, 0xe7, 0xe7, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7,	/* 0f58 */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0,	/* 0f60 */
    0xe7, 0xe7, 0xe7, 0xe0, 0xe0, 0xff, 0xff, 0xff,	/* 0f68 */
    0xff, 0xff, 0xff, 0x07, 0x07, 0xe7, 0xe7, 0xe7,	/* 0f70 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,	/* 0f78 */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7,	/* 0f80 */
    0xe7, 0xe7, 0xe7, 0x00, 0x00, 0xff, 0xff, 0xff,	/* 0f88 */
    0xff, 0xff, 0xff, 0x00, 0x00, 0xe7, 0xe7, 0xe7,	/* 0f90 */
    0xe7, 0xe7, 0xe7, 0x07, 0x07, 0xe7, 0xe7, 0xe7,	/* 0f98 */
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,	/* 0fa0 */
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,	/* 0fa8 */
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,	/* 0fb0 */
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0fb8 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 0fc0 */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,	/* 0fc8 */
    0xfe, 0xfc, 0xf9, 0x93, 0x87, 0x8f, 0x9f, 0xff,	/* 0fd0 */
    0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f,	/* 0fd8 */
    0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff,	/* 0fe0 */
    0xe7, 0xe7, 0xe7, 0x07, 0x07, 0xff, 0xff, 0xff,	/* 0fe8 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff,	/* 0ff0 */
    0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0	/* 0ff8 */
};

#endif
