/***************************************************************************
**    xSQLIndex.cpp  $Revision: 1.6 $ - $Name: V2-18 $ 
**    SQL Table Index Keeper
**
**    Copyright (C) 1996 Joseph Croft <jcroft@unicomp.net>
**
**    This library is free software; you can redistribute it and/or
**    modify it under the terms of the GNU Library General Public
**    License as published by the Free Software Foundation; either
**    version 2 of the License, or (at your option) any later version.
**
**    This library is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**    Library General Public License for more details.
**
**    You should have received a copy of the GNU Library General Public
**    License along with this library; if not, write to the Free
**    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qdict.h>
#include "xSQLIndex.h"

xSQLFieldDef fields[] =
{
   {sqlPlain, "indexes.tablename", "", NULL, 0},
   {sqlPlain, "indexes.index", "", NULL, 0}
};

xSQLIndex::xSQLIndex() : xSQLBase(fields)
{
}

xSQLIndex::~xSQLIndex()
{
}

QString xSQLIndex::nextIndex(int database, QString &table)
{
   QDict<QString> fields, data, links;
   QList<QString> sort;
   QString rv;
   char buf[20];
   int x;
   
   links.insert("indexes.tablename", &table);
   if (query(database, fields, links, sort) == TRUE)
   {
      data = getRow(1);
//      data.toFirst();
      x = strtol((const char *)*data.find("indexes.index"), NULL, 10);
      if (x > 0)
      {
         x++;
         sprintf(buf, "%d", x);
         rv = buf;
         data.replace("indexes.index", &rv);
         update(database, data, links);
      }
   }
   return(rv);
}
