#include <kdebug.h>
#include <qimage.h>
#include "formats.h"
#include "gif.h"

extern void read_jpeg_jfif(QImageIO *);

static int numFormats= 6;
//static int numFormats= 5;

static FormatRecord formatlist[]= {
#ifndef QT13B_TESTER
  {
   "GIF",
   FormatRecord::ReadFormat | FormatRecord::WriteFormat,
   "^GIF[0-9][0-9][a-z]",
   "*.gif",
   "gif",
   read_gif_file, write_gif_file,
},
#else
  {
    "GIF",
    FormatRecord::InternalFormat | FormatRecord::ReadFormat | FormatRecord::WriteFormat,
    "^GIF[0-9][0-9][a-z]",
    "*.gif",
    "gif",
    0, 0,
  },
#endif
  {
    "JPEG",
    FormatRecord::ReadFormat,
    "^\377\330\377\340",
    "*.jpeg *.jpg",
    "jpeg",
    read_jpeg_jfif, 0,
  },
  {
    "BMP",
    FormatRecord::InternalFormat | FormatRecord::ReadFormat | FormatRecord::WriteFormat,
    0,
    "*.bmp",
    "bmp",
    0, 0,
  },
  {	 
    "XBM",
    FormatRecord::InternalFormat | FormatRecord::ReadFormat | FormatRecord::WriteFormat,
    0,
    "*.xbm",
    "xbm",
    0, 0,
  },
  {
    "XPM",
    FormatRecord::InternalFormat | FormatRecord::ReadFormat | FormatRecord::WriteFormat,
    0,
    "*.xpm",
    "xpm",
    0, 0,
  },
  {
    "PNM",
    0,
    "*.pbm *.pgm *.ppm",
    "ppm",
    0, 0
  }
};

FormatManager::FormatManager()
{
   list.setAutoDelete(TRUE);
   init(formatlist);
}

FormatManager::~FormatManager()
{
}

void FormatManager::init(FormatRecord formatlist[])
{
   int i;
   FormatRecord *rec;
   
   // Build format list
   for (i= 0; i < numFormats; i++) {
     list.append(&formatlist[i]);
     names.append(formatlist[i].formatName);
     globAll.append(formatlist[i].glob);
     if (i < numFormats-1)
       globAll.append(" ");
   };
   
   // Register them with Qt
   for (rec= list.first(); rec != NULL; rec= list.next()) {
     if ( (rec->flags & FormatRecord::InternalFormat) == 0L)
       QImageIO::defineIOHandler(rec->formatName, rec->magic,
				 0, 
				 rec->read_format, rec->write_format);
   }
}
	  
QStrList *FormatManager::formats(void)
{
  return &names;
}

const char *FormatManager::allImagesGlob(void)
{
  return globAll;
}
 
const char *FormatManager::glob(const char *format)
{
  FormatRecord *rec;
  QString name(format);
  QString curr;
  bool done= FALSE;

  rec= list.first();
  do { 
    curr= rec->formatName;
    if (curr == name)
      done= TRUE;
    else 
      rec= list.next();
  } while (!done && (rec != NULL));

  if (done)
    return rec->glob;
  else
    return NULL;
}

const char *FormatManager::suffix(const char *format)
{
  FormatRecord *rec;
  QString name(format);
  QString curr;
  bool done= FALSE;

  rec= list.first();
  do { 
    curr= rec->formatName;
    if (curr == name)
      done= TRUE;
    else 
      rec= list.next();
  } while (!done && (rec != NULL));

  if (done)
    return rec->suffix;
  else
    return NULL;
}

