/* 
   MissingMethods.h

   Copyright (C) 1995, 1996, 1997 Ovidiu Predescu and Mircea Oancea.
   All rights reserved.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>

   This file is part of the Foundation Extensions Library.

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies and that both that
   copyright notice and this permission notice appear in supporting
   documentation.

   We disclaim all warranties with regard to this software, including all
   implied warranties of merchantability and fitness, in no event shall
   we be liable for any special, indirect or consequential damages or any
   damages whatsoever resulting from loss of use, data or profits, whether in
   an action of contract, negligence or other tortious action, arising out of
   or in connection with the use or performance of this software.
*/

#ifndef __MissingMethods_h__
#define __MissingMethods_h__

#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSMethodSignature.h>

#if (__GNUC__ == 2) && (__GNUC_MINOR__ <= 6) && !defined(__attribute__)
#  define __attribute__(x)
#endif


#ifndef LIB_FOUNDATION_LIBRARY

@interface NSArray (AdditionalMethods)
- initWithArray:(NSArray *)anArray copyItems:(BOOL)flag;
@end

#endif



#if GNUSTEP_BASE_LIBRARY

@interface NSDictionary (MissingMethods)
- (id)initWithObjectsAndKeys:(id)firstObject arguments:(va_list)argList;
@end

@interface NSMutableDictionary (MissingMethods)
- (void)setDictionary:(NSDictionary*)otherDictionary;
@end

@interface NSString (MissingMethods)
- (NSString *)substringWithRange:(NSRange)range;
@end

#endif /* GNUSTEP_BASE_LIBRARY */



#if NeXT_Foundation_LIBRARY

typedef struct {
    int	offset;
    int	size;
    const char* type;
} NSArgumentInfo;

@interface NSMethodSignature (MissingMethods)
- (NSArgumentInfo)argumentInfoAtIndex:(unsigned)index;
@end



#endif


#if NeXT_Foundation_LIBRARY || Sun_Foundation_LIBRARY

@interface NSObject (MissingMethods)
- subclassResponsibility:(SEL)aSel;
- notImplemented:(SEL)aSel;
@end /* NSObject (MissingMethods) */

#endif /* NeXT_Foundation_LIBRARY */


#endif /* __MissingMethods_h__ */
