/*
 * dsock.c - Ultrix socket processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.6 98/05/22 07:16:49 abe Exp $";
#endif


#include "lsof.h"

#if	defined(DECnet)
#include <netdnet/dn.h>

_PROTOTYPE(extern char *dnet_htoa,(struct dn_naddr *a));
_PROTOTYPE(extern char *dnet_ntoa,(struct dn_naddr *a));
_PROTOTYPE(extern char *dnet_otoa,(struct sockaddr_dn *s));
_PROTOTYPE(static void printdnad,(struct sockaddr_dn *s, char **d));


/*
 * printdnad() - print DECnet address
 */

static void
printdnad(s, d)
	struct sockaddr_dn *s;		/* DECnet socket */
	char **d;			/* result string pointer address */
{
	char *cp;
/*
 * Print node address.
 */
	if (Fhost)
	    cp = dnet_htoa(&s->sdn_add);
	else
	    cp = dnet_ntoa(&s->sdn_add);
	if (*cp) {
	    (void) strcpy(*d, cp);
	    *d += strlen(cp);
	}
/*
 * Print object name.
 */
	cp = dnet_otoa(s);
	if (*cp) {
	    **d = ':';
	    (void) strcpy(*d + 1, cp);
	    *d += strlen(cp) + 1;
	}
}
#endif	/* DECnet */


/*
 * process_socket() - process socket
 */

void
process_socket(sa)
	KA_T sa;			/* socket address in kernel */
{
	struct domain d;
	unsigned char *fa = (unsigned char *)NULL;
	int fam;
	int fp, lp;
	struct inpcb inp;
	unsigned char *la = (unsigned char *)NULL;
	struct mbuf mb;
	struct protosw p;
	struct rawcb raw;
	struct socket s;
	struct tcpcb t;
	struct unpcb uc, unp;
	struct sockaddr_un *ua = (struct sockaddr_un *)NULL;
	struct sockaddr_un un;

#if	defined(DECnet)
	char *ap;
	struct dnet_pcb {
	    unsigned char d1[60];
	    struct sockaddr_dn la;
	    struct sockaddr_dn fa;
	} dp;
#endif	/* defined(DECnet) */

	(void) strcpy(Lf->type, "sock");
	Lf->inp_ty = 2;
/*
 * Read the socket, protocol, and domain structures.
 */
	if (!sa) {
	    enter_nm("no socket address");
	    return;
	}
	if (kread((KA_T) sa, (char *) &s, sizeof(s))) {
	    (void) sprintf(Namech, "can't read socket struct from %s",
		print_kptr(sa, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
	if (!s.so_type) {
	    enter_nm("no socket type");
	    return;
	}
	if (!s.so_proto
	||  kread((KA_T) s.so_proto, (char *) &p, sizeof(p))) {
	    (void) strcpy(Namech, "no protocol switch");
	    enter_nm(Namech);
	    return;
	}
	if (kread((KA_T) p.pr_domain, (char *) &d, sizeof(d))) {
	    (void) sprintf(Namech, "can't read domain struct from %s",
		print_kptr((KA_T)p.pr_domain, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
/*
 * Save size information.
 */
	if (Fsize) {
	    if (Lf->access == 'r')
		Lf->sz = (SZOFFTYPE)s.so_rcv.sb_cc;
	    else if (Lf->access == 'w')
		Lf->sz = (SZOFFTYPE)s.so_snd.sb_cc;
	    else
		Lf->sz = (SZOFFTYPE)(s.so_rcv.sb_cc + s.so_snd.sb_cc);
	    Lf->sz_def = 1;
	} else
	    Lf->off_def = 1;

#if	defined(HASTCPTPIQ)
	Lf->lts.rq = s.so_rcv.sb_cc;
	Lf->lts.sq = s.so_snd.sb_cc;
	Lf->lts.rqs = Lf->lts.sqs = 1;
#endif	/* defined(HASTCPTPIQ) */

/*
 * Process socket by the associated domain family.
 */
	switch ((fam = d.dom_family)) {

#if	defined(DECnet)
/*
 * Process a DECnet domain socket.
 */
	case AF_DECnet:
	    if (Fnet)
		Lf->sf |= SELNET;
	    (void) strcpy(Lf->type, "dnet");
	    if (!s.so_pcb || s.so_pcb == (caddr_t)-1 || s.so_pcb == (caddr_t)-2)
	    {
		enter_nm("no further DECnet information");
		break;
	    }
	    if (kread((KA_T) s.so_pcb, (char *)&dp, sizeof(dp))) {
		(void) sprintf(Namech, "can't read pcb at %s",
		    print_lptr((KA_T)s.so_pcb, (char *)NULL));
		enter_nm(Namech);
		break;
	    }
	    enter_dev_ch(print_kptr((KA_T)s.so_pcb, (char *)NULL));
	    if (dp.la.sdn_add.a_len || dp.fa.sdn_add.a_len) {
		ap = Namech;
		if (dp.la.sdn_add.a_len)
		    (void) printdnad(&dp.la, &ap);
		if (dp.fa.sdn_add.a_len) {
		    (void) strcpy(ap, "->");
		    ap += 2;
		    (void) printdnad(&dp.fa, &ap);
		}
		enter_nm(Namech);
	    } else
		enter_nm("no DECnet addresses");
	    break;
#endif	/* DECnet */

/*
 * Process an Internet domain socket.
 */
	case AF_INET:
	    if (Fnet)
		Lf->sf |= SELNET;
	    (void) strcpy(Lf->type, "inet");
	    printiproto(p.pr_protocol);
	/*
	 * Read protocol control block.
	 */
	    if (!s.so_pcb) {
		enter_nm("no protocol control block");
		return;
	    }
	    if (s.so_type == SOCK_RAW) {

	    /*
	     * Print raw socket information.
	     */
		if (kread((KA_T) s.so_pcb, (char *)&raw, sizeof(raw))
		||  (struct socket *)sa != raw.rcb_socket) {
		    (void) sprintf(Namech, "can't read rawcb at %s",
			print_kptr((KA_T)s.so_pcb, (char *)NULL));
		    enter_nm(Namech);
		    return;
		}
		enter_dev_ch(print_kptr((KA_T)(raw.rcb_pcb ? raw.rcb_pcb
							   : s.so_pcb),
					(char *)NULL));
		if (raw.rcb_laddr.sa_family == AF_INET)
		    la = (unsigned char *)&raw.rcb_laddr.sa_data[2];
		else if (raw.rcb_laddr.sa_family)
		    printrawaddr(&raw.rcb_laddr);
		if (raw.rcb_faddr.sa_family == AF_INET)
		    fa = (unsigned char *)&raw.rcb_faddr.sa_data[2];
		else if (raw.rcb_faddr.sa_family) {
		    (void) strcat(endnm(), "->");
		    printrawaddr(&raw.rcb_faddr);
		}
		if (fa || la)
		    (void) ent_inaddr(la, -1, fp, -1, AF_INET);
	    } else {

	    /*
	     * Print Internet socket information.
	     */
		if (kread((KA_T) s.so_pcb, (char *) &inp, sizeof(inp))
		||  (struct socket *)sa != inp.inp_socket) {
		    (void) sprintf(Namech, "can't read inpcb at %s",
			print_kptr((KA_T)s.so_pcb, (char *)NULL));
		    enter_nm(Namech);
		    return;
		}
		enter_dev_ch(print_kptr((KA_T)(inp.inp_ppcb ? inp.inp_ppcb
							    : s.so_pcb),
					(char *)NULL));
		la = (unsigned char *)&inp.inp_laddr;
		lp = (int)ntohs(inp.inp_lport);
		if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport != 0) {
		    fa = (unsigned char *)&inp.inp_faddr;
		    fp = (int)ntohs(inp.inp_fport);
		}
		if (fa || la)
		    (void) ent_inaddr(la, lp, fa, fp, AF_INET);
		if (p.pr_protocol == IPPROTO_TCP && inp.inp_ppcb
		&&  !kread((KA_T)inp.inp_ppcb, (char *)&t, sizeof(t))) {
		    Lf->lts.type = 0;
		    Lf->lts.state.i = (int)t.t_state;
		}
	    }
	    break;
/*
 * Process a Unix domain socket.
 */
	case AF_UNIX:
	    if (Funix)
		Lf->sf |= SELUNX;
	    (void) strcpy(Lf->type, "unix");
	/*
	 * Read Unix protocol control block and the Unix address structure.
	 */

	    enter_dev_ch(print_kptr(sa, (char *)NULL));
	    if (kread((KA_T) s.so_pcb, (char *) &unp, sizeof(unp))) {
		(void) sprintf(Namech, "can't read unpcb at %s",
		    print_kptr((KA_T)s.so_pcb, (char *)NULL));
		break;
	    }
	    if ((struct socket *)sa != unp.unp_socket) {
		(void) sprintf(Namech, "unp_socket (%s) mismatch",
		    print_kptr((KA_T)unp.unp_socket, (char *)NULL));
		break;
	    }
	    if (unp.unp_addr) {
		if (kread((KA_T) unp.unp_addr, (char *) &mb, sizeof(mb))) {
		    (void) sprintf(Namech, "can't read unp_addr at %s",
			print_kptr((KA_T)unp.unp_addr, (char *)NULL));
		    break;
		}
		ua = (struct sockaddr_un *)(((char *)&mb) + mb.m_off);
	    }
	    if (!ua) {
		ua = &un;
		(void) bzero((char *)ua, sizeof(un));
		ua->sun_family = AF_UNSPEC;
	    }
	/*
	 * Print information on Unix socket that has no address bound
	 * to it, although it may be connected to another Unix domain
	 * socket as a pipe.
	 */
	    if (ua->sun_family != AF_UNIX) {
		if (ua->sun_family == AF_UNSPEC) {
		    if (unp.unp_conn) {
			if (kread((KA_T)unp.unp_conn, (char *)&uc, sizeof(uc)))
			    (void) sprintf(Namech, "can't read unp_conn at %s",
				print_kptr((KA_T)unp.unp_conn, (char *)NULL));
			else
			    (void) sprintf(Namech, "->%s",
				print_kptr((KA_T)uc.unp_socket, (char *)NULL));
		    } else
			(void) strcpy(Namech, "->(none)");
		} else
		    (void) sprintf(Namech, "unknown sun_family (%d)",
			ua->sun_family);
		break;
	    }
	    if (ua->sun_path[0]) {
		if (mb.m_len >= sizeof(struct sockaddr_un))
		    mb.m_len = sizeof(struct sockaddr_un) - 1;
		*((char *)ua + mb.m_len) = '\0';
		if (Sfile && is_file_named(ua->sun_path, VSOCK))
		    Lf->sf |= SELNM;
		else
		    (void) strcpy(Namech, ua->sun_path);
	    } else
		(void) strcpy(Namech, "no address");
	    break;
	default:
	    printunkaf(fam);
	}
	if (Namech[0])
	    enter_nm(Namech);
}
