#include "rxvt.h"
#ifdef DISPLAY_ENV_AND_ANSWER_IS_IP
/* compile an empty file if this option is disabled. */

/* On Solaris link with -lsocket and -lnsl */
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>		/*#define TIME_WITH_SYS_TIME*/
#include <sys/time.h>		/*#define HAVE_SYS_TIME_H*/
#if defined(__sun__) && defined(__svr4__)
#  include <sys/sockio.h>
#  include <sys/byteorder.h>
#endif
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

/* strerror() */
#if defined(sun) && !defined(SVR4) && !defined (strerror)
extern char *sys_errlist[];
extern int sys_nerr;
#define strerror(n) (((n) >= 0 && (n) < sys_nerr) ? sys_errlist[n] : "error")
#endif

static int
inetany_addr_fmt (char *name, struct sockaddr_in *sin)
{
   unsigned long ad = htonl ((unsigned long) sin->sin_addr.s_addr);
   sprintf(name, "%d.%d.%d.%d",
	   (int) ((ad >> 24) & 0xFF),
	   (int) ((ad >> 16) & 0xFF),
	   (int) ((ad >> 8 ) & 0xFF),
	   (int) ( ad        & 0xFF));
   return 0;
}

static char *
if_to_addrstr (int skfd, char *ifname)
{
   static struct sockaddr NULL_ADDR = { 0 };
   struct sockaddr addr;
   struct ifreq ifr;
   char * buf = malloc (32*sizeof(char));
   strcpy (ifr.ifr_name, ifname);
   addr = ioctl (skfd, SIOCGIFADDR, &ifr) < 0 ? NULL_ADDR : ifr.ifr_addr;
   inetany_addr_fmt (buf, (struct sockaddr_in *) &addr);
   return buf;
}

char *
network_display (char * actual_display)
{
   char buf [1024], *local_ip_quad, *rval, *after_colon;
   struct ifconf ifc;
   struct ifreq *ifr;
   int i, n, skfd;

   if (strncmp(actual_display, "unix:", 5) != 0 && actual_display[0] != ':')
     return actual_display;		/* nothing to do */

   after_colon = strpbrk(actual_display, ":");	/* find ptr to ':' */

   if ((skfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
      perror("socket");
      return 0;
   }
   ifc.ifc_len = sizeof(buf);		/* Get names of all ifaces */
   ifc.ifc_buf = buf;
   if (ioctl(skfd, SIOCGIFCONF, &ifc) < 0) {
      fprintf(stderr, "SIOCGIFCONF: %s\n", strerror(errno));
      return 0;
   }
   ifr = ifc.ifc_req;
   n = ifc.ifc_len / sizeof(struct ifreq);

   for (i = 0; i < n; ++i, ++ifr) {
      local_ip_quad = if_to_addrstr(skfd, ifr->ifr_name);
      if (strcmp(local_ip_quad, "127.0.0.1") == 0 ||
	  strcmp(local_ip_quad, "0.0.0.0") == 0)
	continue;
      else
	break;
   }
   close (skfd);

   rval = malloc (strlen (local_ip_quad) + strlen (after_colon) + 1);
   sprintf (rval, "%s%s", local_ip_quad, after_colon);

   return rval;
}
#endif /* DISPLAY_ENV_AND_ANSWER_IS_IP */
/*----------------------- end-of-file (C source) -----------------------*/
