/*--------------------------------*-C-*---------------------------------*
 * file:	defaults.h
 *
 * Some wired-in defaults so we can run without external resources.
 * Split from configure.h so fiddling won't require a full rebuild.
 *
 * ----------------------------------------------------------------------
 * Copyright 1995 mj olesen <olesen@me.queensu.ca> Queen's Univ at Kingston
 *
 * You can do what you like with this source code provided you don't make
 * money from it and you include an unaltered copy of this message
 * (including the copyright).  As usual, the author accepts no
 * responsibility for anything, nor does he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#ifndef _DEFAULTS_H
#define _DEFAULTS_H

/* various Keysym(s), self-explanatory */
#define DEF_KS_BIGFONT		XK_KP_Add
#define DEF_KS_SMALLFONT	XK_KP_Subtract
#define DEF_KS_PRINTSCREEN	XK_Print
#define DEF_KS_PAGEUP		XK_Prior
#define DEF_KS_PAGEDOWN		XK_Next
#define DEF_KS_GREEKTOGGLE	XK_Mode_switch
#define DEF_KS_SECURE		XK_S	/* note upper-case */
#define DEF_KS_ALERT		XK_I	/* note upper-case */

/* size of scrollback (number of lines) */
#define DEF_SCROLLBACK	64

/* how to handle meta key events (choose 1) */
#define DEF_META	033	/* escape */
/*#define DEF_META	0x80*/	/* 8-bit hi */
/*#define DEF_META	0*/	/* ignore */

/* use a login shell by default? (0 or 1),
 * NB: using a login shell with `-e rlogin' doesn't work
 */
#define DEF_LOGINSHELL	0

/* window size */
#define DEF_GEOMETRY	"80x24"

/* default cursor name (not yet) */
#define DEF_CURSOR      "xterm"

/* default font name (single font mode) */
#define DEF_FONT	"fixed"

/* font position in list (multi-font mode) */
#define NORM_FONT	1

/* default font name (multi-font mode) */
#define DEF_FONT0	"6x13"
/* alternative font names (multi-font mode) */
#define DEF_FONT1	"5x8"
#define DEF_FONT2	"8x13"
#define DEF_FONT3	"9x15"
#define DEF_FONT4	"12x24"

/* printer pipe name */
#define DEF_PRINTPIPE	"lpr"

/* initial map alert state */
#define DEF_MAPALERT	1

/* initial visual bell state */
#define DEF_VISUALBELL	1

/* character class of separating chars for multiple-click selection */
#define DEF_CUTCHARS	"\t [](){|}<=>\"`,'*?;&"

/* normal foreground/background colors */
#if 1
# define DEF_FGNAME	"black"
# define DEF_BGNAME	"white"
#else
# define DEF_FGNAME	"white"
# define DEF_BGNAME	"black"
#endif

#ifdef COLOR
#ifdef DOS_VGA_COLORS		/* DOS VGA colors */
# define DEF_COLOR0	"#000000"	/* black	*/
# define DEF_COLOR1	"#A80000"	/* red		*/
# define DEF_COLOR2	"#00A800"	/* green	*/
# define DEF_COLOR3	"#A8A800"	/* yellow	*/
# define DEF_COLOR4	"#0000A8"	/* blue		*/
# define DEF_COLOR5	"#A800A8"	/* magenta	*/
# define DEF_COLOR6	"#00A8A8"	/* cyan		*/
# define DEF_COLOR7	"#A8A8A8"	/* white	*/
/* bold foreground, blink background colors */
# define DEF_COLOR10	"#000054"	/* Bold black	*/
# define DEF_COLOR11	"#FF0054"	/* Bold red	*/
# define DEF_COLOR12	"#00FF54"	/* Bold green	*/
# define DEF_COLOR13	"#FFFF54"	/* Bold yellow	*/
# define DEF_COLOR14	"#0000FF"	/* Bold blue	*/
# define DEF_COLOR15	"#FF00FF"	/* Bold magenta */
# define DEF_COLOR16	"#00FFFF"	/* Bold cyan	*/
# define DEF_COLOR17	"#FFFFFF"	/* Bold white	*/
#else	/* DOS_VGA_COLORS */
# define DEF_COLOR0	"black"		/* black	#000000 */
# define DEF_COLOR1	"red"		/* red		#FF0000 */
# define DEF_COLOR2	"LimeGreen"	/* green	#32CD32 */
# define DEF_COLOR3	"gold"		/* yellow	#FFD700 */
# define DEF_COLOR4	"blue"		/* blue		#0000FF */
# define DEF_COLOR5	"magenta"	/* magenta	#FF00FF */
# define DEF_COLOR6	"turquoise"	/* cyan		#40E0D0 */
# define DEF_COLOR7	"grey"		/* white	#BEBEBE */
/* bold foreground, blink background colors */
# define DEF_COLOR10	"grey50"	/* Bold black	#7F7F7F */
# define DEF_COLOR11	"OrangeRed"	/* Bold red	#FF4500 */
# define DEF_COLOR12	"green"		/* Bold green	#00FF00 */
# define DEF_COLOR13	"yellow"	/* Bold yellow	#FFFF00 */
# define DEF_COLOR14	"DodgerBlue"	/* Bold blue	#1E90FF */
# define DEF_COLOR15	"HotPink"	/* Bold magenta #FF69B4 */
# define DEF_COLOR16	"cyan"		/* Bold cyan	#00FFFF */
# define DEF_COLOR17	"white"		/* Bold white	#FFFFFF */
#endif	/* DOS_VGA_COLORS */
# ifdef USE_FAKE_BOLD
#  undef DEF_COLOR2
#  undef DEF_COLOR3
#  undef DEF_COLOR6
#  undef DEF_COLOR7
#  define DEF_COLOR2	DEF_COLOR12
#  define DEF_COLOR3	DEF_COLOR13
#  define DEF_COLOR6	DEF_COLOR16
#  define DEF_COLOR7	DEF_COLOR17
# endif	/* USE_FAKE_BOLD */
#endif	/* COLOR */

/* default scrollbar type (choose 1) */
#define DEF_SCROLLBAR	SBAR_NOARROWS	/* without arrows (XTerm-style) */
/*#define DEF_SCROLLBAR	SBAR_ARROWS*/	/* add arrows */
/*#define DEF_SCROLLBAR	SBAR_IGNORE*/	/* no scrollbar */

#endif	/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
