	{ Ce schema decrit la presentation utilisee pour des Feuilles avec des
	pages.

	 V. Quint	      Mai 1991 }

{ Variables utilisees : LANDSCAPE, US_PAPER }

PRESENTATION Feuille;

COUNTERS

   CptFeuille: Rank of Page;

DEFAULT

   BEGIN
   HorizRef: Enclosed . HRef ;
   VertRef: * . Left;
   Width: Enclosed . Width;
   Height: Enclosed . Height;
   VertPos: Top = Previous . Bottom;
   HorizPos: Left = Enclosing . Left;
   Justify: Enclosing =;
   LineSpacing: Enclosing =;
   Visibility: Enclosing =;
   Font: Enclosing =;
   Style: Enclosing =;
   Size: Enclosing =;
   Adjust : Enclosing =;
   Indent: Enclosing =;
   Depth : 0;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Foreground: Enclosing =;
   Background: Enclosing =;
   END;

BOXES

   EspaceHautPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 0.2 cm;
	Width: 1 pt;
	VertPos: Top = Previous PAGE_BREAK . Bottom;
	HorizPos: Left = Previous PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

   EspaceBasPage:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	Height: 1 cm;
	Width: 1 pt;
	VertPos: Bottom = Next PAGE_BREAK . Top;
	HorizPos: Left = Next PAGE_BREAK . Left;
	Content: (Graphics ' ');
	END;

   PageFeuille:
	BEGIN
#ifdef LANDSCAPE
#ifdef US_PAPER
	Width: 26 cm;
	Height: 19.6 cm;
	VertPos: Top = Enclosing . Top + 1 cm;
#else
	Width: 27.7 cm;
	Height: 19 cm;
	VertPos: Top = Enclosing . Top + 1 cm;
#endif US_PAPER
	HorizPos: Left = Enclosing . Left + 1 cm;
#else LANDSCAPE
#ifdef US_PAPER
	Width: 19.6 cm;
	Height: 25.3 cm;
	HorizPos: Left = Enclosing . Left + 0.7 cm;
#else US_PAPER
	Width: 19 cm;
	Height: 27 cm;
	HorizPos: Left = Enclosing . Left + 1 cm;
#endif US_PAPER
	VertPos: Top = Enclosing . Top + 1 cm;
#endif LANDSCAPE
	IF Not One(CptFeuille) CreateBefore (EspaceBasPage);
	CreateAfter (EspaceHautPage);
	END;

RULES

   Feuille:
	BEGIN
	Page(PageFeuille);
	Size: 14 pt;
	Font: helvetica;
	Style: Roman;
	HorizPos: VMiddle = Enclosing . VMiddle;
	VertPos: Top = Enclosing . Top;
	Width : Enclosing . Width;
	Visibility: 10;
	Indent: 0;
	Justify: No;
	Adjust : Left;
	LineSpacing: 1.1;
	Foreground: Black;
	Background: White;
	END;

   Paragraphe:
	BEGIN
	Width: Enclosing . Width;
	NoBreak1: 2;
	NoBreak2: 2;
	VertPos: Top = Previous not GRAPHICS_UNIT . Bottom + 0.3;
	END;

   Image:
	BEGIN
	VertPos: Top = Previous not GRAPHICS_UNIT . Bottom + 0.3;
	HorizPos: VMiddle = Enclosing . VMiddle;
	PageBreak: No;
	Gather: Yes;
	END;

   Autre_Nature:
	BEGIN
	VertPos: Top = Previous . Bottom + 0.3;
	HorizPos: VMiddle = Enclosing . VMiddle;
	PageBreak: No;
	Gather: Yes;
	END;

   Autre :
	BEGIN
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	END;

   Indice :
	BEGIN
	PageBreak: No;
	LineBreak: No;
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	HorizRef : Enclosed . HRef - 0.3;
	Size : Enclosing -4 min 1;
	END;

   Exposant :
	BEGIN
	PageBreak: No;
	LineBreak: No;
	HorizPos : Left = Previous . Right;
	VertPos : HRef = Previous . HRef;
	HorizRef : Enclosed . HRef + 0.4;
	Size : Enclosing -4 min 1;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Width: 1 cm;
	Height: 1 cm;
	END;

   PAGE_BREAK:
	BEGIN
	Background : White;
	Foreground : Black;
	Fillpattern : nopattern;
	HorizOverflow: Yes;
	END;

ATTRIBUTES

   Plan:
	Depth : Plan;

END
