/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/* Module de construction d'une table d'index */
/* Module indtable.c */

#include "thot_sys.h"
#include "constmedia.h"
#include "typemedia.h"
#include "indmsg.h"
#include "message.h"
#include "language.h"
#include "constind.h"
#include "typeind.h"
#include "fileaccess.h"

#undef THOT_EXPORT
#define THOT_EXPORT extern
#include "index_tv.h"

#include "tree_f.h"
#include "attributes_f.h"
#include "search_f.h"
#include "spellchecker_f.h"
#include "structcreation_f.h"
#include "views_f.h"
#include "exceptions_f.h"
#include "hyphen_f.h"
#include "indmenu_f.h"
#include "indtri_f.h"
#include "indcree_f.h"
#include "memory_f.h"
#include "structmodif_f.h"
#include "changeabsbox_f.h"

#include "references_f.h"
#include "structselect_f.h"
#include "fileaccess_f.h"
#include "structschema_f.h"
#include "content_f.h"
#include "applicationapi_f.h"
#include "searchref_f.h"
#include "docs_f.h"
#include "readpivot_f.h"

/* les variables locales */
static PtrElement   pCar;	/* Car_Index en cours de construction */
static PtrElement   pElem;	/* Elem_Index en cours de construction */
static PtrElement   pEntree;	/* Entree en cours de construction */
static int          LeNiveau;	/* niveau de l'entree courante */
static PtrElement   pRefDir;	/* reference directe en cours */
static PtrElement   pRefCrois;	/* reference croisee en cours */
static PtrElement   pTable;	/* table d'index en cours */


/*----------------------------------------------------------------------
   Ind_table 
   retourne un pointeur sur les options de la table d'index      
   de rang num   du document pDocu                               
  ----------------------------------------------------------------------*/
#ifdef __STDC__
PtrElement          Ind_table (int num)
#else  /* __STDC__ */
PtrElement          Ind_table (num)
int                 num;

#endif /* __STDC__ */
{
   int                 C_PIV_TYPE;
   PtrElement          pEl = NULL;
   int                 i = 1;
   PtrSSchema          pSS;

   /* retrouver les options de la 1e table du document pDocu */
   /* element associe = Option */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDocu), "ExtIndex");
   C_PIV_TYPE = GetElemWithException (1216, pSS);
   pEl = FirstAssociatedElement (pDocu, C_PIV_TYPE, pSS);
   while (i < num && pEl != NULL)
     {
	i++;
	/* recherche en avant de la prochaine description de table */
	pEl = pEl->ElNext;
	if (pEl != NULL && pEl->ElTypeNumber != C_PIV_TYPE)
	   pEl = pEl->ElNext;
     }				/* end of while */
   return (pEl);

}				/* end of Ind_table */

#ifdef __STDC__
static int          Ind_valeur (PtrElement pEl)
#else  /* __STDC__ */
static int          Ind_valeur (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   PtrElement          pCles;
   PtrAttribute        pAttr;
   int                 attr;
   int                 ret;
   boolean             attrtrouve = FALSE;

   pCles = pEl->ElFirstChild;	/* pointeur sur l'element Cles */
   attr = GetAttrWithException (1222, pCles->ElStructSchema);
   pAttr = pCles->ElFirstAttr;
   /* parcours les atributs de l'element */
   while (!attrtrouve && pAttr != NULL)
      if (pAttr->AeAttrNum == attr && pAttr->AeAttrSSchema == pCles->ElStructSchema)
	 attrtrouve = TRUE;
      else
	 pAttr = pAttr->AeNext;
   ret = (attrtrouve) ? pAttr->AeAttrValue : 0;
   return (ret);
}				/* end of proc Ind_valeur */


/*----------------------------------------------------------------------
   Ind_marquesuivante                                                
   retourne la prochaine marque qui reference ce descripteur          
  ----------------------------------------------------------------------*/
#ifdef __STDC__
PtrElement          Ind_marquesuivante (PtrElement pDesc, PtrElement pMarque)
#else  /* __STDC__ */
PtrElement          Ind_marquesuivante (pDesc, pMarque)
PtrElement          pDesc;
PtrElement          pMarque;

#endif /* __STDC__ */
{

   PtrElement          pEl = NULL;
   PtrDocument         docsel;
   PtrReference        pRef = NULL;
   PtrExternalDoc      pDE = NULL;
   PtrAttribute        pAt1 = NULL;

   if (pMarque != NULL)
     {
	pAt1 = (PtrAttribute) Ind_TrouveRef (pMarque);
	if (pAt1 != NULL)
	   pRef = pAt1->AeAttrReference;
     }				/* end of if */
   /* recherche la marque suivante */
   /* la marque est dans le document pointe par docsel si pDE != NULL */
   /* marques ET descripteurs sont tjrs ds le meme document */
   do
     {
	pRef = NextReferenceToEl (pDesc, pDocCour, FALSE, pRef, &docsel, &pDE, TRUE);
	/* verifier si cette ref est du type A_Vers_descripteur */
	if (pRef != NULL && pRef->RdAttribute != NULL)
	  {
	     pAt1 = pRef->RdAttribute;
	     if (AttrHasException (1205, pAt1->AeAttrNum, pAt1->AeAttrSSchema))
	       {
		  pEl = pRef->RdElement;
		  pRef = 0;	/* sortie du while */
	       }
	  }			/* end of if */
     }
   while (pRef != NULL);
   return (pEl);

}				/* end proc Ind_marquesuivante */


/*----------------------------------------------------------------------
   Ind_copieliste                                                      
   recopie les elements de la liste contenue ds pElOrig du document pDocOrig 
   dans l'element pElDest du document pDocDest                             
   (auparavant vide cet element s'il n'est pas vide)                       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_copieliste (PtrElement pElOrig, PtrDocument pDocOrig, PtrElement pElDest, PtrDocument pDocDest, int niveau)
#else  /* __STDC__ */
static boolean      Ind_copieliste (pElOrig, pDocOrig, pElDest, pDocDest, niveau)
PtrElement          pElOrig;
PtrDocument         pDocOrig;
PtrElement          pElDest;
PtrDocument         pDocDest;
int                 niveau;

#endif /* __STDC__ */
{
   PtrElement          pCopie, pElContenu, pElSuiv, pEl1;
   PtrTextBuffer       pBu1;
   boolean             ret = FALSE;
   boolean             PremMot = TRUE;

   pElContenu = pElDest->ElFirstChild;
   /* supprimer le contenu de pEl s'il existe */
   if (pElContenu != NULL)
     {
	DestroyAbsBoxes (pElContenu, pDocDest, FALSE);
	AbstractImageUpdated (pDocDest);
	DeleteElement (&pElContenu);
     }
   pElSuiv = pElOrig->ElFirstChild;

   while (pElSuiv != NULL)
     {
	pCopie = CopyTree (pElSuiv, pDocOrig, pElDest->ElAssocNum,
		   pElDest->ElStructSchema, pDocDest, pElDest, TRUE, FALSE);

	/* ATTENTION : la presentation depend du type de tri choisi */
	/* il faut donc modifier le texte des feuilles de cet arbre */
	/* EN ATTENDANT QUE LE LANGAGE P LE FASSE AUTOMATIQUEMENT */
	pEl1 = FirstLeaf (pCopie);
	if (pEl1 != NULL && pEl1->ElLeafType == LtText && PremMot == TRUE)
	   /* si c'est du texte */
	  {
	     pBu1 = pEl1->ElText;
	     switch (Ipres)
		   {
		      case PMAJUSCULE:
			 /* toute la chaine est convertie en majuscule */
			 majuscule (pBu1->BuContent);
			 break;
		      case PMINUSCULE:
			 SmallLettering (pBu1->BuContent);
			 break;
		      case P1CAPITALE:
			 /* mettre une capitale initiale */
			 /* si le niveau dans l'index est 1 */
			 if (niveau < 1)
			    capital (pBu1->BuContent);
			 /* laisser les autres lettres dans leur etat initial */
			 break;
		      case PCAPITALE:
			 /* mettre une capitale initiale */
			 /* quelque soit le niveau */
			 capital (pBu1->BuContent);
			 break;
		      case PTELQUEL:
			 break;
		      default:
			 break;
		   }		/* end of switch */
	     /* pour me pas mettre de majuscule sur les autres mots */
	     PremMot = FALSE;
	  }			/* end of if pEl1 != NULL */

	if (pElDest->ElFirstChild == NULL)
	   InsertOption (pElDest, &pCopie, pDocDest);
	else
	   InsertElemAfterLastSibling (pElDest->ElFirstChild, pCopie);
	pElSuiv = pElSuiv->ElNext;
	ret = TRUE;
     }				/* end of while */
   return (ret);
}				/* end of proc Ind_copieliste */


 /*----------------------------------------------------------------------
    Ind_CreeInclusion                                                 
    si Cree = FALSE ne le cree pas - remplit seulement pEl              
    cree un element devant (ou derriere, selon Dev)                     
    l'element pointe par pEl dans le document pointe par pDoc.          
    TypeEl est le type de l'element a creer et pSS un pointeur sur le   
    schema de structure qui definit ce type.                            
    C'est toujours un element inclus qui est cree :                     
    inclusion de pEl1 du document pDoc1                                 
    Retourne un pointeur sur le premier element feuille cree, ou NULL   
    si rien n'a ete creee.                                              
   ----------------------------------------------------------------------*/
#ifdef __STDC__
static PtrElement   Ind_CreeInclusion (PtrDocument pDoc, PtrElement pEl,
				       boolean Dev, boolean Cree,
				       int TypeEl,
				       PtrSSchema pSS,
				       PtrDocument pDoc1,
				       PtrElement pEl1)
#else  /* __STDC__ */
static PtrElement   Ind_CreeInclusion (pDoc, pEl, Dev, Cree, TypeEl,
				       pSS, pDoc1, pEl1)
PtrDocument         pDoc;
PtrElement          pEl;
boolean             Dev;
boolean             Cree;
int                 TypeEl;
PtrSSchema          pSS;
PtrDocument         pDoc1;
PtrElement          pEl1;

#endif /* __STDC__ */
{

   PtrElement          pE;
   boolean             ret;

   if (Cree)
      pE = NewSubtree (TypeEl, pSS, pDoc,
		       pEl->ElAssocNum, FALSE, TRUE, TRUE, TRUE);
   else
      pE = pEl;
   /* associe un bloc reference a l'element cree' */
   GetReference (&pE->ElSource);
   if (pE->ElSource != NULL)
     {
	pE->ElSource->RdElement = pE;
	pE->ElSource->RdTypeRef = RefInclusion;
	/* lie la reference */
	ret = SetReference (pE, NULL, pEl1, pDoc, pDoc1, FALSE, FALSE);
	if (Cree)
	  {
	     if (Dev)
		/* insere devant pEl */
		InsertElementBefore (pEl, pE);
	     else
		/* insere apres pEl */
		InsertElementAfter (pEl, pE);
	  }
	/* l'element a inclure est connu, on le copie */
	CopyIncludedElem (pE, pDoc);
	DocumentModified (pDoc, pE);
     }
   return (pE);

}				/* end of proc Ind_CreeInclusion */


/*----------------------------------------------------------------------
   Ind_copietitre                                                    
   recopie le contenu de champ Idx_Titre de la definition pDefTable 
   dans le contenu de pEl (Titre_Index) 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_copietitre (PtrElement pEl)
#else  /* __STDC__ */
static boolean      Ind_copietitre (pEl)
PtrElement          pEl;

#endif /* __STDC__ */

{
   PtrElement          pEl1;
   boolean             ret = FALSE;
   int                 C_PIV_TYPE;

   pEl1 = pDefTable->ElFirstChild;
   if (pEl1 != NULL && pEl1->ElVolume != 0)
      /* Table d'index et options sont dans le meme document : pDocu */
     {
	/* creer un Titre_Index dans la table pTable (copie par inclusion) */
	C_PIV_TYPE = GetElemWithException (1275, pEl1->ElStructSchema);
	Ind_CreeInclusion (pDocu, pEl, FALSE, FALSE, C_PIV_TYPE, pEl->ElStructSchema, pDocu, pEl1);
	ret = TRUE;
     }
   return (ret);
}				/* end of Ind_copietitre */


/*----------------------------------------------------------------------
   Ind_copieintro                                                    
   recopie le contenu de Idx_Intro (s'il existe) de la definition pDefTable 
   dans Intro_Index de la table d'index pointee par pTable 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_copieintro ()
#else  /* __STDC__ */
static void         Ind_copieintro ()
#endif				/* __STDC__ */
{
   PtrElement          pEl1;
   int                 C_PIV_TYPE;

   /* existe-t-il un Idx_Intro prevu pour cette table ? */
   C_PIV_TYPE = GetElemWithException (1268, pDefTable->ElStructSchema);
   pEl1 = FwdSearchTypedElem (pDefTable, C_PIV_TYPE, pDefTable->ElStructSchema);
   if (pEl1 != NULL && (pEl1->ElParent == pDefTable) && pEl1->ElVolume != 0)
     {
	/* creer un Intro_Index dans la table pTable (copie par inclusion) */
	C_PIV_TYPE = GetElemWithException (1271, pTable->ElStructSchema);
	Ind_CreeInclusion (pDocu, pTable->ElFirstChild, FALSE, TRUE,
			   C_PIV_TYPE, pTable->ElStructSchema,
			   pDocu, pEl1);

     }
}				/* end of Ind_copieintro */


/*----------------------------------------------------------------------
   Ind_copieterme                                                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_copieterme (PtrElement pTerme, int indice, int niveau)
#else  /* __STDC__ */
static void         Ind_copieterme (pTerme, indice, niveau)
PtrElement          pTerme;
int                 indice;
int                 niveau;

#endif /* __STDC__ */
{

/* recopie le contenu de champ Cle de ce niveau                  */
/* du descripteur pointe par pTri[indice]->refdesc               */
/* dans le contenu de pTerme                                     */
/* en appliquant la presentation demandee : capitale, maj, min.. */
   PtrElement          pEl;
   PtrTabTri           pTT;
   int                 ret;
   int                 i = 0;

   pTT = pTri[indice];
   pEl = pTT->refdesc->ElFirstChild->ElFirstChild;	/* cle de niveau 1 */
   if (niveau > 0)
      do
	{
	   pEl = pEl->ElNext;
	   i++;
	}
      while (i < niveau && pEl != NULL);
   /* recopier cette cle du document en cours dans le terme de la table index */
   if (pEl != NULL)
      ret = Ind_copieliste (pEl, pDocCour, pTerme, pDocu, niveau);

}				/* end of Ind_copieterme */


/*----------------------------------------------------------------------
   Ind_commentaire                                                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_commentaire (PtrElement pTerme, int indice)
#else  /* __STDC__ */
static boolean      Ind_commentaire (pTerme, indice)
PtrElement          pTerme;
int                 indice;

#endif /* __STDC__ */
{

   PtrElement          pEl, pDesc;
   int                 C_PIV_TYPE;
   boolean             ret = FALSE;
   PtrTabTri           pTT;

   /* y-a-t-il une Glose  dans le Descripteur  ? */
   pTT = pTri[indice];
   pDesc = pTT->refdesc;

   C_PIV_TYPE = (int) GetElemWithException (1228, pDesc->ElStructSchema);
   pEl = FwdSearchTypedElem (pDesc, C_PIV_TYPE, pDesc->ElStructSchema);

   /* pEl pointeur sur la Glose de ce Descripteur */
   if ((pEl != NULL) && (pEl->ElParent == pDesc))
     {
	/* verifier si le terme n'a pas deja un commentaire dans l'Index */
	C_PIV_TYPE = (int) GetElemWithException (1249, pTerme->ElStructSchema);
	if (pTerme->ElNext == NULL || pTerme->ElNext->ElTypeNumber != C_PIV_TYPE)
	  {
	     /* creer un Commentaire apres le Terme de cette Entree */
	     /* copie par inclusion */
	     /* attention si descripteur et index ds doc different */
	     Ind_CreeInclusion (pDocu, pTerme, FALSE, TRUE,
				C_PIV_TYPE, pTerme->ElStructSchema,
				pDocCour, pEl);

	     /* recopier le contenu de Glose (pEl) - non vide -  */
	     /* dans le contenu de Commentaire (pEl1) - inexistant - */
	  }
	else
	   ret = FALSE;		/* il y avait deja un commentaire */
     }
   else
      ret = FALSE;
   return (ret);
}				/* end of Ind_commentaire */


/*----------------------------------------------------------------------
   rempli le buffer texte de pEl avec la chaine = 1 caractere MAX 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         remplir_car (PtrElement pEl, char *chaine)
#else  /* __STDC__ */
static void         remplir_car (pEl, chaine)
PtrElement          pEl;
char               *chaine;

#endif /* __STDC__ */
{

   PtrElement          pEl1;
   PtrTextBuffer       pBu1;
   int                 lgchaine;

   pEl1 = pEl;
   pBu1 = pEl1->ElText;
   pBu1->BuContent[0] = chaine[0];
   lgchaine = 1;
   pEl1->ElTextLength = lgchaine;
   pEl1->ElVolume = pEl1->ElTextLength;
   pEl1->ElText->BuLength = lgchaine;
   /* ajoute le volume de l'element a celui de ses ascendants */
   if (pEl1->ElVolume != 0)
     {
	pEl = pEl1->ElParent;
	while (pEl != NULL)
	  {
	     pEl->ElVolume = pEl->ElVolume + pEl1->ElVolume;
	     pEl = pEl->ElParent;
	  }
     }
}				/* end of remplir_car */


#ifdef __STDC__
static void         ajouter_car (char *initiale)
#else  /* __STDC__ */
static void         ajouter_car (initiale)
char               *initiale;

#endif /* __STDC__ */
{
   PtrElement          pEl1, pEl;
   int                 C_PIV_TYPE;

   /* pCar = pointeur sur le Car_Index */
   C_PIV_TYPE = (int) GetElemWithException (1250, pTable->ElStructSchema);
   /* pEl = pointeur sur le prochain Car */
   pEl = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu, pTable->ElAssocNum,
		     TRUE, TRUE, TRUE, TRUE);
   /* l'inserer apres le dernier Car existant dans Car_Index */
   InsertElemAfterLastSibling (pCar->ElFirstChild->ElFirstChild, pEl);
   DocumentModified (pDocu, pEl);
   /* pEl1 = pointeur sur le texte de Car */
   pEl1 = pEl->ElFirstChild;
   /* recopier l'initiale dans le buffer de cet element */
   remplir_car (pEl1, initiale);
}				/* end of ajouter_car */


/*----------------------------------------------------------------------
   creer une nouvelle initiale dans la table d'index pTable 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         creer_car (char *initiale)
#else  /* __STDC__ */
static void         creer_car (initiale)
char               *initiale;

#endif /* __STDC__ */
{

   PtrElement          pC, pEl1, pEl;
   int                 C_PIV_TYPE;

   C_PIV_TYPE = (int) GetElemWithException (1270, pTable->ElStructSchema);
   pEl = FwdSearchTypedElem (pTable, C_PIV_TYPE, pTable->ElStructSchema);	/* Contenu_Index */

   if (pEl->ElFirstChild->ElFirstChild->ElFirstChild->ElFirstChild->ElVolume == 0)
     {				/* remplir le premier Car_Index */
	pC = pEl->ElFirstChild;	/* pointeur sur le premier Car_Index */
     }
   else
     {
	/* creer un nouveau Car_Index */
	C_PIV_TYPE = (int) GetElemWithException (1242, pTable->ElStructSchema);
	pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu, pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	/* l'inserer apres le dernier Car_Index existant */
	InsertElemAfterLastSibling (pEl->ElFirstChild, pC);
	DocumentModified (pDocu, pC);
     }

   /* pEl1 pointeur sur l'element texte de Car */
   pEl1 = pC->ElFirstChild->ElFirstChild->ElFirstChild;
   /* recopier l'initiale dans le buffer de cet element */
   remplir_car (pEl1, initiale);
   /* conserver un pointeur sur ce Car_Index */
   pCar = pC;
}				/* end of creer_car */


#ifdef __STDC__
static void         creer_elem (int indice)
#else  /* __STDC__ */
static void         creer_elem (indice)
int                 indice;

#endif /* __STDC__ */
{

   PtrElement          pC, pEl1, pEl;
   int                 C_PIV_TYPE;
   PtrAttribute        pAt1;
   PtrTabTri           pTT;

   pTT = pTri[indice];
   /* ajouter un nouvel element dans la table d'index */
   /* en utilisant pCar = pointeur sur le Car_Index courant */

   pEl = pCar->ElFirstChild->ElNext;	/* Contenu_Car */
   if (pEl->ElFirstChild->ElFirstChild->ElFirstChild->ElFirstChild->ElVolume == 0)
     {				/* remplir le premier Elem_Index */
	pC = pEl->ElFirstChild;	/* pointeur sur le premier Elem_Index */
     }
   else
     {
	/* creer un nouvel Elem_Index */
	C_PIV_TYPE = (int) GetElemWithException (1240, pEl->ElStructSchema);
	pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			 pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	/* l'inserer apres le dernier Elem_Index existant */
	InsertElemAfterLastSibling (pEl->ElFirstChild, pC);
	DocumentModified (pDocu, pC);
     }
   /* pEl1 pointeur sur le Terme */
   pEl1 = pC->ElFirstChild->ElFirstChild;
   Ind_copieterme (pEl1, indice, 0);	/* niveau 0 */

   /* appliquer l'attribut Level = attribut Pres_Sujet sur le sujet */
   pAt1 = AttachAttrByExceptNum (1272, pC->ElFirstChild->ElFirstChild, NULL, pDocu);
   pAt1->AeAttrValue = pTT->pres;	/* 1, 2, 3 ou 4 */

   if (pTT->cle[1][0] == '\0')	/* placer le commentaire eventuel */
      Ind_commentaire (pEl1, indice);
   pRefDir = NULL;
   pRefCrois = NULL;

   /* conserver un pointeur sur cet Elem_Index */
   pElem = pC;
   pEntree = pElem->ElFirstChild;
   LeNiveau = 0;		/* niveau courant de la premiere entree */
}				/* end of creer_elem */


#ifdef __STDC__
static void         creer_entree (int niveau, int indice)
#else  /* __STDC__ */
static void         creer_entree (niveau, indice)
int                 niveau;
int                 indice;

#endif /* __STDC__ */
{

   PtrElement          pC, pEl1;
   int                 exceptnum;
   int                 C_PIV_TYPE;
   boolean             change;
   PtrAttribute        pAt1;
   PtrTabTri           pTT;

   pTT = pTri[indice];
   change = FALSE;
   while (niveau > LeNiveau)
     {
	/* on descend d'un niveau */
	/* creer une suite a l'entree courante */
	exceptnum = niveau + 1250;	/* numeros d'exception : 1251 a 1253 */
	C_PIV_TYPE = (int) GetElemWithException (exceptnum, pTable->ElStructSchema);
	pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu, pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	InsertElementAfter (pEntree, pC);
	DocumentModified (pDocu, pC);
	pEntree = pC->ElFirstChild->ElFirstChild;
	LeNiveau++;
	change = TRUE;
     }				/* end of while */

   if (niveau < LeNiveau)
     {
	/* remonter d'un ou plusieurs niveaux */
	while (niveau < LeNiveau)
	  {
	     pEntree = pEntree->ElParent->ElParent->ElPrevious;
	     LeNiveau--;
	  }
     }
   if ((!change) && (niveau == LeNiveau))
     {
	/* ajouter une nouvelle Entree de ce niveau */
	pC = NewSubtree (pEntree->ElParent->ElTypeNumber, pTable->ElStructSchema, pDocu,
			 pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	InsertElemAfterLastSibling (pEntree->ElParent, pC);
	DocumentModified (pDocu, pC);
	pEntree = pC->ElFirstChild;
     }

   /* remplir le terme de pEntree */
   /* pEl1 pointeur sur Terme */
   pEl1 = pEntree->ElFirstChild;
   Ind_copieterme (pEl1, indice, niveau);

   /* appliquer l'attribut Level = attribut Pres_Sujet sur le sujet */
   pAt1 = AttachAttrByExceptNum (1272, pEntree->ElFirstChild, NULL, pDocu);
   pAt1->AeAttrValue = pTT->pres;	/* 1, 2, 3 ou 4 */

   if ((niveau == MaxNiveau)
       || (pTT->cle[niveau + 1][0] == '\0'))
      /* inserer le commentaire eventuel */
      Ind_commentaire (pEl1, indice);
   pRefDir = NULL;
   pRefCrois = NULL;
}				/* end of creer_entree */


#ifdef __STDC__
static void         ajouter_ref (int ind, boolean avec_fusion)
#else  /* __STDC__ */
static void         ajouter_ref (ind, avec_fusion)
int                 ind;
boolean             avec_fusion;

#endif /* __STDC__ */
{

   PtrElement          pC, pElRef, pEl, pEl1;
   int                 C_PIV_TYPE;
   int                 lgpage, valforce, indice;
   PtrTextBuffer       pBu1;
   boolean             ret, intervalle = FALSE;
   PtrAttribute        pAt1;
   PtrTabTri           pTT, pTT1;

   pEl = NULL;
   indice = tab_ind[ind];
   pTT = pTri[indice];
   valforce = Ind_valeur (pTT->refdesc);	/* 0, 1 ou 2 */

   /* Faut-il inserer un commentaire apres le terme ? */
   Ind_commentaire (pEntree->ElFirstChild, indice);

   if ((pRefDir == NULL) && (pRefCrois == NULL))
     {
	/* creer une nouvelle Liste_des_Ref => pEl */
	C_PIV_TYPE = (int) GetElemWithException (1248, pTable->ElStructSchema);
	pEl = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			  pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	InsertElemAfterLastSibling (pEntree->ElFirstChild, pEl);
	DocumentModified (pDocu, pEl);
     }
   if (pTT->page != -1)
     {				/* c'est une reference directe */
	if (pRefDir == NULL)
	  {
	     /* creer une nouvelle Liste_Directe => pC */
	     C_PIV_TYPE = (int) GetElemWithException (1243, pTable->ElStructSchema);
	     pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     InsertFirstChild (pEl, pC);
	     DocumentModified (pDocu, pC);
	     pRefDir = pC->ElFirstChild;
	  }
	else
	  {
	     if (avec_fusion == TRUE)
	       {
		  pTT1 = pTri[tab_ind[ind - 1]];
		  if (pTT->page == pTT1->page && pTT->pagefin == pTT1->pagefin)
		     return;
	       }
	     /* ajouter une nouvelle RefDirecte dans la liste */
	     pC = NewSubtree (pRefDir->ElTypeNumber, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     InsertElementAfter (pRefDir, pC);
	     DocumentModified (pDocu, pC);
	     pRefDir = pC;
	  }
	if (pTT->page != pTT->pagefin)
	  {
	     /* c'est un intervalle */
	     C_PIV_TYPE = (int) GetElemWithException (1259, pTable->ElStructSchema);
	     pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     InsertFirstChild (pRefDir->ElFirstChild, pC);
	     DocumentModified (pDocu, pC);
	     pEl1 = FirstLeaf (pRefDir);
	     intervalle = TRUE;
	  }
	else
	  {
	     /* c'est une reference simple (pas un intervalle) */
	     if (pTT->note != 0)
	       {
		  /* il faut ajouter un numero de note avant le numero de page */
		  C_PIV_TYPE = (int) GetElemWithException (1273, pTable->ElStructSchema);
		  pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
				   pTable->ElAssocNum, TRUE, TRUE,
				   TRUE, TRUE);
		  InsertFirstChild (pRefDir, pC);
		  DocumentModified (pDocu, pC);
		  /* remplir le numero de la note */
		  pEl1 = FirstLeaf (pC);
		  CreateTextBuffer (pEl1);
		  pBu1 = pEl1->ElText;
		  /* convertir tab_note[indice] en caractere */
		  sprintf (pBu1->BuContent, "%d", pTT->note);
		  lgpage = strlen (pBu1->BuContent);
		  pBu1->BuContent[lgpage] = '\0';
		  pEl1->ElTextLength = lgpage;
		  pEl1->ElVolume = pEl1->ElTextLength;
		  pEl1->ElText->BuLength = lgpage;
	       }		/*  end of if */
	     /* ajouter le numero de page */
	     C_PIV_TYPE = (int) GetElemWithException (1245, pTable->ElStructSchema);
	     pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     if (pTT->note == 0)
		InsertFirstChild (pRefDir->ElFirstChild, pC);
	     else
		InsertFirstChild (pRefDir->ElFirstChild->ElNext, pC);
	     DocumentModified (pDocu, pC);
	     pEl1 = FirstLeaf (pC);
	  }			/* end of else */

	/* remplir le numero de la page initiale */
	CreateTextBuffer (pEl1);
	pBu1 = pEl1->ElText;
	/* convertir tab_page[indice] en caractere */
	sprintf (pBu1->BuContent, "%d", pTT->page);
	lgpage = strlen (pBu1->BuContent);
	pBu1->BuContent[lgpage] = '\0';
	pEl1->ElTextLength = lgpage;
	pEl1->ElVolume = pEl1->ElTextLength;
	pEl1->ElText->BuLength = lgpage;

	/* mettre l'attribut Vers_marque = reference vers la marque_debut */
	pEl = pTT->refmarque;
	/* est-ce une ref externe ? */
	if (pDocu == pDocCour)
	   pAt1 = AttachAttrByExceptNum (1255, pC, pEl, pDocu);
	else
	  {
	     pAt1 = AttachAttrByExceptNum (1255, pC, NULL, pDocu);
	     ret = SetReference (NULL, pAt1, pEl, pDocu, pDocCour, TRUE, FALSE);
	  }			/* end of else */
	if (intervalle)
	  {
	     /* remplir le numero de page finale */
	     pEl1 = pEl1->ElParent->ElNext->ElFirstChild;	/* NextElement(pEl1) ? */
	     CreateTextBuffer (pEl1);
	     pBu1 = pEl1->ElText;
	     /* convertir tab_pagefin[indice] en caractere */
	     sprintf (pBu1->BuContent, "%d", pTT->pagefin);
	     lgpage = strlen (pBu1->BuContent);
	     pBu1->BuContent[lgpage] = '\0';
	     pEl1->ElTextLength = lgpage;
	     pEl1->ElVolume = pEl1->ElTextLength;
	     pEl1->ElText->BuLength = lgpage;

	     /* mettre l'attribut Vers_marque_fin = reference(marque_fin)  */
	     pEl = GetOtherPairedElement (pTT->refmarque);
	     /* est-ce une ref externe ? */
	     if (pDocu == pDocCour)
		pAt1 = AttachAttrByExceptNum (1256, pEl1->ElParent, pEl, pDocu);
	     else
	       {
		  pAt1 = AttachAttrByExceptNum (1256, pEl1->ElParent, NULL, pDocu);
		  ret = SetReference (NULL, pAt1, pEl, pDocu, pDocCour,
				      TRUE, FALSE);
	       }		/* end of else */
	  }

	/* mettre l'attribut Force sur PageUnique ou PageIntervalle */
	/* pointe par pRefDir->ElFirstChild->ElFirstChild */
	pAt1 = AttachAttrByExceptNum (1247, pRefDir->ElFirstChild->ElFirstChild, NULL, pDocu);
	pAt1->AeAttrValue = valforce;
	DocumentModified (pDocu, pRefDir->ElFirstChild->ElFirstChild);
	/* remplir l'element reference Vers_descripteur */
	/* Vers_descripteur = CsReference(Cles (RefDesc)) */
	C_PIV_TYPE = (int) GetElemWithException (1274, pTable->ElStructSchema);		/* Vers_descripteur */
	pElRef = FwdSearchTypedElem (pRefDir, C_PIV_TYPE, pTable->ElStructSchema);	/* a remplir */
	pEl = pTT->refdesc;
	ret = SetReference (pElRef, NULL, pEl->ElFirstChild, pDocu, pDocCour,
			    TRUE, FALSE);
     }
   else
     {				/* c'est une reference croisee */
	if (pRefCrois == NULL)
	  {
	     /* creer une nouvelle Liste_Croisee */
	     C_PIV_TYPE = (int) GetElemWithException (1244, pTable->ElStructSchema);
	     pC = NewSubtree (C_PIV_TYPE, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     if (pRefDir != NULL)
		InsertElementAfter (pRefDir->ElParent, pC);
	     else
		InsertFirstChild (pEl, pC);
	     DocumentModified (pDocu, pC);
	     pRefCrois = pC->ElFirstChild;
	  }
	else
	  {
	     /* ajouter une nouvelle RefCroisee dans la liste */
	     pC = NewSubtree (pRefCrois->ElTypeNumber, pTable->ElStructSchema, pDocu,
			      pTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     InsertElementAfter (pRefCrois, pC);
	     DocumentModified (pDocu, pC);
	     pRefCrois = pC;
	  }
	/* mettre l'attribut Force sur la reference croisee RefCr */
	pAt1 = AttachAttrByExceptNum (1247, pRefCrois->ElFirstChild, NULL, pDocu);
	pAt1->AeAttrValue = valforce;
	DocumentModified (pDocu, pRefCrois->ElFirstChild);

	/* remplir l'element reference Vers_croisee */
	/* Vers_croise = CsReference(CCles (RefCrois)) */
	pElRef = pRefCrois->ElFirstChild->ElNext;
	pEl = pTT->refdesc;
	ret = SetReference (pElRef, NULL, pEl->ElFirstChild, pDocu, pDocCour,
			    TRUE, FALSE);
     }
}				/* end of ajouter_ref */


/*----------------------------------------------------------------------
   Ind_creertable                                                    
   initialise pTable et copie le titre                        
   retourne 1 si un nouvel element associe est cree           
   retourne 0 si pTable est cree est cree sans nouvel associe 
   retourne -1 en cas d'erreur (cree une table vide)          
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_creertable (int numtable, boolean avec_raz)
#else  /* __STDC__ */
int                 Ind_creertable (numtable, avec_raz)
int                 numtable;
boolean             avec_raz;

#endif /* __STDC__ */
{

   PtrElement          pTitre, pElem, pNouveau, pEl1, pEl2;
   PtrTextBuffer       pBu1;
   int                 C_PIV_TYPE;
   PtrAttribute        pAt1;
   PtrSSchema          pSS;
   int                 lgmot;
   boolean             ret = FALSE;
   int                 iret = 0;	/* ajout d'une table */

   pTable = NULL;
   /* verifier s'il existe deja un element associe RefIndex */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDocu), "ExtIndex");
   C_PIV_TYPE = (int) GetElemWithException (1213, pSS);
   pFirstTable = FirstAssociatedElement (pDocu, C_PIV_TYPE, pSS);
   if (pFirstTable == NULL)
     {
	/* creer un element associe Index */
	pFirstTable = CreateFirstAssocElement (pDocu, C_PIV_TYPE, pSS);
	pTable = pFirstTable;	/* c'est la premiere table */
	/* Met en Read Only la racine des tables d'index */
	pFirstTable->ElParent->ElAccess = AccessReadOnly;
	iret = 1;		/* creation d'un nouvel el associe index */
     }
   else
     {
	if (avec_raz == TRUE)
	  {
	     /* d'abord : supprimer les anciennes tables */
	     pElem = pFirstTable->ElParent;	/* le pere de toutes les tables */
	     /* Met en Read Only la racine des tables d'index */
	     pElem->ElAccess = AccessReadOnly;
	     pElem = pElem->ElFirstChild;	/* saut de page ou prem table */
	     while (pElem != NULL)
	       {
		  pNouveau = NextElement (pElem);
		  DestroyAbsBoxes (pElem, pDocu, FALSE);
		  AbstractImageUpdated (pDocu);
		  DeleteElement (&pElem);
		  pElem = pNouveau;
	       }
	     /* ensuite : creer la premiere table associee */
	     pFirstTable = CreateFirstAssocElement (pDocu, C_PIV_TYPE, pSS);
	     pTable = pFirstTable;
	     iret = 1;
	  }
	else
	  {			/* ajouter une table associee */
	     pTable = NewSubtree (C_PIV_TYPE, pFirstTable->ElStructSchema, pDocu,
			   pFirstTable->ElAssocNum, TRUE, TRUE, TRUE, TRUE);
	     /* la placer apres les autres tables associees */
	     InsertElemAfterLastSibling (pFirstTable, pTable);
	     DocumentModified (pDocu, pTable);
	  }
     }				/* end of else */



   /* mettre l'attribut Pres_Ref sur cette table */
   pAt1 = AttachAttrByExceptNum (1257, pTable, NULL, pDocu);
   pAt1->AeAttrValue = (Iparpage) ? 1 : 2;

   /* mettre l'attribut Pres_Groupe sur cette table */
   pAt1 = AttachAttrByExceptNum (1258, pTable, NULL, pDocu);
   pAt1->AeAttrValue = (Igroupe) ? 1 : 2;

   /* remplir le titre de cette table */
   pTitre = pTable->ElFirstChild;
   ret = Ind_copietitre (pTitre);

   if (!ret || pTitre->ElVolume == 0)
     {				/* remplir le titre par defaut */
	pEl2 = pTitre->ElFirstChild;	/* le contenu vide du titre */
	if (pEl2 != NULL)
	  {			/* creer la nouvelle feuille de texte dans ce contenu */
	     pEl1 = NewSubtree (CharString + 1, pTable->ElStructSchema, pDocu,
				pTable->ElAssocNum,
				TRUE, TRUE, TRUE, TRUE);
	     InsertOption (pEl2, &pEl1, pDocu);		/* inserer la feuille de texte */
	     pEl1->ElTerminal = TRUE;
	     pEl1->ElVolume = 0;
	     CreateTextBuffer (pEl1);
	     pBu1 = pEl1->ElText;
	     /* Titre par defaut */
	     lgmot = strlen (TtaGetMessage (INDEX, ID_Titre));
	     strcpy (pBu1->BuContent, TtaGetMessage (INDEX, ID_Titre));
	     pBu1->BuContent[lgmot] = '\0';
	     pEl1->ElTextLength = lgmot;
	     pEl1->ElVolume = pEl1->ElTextLength;
	     pEl1->ElText->BuLength = lgmot;
	     pEl1->ElLanguage = TtaGetDefaultLanguage ();;
	     /* ajoute le volume de l'element a celui de ses ascendants */
	     if (pEl1->ElVolume != 0)
	       {
		  pElem = pEl1->ElParent;
		  while (pElem != NULL)
		    {
		       pElem->ElVolume = pElem->ElVolume + pEl1->ElVolume;
		       pElem = pElem->ElParent;
		    }		/* end of while */
	       }		/* end of if */
	  }
	else
	  {
	     TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_OPTIONS), numtable);
	     return (-1);
	  }
     }

   /* ajouter les paragraphes de l'introduction eventuelle */
   Ind_copieintro ();
   if (ret != TRUE)
      iret = -1;
   return (iret);
}				/* end of Ind_creertable */


/*----------------------------------------------------------------------
   Ind_remplirtable                                                  
   ATTENTION : prevu pour remplir au maximum 3 niveaux de cle    
   si avec_fusion = TRUE  seules les pages identiques sont fusionnees 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_remplirtable (boolean avec_fusion)
#else  /* __STDC__ */
void                Ind_remplirtable (avec_fusion)
boolean             avec_fusion;

#endif /* __STDC__ */
{

   int                 ind, homo;
   int                 j = 0;
   int                 oldhomo = 0;	/* controle des homographes */
   char               *cle0;
   char               *cle1;
   char               *cle2;
   char               *oldcle0 = '\0';
   char               *oldcle1 = '\0';
   char               *oldcle2 = '\0';
   unsigned char       c = '\0';	/* initiale courante en minuscule */
   unsigned char       MAJc = '\0';	/* initiale courante en capitale */
   unsigned char       MAJfinc = '\0';	/* initiale finale en capitale */
   unsigned char       premcar = '\0';
   PtrTabTri           pTT;

   ind = tab_ind[j];		/* indice dans tab_cle */
   /* et remplir pDocCour */
   pTT = pTri[ind];
   pDocCour = pTT->doc;

   while (j <= itabcle)
     {
	cle0 = pTT->cle[0];
	cle1 = pTT->cle[1];
	cle2 = pTT->cle[2];
	homo = pTT->homo;
	premcar = cle0[0];
	if (TriPrem[premcar] != TriPrem[c])
	  {
	     c = premcar;	/* Initiale suivante */
	     /* presenter le titre du groupe d'entree comme il faut !!! */
	     MAJc = TriCap[c];
	     creer_car (&MAJc);
	     creer_elem (ind);	/* et Entree0 */
	     oldhomo = homo;
	     oldcle0 = cle0;
	     oldcle1 = NULL;
	     oldcle2 = NULL;
	  }
	else
	  {
	     if (TriCap[premcar] != TriCap[c])
		/* ajouter cette initiale dans l'intervalle */
	       {
		  MAJfinc = TriCap[premcar];
		  ajouter_car (&MAJfinc);
		  c = premcar;	/* ATTENTION : nouvelle initiale courante */
	       }
	     if (codecmp (oldcle0, cle0, 1) != 0
		 || oldhomo != pTT->homo)	/* Elem_Index suivant */
	       {
		  creer_elem (ind);	/* et Entree0 */
		  oldcle0 = cle0;
		  oldcle1 = NULL;
		  oldcle2 = NULL;
		  oldhomo = homo;
	       }
	  }
	if (cle1[0] != '\0')
	  {
	     if (oldcle1 == NULL
		 || codecmp (oldcle1, cle1, 1) != 0
		 || oldhomo != homo)	/* Entree1 */
	       {
		  creer_entree (1, ind);
		  oldcle1 = cle1;
		  oldcle2 = NULL;
		  oldhomo = homo;
	       }
	     if (cle2[0] != '\0')
	       {
		  if (oldcle2 == NULL
		      || codecmp (oldcle2, cle2, 1) != 0
		      || oldhomo != homo)	/* Entree2 */
		    {
		       creer_entree (2, ind);
		       oldcle2 = cle2;
		       oldhomo = homo;
		    }
	       }
	  }
	ajouter_ref (j, avec_fusion);
	j++;
	if (j <= itabcle)
	  {
	     ind = tab_ind[j];
	     /* et remplir pDocCour */
	     pTT = pTri[ind];
	     pDocCour = pTT->doc;
	     while (codecmp (cle0, pTT->cle[0], 1) == 0
		    && codecmp (cle1, pTT->cle[1], 1) == 0
		    && codecmp (cle2, pTT->cle[2], 1) == 0
		    && homo == pTT->homo
		    && j <= itabcle)
	       {
		  ajouter_ref (j, avec_fusion);
		  j++;
		  if (j <= itabcle)
		    {
		       ind = tab_ind[j];
		       /* et remplir pDocCour */
		       pTT = pTri[ind];
		       pDocCour = pTT->doc;
		    }
	       }		/* end of while */
	  }			/* end of if */
     }				/* of while (j <= itabcle) */

}				/* end of Ind_remplirtable */


/*----------------------------------------------------------------------
   Ind_remplirCR                                                     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_remplirCR ()
#else  /* __STDC__ */
void                Ind_remplirCR ()
#endif				/* __STDC__ */
{

   PtrDocument         docsel;
   PtrExternalDoc      pDE;
   PtrElement          pEl1, pRenvoi, pDesc, pEl, pMarque;
   PtrReference        pRef;
   int                 C_PIV_TYPE, RType;
   boolean             ret, trouve, stop;
   DocumentIdentifier  NomDoc;

   /* rechercher toutes les RefCr a remplir dans la table d'index */
   C_PIV_TYPE = (int) GetElemWithException (1254, pTable->ElStructSchema);
   pEl1 = FwdSearchTypedElem (pTable, C_PIV_TYPE, pTable->ElStructSchema);	/* RefCr */
   while (pEl1 != NULL)
     {
	trouve = FALSE;
	stop = FALSE;
	/* retrouver l'entree correspondante dans la table d'index */
	pRef = pEl1->ElNext->ElReference;
	/* retrouve aussi les ref externes */
	pEl = ReferredElement (pRef, &NomDoc, &pDocCour);	/* modifie pDocCour */
	pEl = pEl->ElFirstChild;	/* CCles (9) */

	RType = (int) GetElemWithException (1230, pEl->ElStructSchema);
	pRenvoi = FwdSearchTypedElem (pEl, RType, pEl->ElStructSchema);		/* Renvoi (16) */
	if (pRenvoi != NULL)
	  {
	     /* ICI croise vers descripteur (toujours ref interne ???)  */
	     pRef = pRenvoi->ElReference;	/* Cles de RefDesc (9) */
	     pDesc = ReferredElement (pRef, &NomDoc, &docsel);
	     if (pDesc != NULL)
	       {
		  pDesc = pDesc->ElParent;	/* le descripteur <- CCles */
		  /* remonter la reference issue de marque-debut dans pDocCour */
		  pMarque = Ind_marquesuivante (pDesc, NULL);
		  /* verifier que la ref croisee est definie dans cette table */
		  if (pMarque->ElReferredDescr != NULL)
		    {
		       /* remonter la reference Vers_marque issue de RefDirecte */
		       pDE = NULL;
		       pRef = NextReferenceToEl (pMarque, pDocCour, FALSE, NULL, &docsel, &pDE, TRUE);
		       pEl = pRef->RdElement;
		       while (pEl != NULL && !trouve)
			 {
			    if (ElemIsWithinSubtree (pEl, pTable) != TRUE)
			      {
				 /* passer a la reference suivante */
				 pRef = NextReferenceToEl (pMarque, pDocCour, FALSE,
						 pRef, &docsel, &pDE, TRUE);
				 pEl = (pRef != NULL) ? pRef->RdElement : NULL;
			      }
			    else
			      {
				 trouve = TRUE;
				 /* retrouver l'entree correspondante */
				 if (TypeHasException (1245, pEl->ElTypeNumber, pEl->ElStructSchema))
				    /* reference depuis PageUnique */
				    pEl = pEl->ElParent->ElParent->ElParent->ElParent->ElParent;
				 else
				   {
				      if (TypeHasException (1246, pEl->ElTypeNumber, pEl->ElStructSchema))
					 /* reference depuis PgBegin */
					 pEl = pEl->ElParent->ElParent->ElParent->ElParent->ElParent->ElParent;
				   }
			      }	/* end of else */
			 }	/* end of while */
		    }
	       }
	  }
	if (trouve)
	  {
	     /* pEl = pointeur sur Entree */
	     /* remplir la ref INTERNE dans la table d'index ou de master */
	     ret = SetReference (pEl1, NULL, pEl, pDocu, pDocu, TRUE, FALSE);
	  }			/* end of if */
	else
	   /* un renvoi dans une ref croisee echoue */
	   TtaDisplaySimpleMessage (INFO, INDEX, INDEX_CROISES);
	/* passer a la RefCr suivante */
	pEl1 = FwdSearchTypedElem (pEl1, C_PIV_TYPE, pTable->ElStructSchema);
     }				/* end of while */
}				/* end of proc Ind_remplirCR */


/*----------------------------------------------------------------------
   Ind_differtext                                                
   retourne Faux  si les feuilles de texte contenues dans   
   les elements pEl1 et pEl2 ont meme contenu            
   retourne Vrai sinon                                      
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_differtext (PtrElement pEl1, PtrElement pEl2)
#else  /* __STDC__ */
static boolean      Ind_differtext (pEl1, pEl2)
PtrElement          pEl1;
PtrElement          pEl2;

#endif /* __STDC__ */
{

   PtrElement          pElem1, pElem2;
   boolean             differ = TRUE;

   pElem1 = FirstLeaf (pEl1);
   pElem2 = FirstLeaf (pEl2);
   if (pElem1 != NULL && pElem2 != NULL)
     {				/* = 0 si les chaines sont egales */
	differ = strcmp (pElem1->ElText->BuContent, pElem2->ElText->BuContent);
     }
   return (differ);
}				/* end of proc Ind_differtext */


/*----------------------------------------------------------------------
   Ind_note                                                          
   retourne un pointeur sur la note contenant cet element              
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static PtrElement   Ind_note (PtrElement pEl)
#else  /* __STDC__ */
static PtrElement   Ind_note (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   PtrElement          pEl1;
   int                 C_PIV_TYPE;
   PtrSSchema          pSS;

   /* type Note dans le schema du document */
   pSS = pDocCour->DocSSchema;
   C_PIV_TYPE = (int) GetElemWithException (1217, pSS);
   /* recherche la racine de pEl */
   pEl1 = pEl->ElParent;
   while (pEl1 != NULL && !(pEl1->ElStructSchema == pSS && pEl1->ElTypeNumber == C_PIV_TYPE))
      pEl1 = pEl1->ElParent;
   /* verifier si c'est bien une note ? */
   if (pEl1 == NULL || (pEl1->ElStructSchema != pSS) || (pEl1->ElTypeNumber != C_PIV_TYPE))
      return (NULL);
   else
      return (pEl1);
}				/* end proc Ind_note */


/*----------------------------------------------------------------------
   Ind_section                                                       
   retourne le numero de section ou se trouve l'element qui suit la    
   marque(debut) ou celui ou se trouve la marque-fin (si debut = FALSE)
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static int          Ind_section (PtrElement pMarque, boolean debut)
#else  /* __STDC__ */
static int          Ind_section (pMarque, debut)
PtrElement          pMarque;
boolean             debut;

#endif /* __STDC__ */
{

   PtrDocument         docsel;
   PtrElement          pEl, pEl1, pNote, pRefNote, pNote1;
   PtrReference        pRef;
   PtrExternalDoc      pDE;
   int                 numsection = 0;	/* cad avant la premiere section */
   int                 numnote;
   boolean             trouve, stop;
   PtrSSchema          pSSpr, pSSdoc, pSSnote;
   PtrPSchema          pSchP;
   int                 C_PIV_TYPE, MType2;
   PtrTabTri           pTT;

   pEl = pMarque;
   pEl1 = pEl;			/* garder un pointeur sur cette marque pour le calcul de note */
   if (pEl == NULL)
      return (0);		/* ERREUR ne devrait pas se produire */
   pSSpr = pMarque->ElStructSchema;	/* schema des extensions ExtIndex */
   if (!debut)
     {
	pEl = GetOtherPairedElement (pEl);
	if (pEl == NULL)
	   return (0);		/* ERREUR ne devrait pas se produire */
     }
   else
     {
	C_PIV_TYPE = (int) GetElemWithException (1203, pSSpr);	/* marque_debut */
	MType2 = (int) GetElemWithException (1204, pSSpr);	/* marque_fin */
	/* chercher l'element suivant cette marque de debut */
	/* qui ne soit pas une marque d'index, ni de page */
	while (pEl != NULL &&
	((pEl->ElTypeNumber == C_PIV_TYPE && pEl->ElStructSchema == pSSpr) ||
	 (pEl->ElTypeNumber == MType2 && pEl->ElStructSchema == pSSpr) ||
	 pEl->ElTypeNumber == (PageBreak + 1)))
	   pEl = pEl->ElNext;
	/* descendre sur la feuille suivant la marque de debut */
	pEl = FirstLeaf (pEl);
     }				/* end of else ! debut */
   if (pEl == NULL)
      return (0);		/* ERREUR ne devrait pas se produire */

   /* CALCULER LA SECTION */
   /* cherche en arriere le titre de section qui precede l'element */
   pSSdoc = pDocCour->DocSSchema;	/* schema de structure du document */
   C_PIV_TYPE = (int) GetElemWithException (1201, pSSdoc);
   if (C_PIV_TYPE == 0)
      return (0);
   trouve = FALSE;
   do
     {
	pEl = BackSearchTypedElem (pEl, C_PIV_TYPE, pSSdoc);
	if (pEl != NULL)
	   trouve = TRUE;
     }
   while (!trouve && pEl != NULL);
   /* compter les sections qui precedent celle-ci */
   while (pEl != NULL)
     {
	pEl = BackSearchTypedElem (pEl, C_PIV_TYPE, pSSdoc);
	numsection++;
     }
   /* FIN DU CALCUL DE SECTION */

   if (numsection == 0)
     {
	/* CALCULER LA SECTION DE LA REF A UNE NOTE */
	pEl = pEl1;		/* la marque_debut */
	/* on est peut etre dans une note ? */
	stop = FALSE;
	pNote = Ind_note (pEl);
	if (pNote == NULL)
	   stop = TRUE;		/* avant la section 1 => 0 ??? */
	else
	  {
	     /* on est dans une note */
	     /* conserver le numero de la note dans tab_note */
	     pTT = pTri[itabcle];
	     if (pTT->note == 0)
	       {
		  /* compter les notes qui precedent celle-ci */
		  pNote1 = pNote;
		  C_PIV_TYPE = pNote->ElTypeNumber;
		  pSSnote = pNote->ElStructSchema;
		  numnote = 0;
		  while (pNote1 != NULL)
		    {
		       pNote1 = BackSearchTypedElem (pNote1, C_PIV_TYPE, pSSnote);
		       numnote++;
		    }
		  pTT->note = numnote;
	       }
	     /* calculer la section de la 1e refnote */
	     pDE = NULL;
	     pRef = NextReferenceToEl (pNote, pDocCour, FALSE, NULL, &docsel, &pDE, TRUE);
	     /* la refnote est dans le document pointe par docsel */
	     /* si pDE != NULL */
	     pRefNote = (pRef == NULL) ? NULL : pRef->RdElement;
	     pDE = NULL;
	     trouve = FALSE;
	     C_PIV_TYPE = (int) GetElemWithException (1201, pSSdoc);	/* section */
	     while (pRefNote != NULL && !trouve)
	       {
		  /* cette RefNote est-elle dans le document ? */
		  pEl = BackSearchTypedElem (pRefNote, C_PIV_TYPE, pSSdoc);
		  if (pEl == NULL)
		     /* cette ref n'est pas dans le document */
		    {
		       /* passer a la reference suivante */
		       pRef = NextReferenceToEl (pNote, pDocCour, FALSE,
						 pRef, &docsel, &pDE, TRUE);
		       pRefNote = pRef->RdElement;
		    }
		  else
		     trouve = TRUE;
	       }		/* end of while */
	     if (trouve)
	       {
		  /* compter les sections qui precedent celle-ci */
		  while (pEl != NULL)
		    {
		       pEl = BackSearchTypedElem (pEl, C_PIV_TYPE, pSSdoc);
		       numsection++;
		    }
	       }		/* end of if */
	  }			/* end of else */
	/* FIN DU CALCUL DE LA SECTION DE LA REF A UNE NOTE */
     }				/* end of if (numsection == 0) */
   /* utiliser CounterVal dans absimg varpres.c */
   pSchP = NULL;		/* schema de presentation */
   return (numsection);
}				/* end proc Ind_section */


/*----------------------------------------------------------------------
   Ind_pageprec                                                      
   retourne le pointeur sur l'element marque page qui precede          
   l'element pEl                                                       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static PtrElement   Ind_pageprec (PtrElement pEl)
#else  /* __STDC__ */
static PtrElement   Ind_pageprec (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{
   PtrElement          pElPage;
   boolean             trouve;
   int                 Vue;

   Vue = 1;			/* vue contenant les ref_note ????  */
   /* cherche en arriere la marque de page qui precede l'element pEl */
   pElPage = pEl;
   if (pElPage != NULL)
     {
	trouve = FALSE;
	do
	  {
	     pElPage = BackSearchTypedElem (pElPage, PageBreak + 1, NULL);
	     if (pElPage != NULL)
	       {
		  /* on ignore les rappels de page et les pages */
		  /* qui ne concernent pas la vue */
		  if (pElPage->ElViewPSchema == Vue)
		     trouve = TRUE;
	       }
	  }
	while (!(trouve) && pElPage != NULL);
     }				/* end of if */
   return (pElPage);

}				/* end proc Ind_pageprec */


/*----------------------------------------------------------------------
   Ind_page                                                          
   retourne le numero de page ou se trouve l'element suivant la        
   marque-debut (si debut) ou celui ou se trouve la marque-fin         
   (si debut = FALSE)                                                   
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static int          Ind_page (PtrElement pMarque, boolean debut)
#else  /* __STDC__ */
static int          Ind_page (pMarque, debut)
PtrElement          pMarque;
boolean             debut;

#endif /* __STDC__ */
{

   PtrElement          pEl, pElPage, pRefNote, pNote, pNote1;
   PtrReference        pRef;
   PtrDocument         docsel;
   PtrExternalDoc      pDE;
   int                 numpage = 0;
   int                 numnote;
   boolean             trouve, stop;
   PtrSSchema          pSS, pSSnote;
   int                 Vue;
   int                 C_PIV_TYPE, MType2;
   PtrTabTri           pTT;

   pEl = pMarque;
   if (pEl == NULL)
      return (0);		/* ERREUR ne devrait pas se produire */
   pSS = pMarque->ElStructSchema;	/* schema des extensions du document */
   if (!debut)
     {
	pEl = GetOtherPairedElement (pEl);
	if (pEl == NULL)
	   return (0);		/* ERREUR ne devrait pas se produire */
     }
   else
     {
	C_PIV_TYPE = (int) GetElemWithException (1203, pSS);	/* marque_debut */
	MType2 = (int) GetElemWithException (1204, pSS);	/* marque_fin */
	/* chercher l'element suivant cette marque de debut */
	/* qui ne soit pas une marque d'index, ni de page */
	while (pEl != NULL &&
	 ((pEl->ElTypeNumber == C_PIV_TYPE && pEl->ElStructSchema == pSS) ||
	  (pEl->ElTypeNumber == MType2 && pEl->ElStructSchema == pSS) ||
	  pEl->ElTypeNumber == (PageBreak + 1)))
	   pEl = pEl->ElNext;
	/* descendre sur la feuille suivant la marque de debut */
     }				/* end of else ! debut */

   if (pEl == NULL)
      return (0);		/* ERREUR ne devrait pas se produire */

   Vue = 1;			/* vue contenant la marque d'index */
   /* cherche en arriere la marque de page qui precede l'element pEl */
   pElPage = Ind_pageprec (pEl);
   stop = FALSE;
   while (pElPage == NULL && !stop)
     {
	/* pas de marque de page precedente : on est peut-etre dans une note */
	pNote = Ind_note (pEl);
	if (pNote == NULL)
	   stop = TRUE;		/* page 1 */
	else
	  {
	     /* on est dans une note */
	     /* conserver le numero de la note dans tab_note */
	     pTT = pTri[itabcle];
	     if (pTT->note == 0)
	       {
		  /* compter les notes qui precedent celle-ci */
		  pNote1 = pNote;
		  C_PIV_TYPE = pNote->ElTypeNumber;
		  pSSnote = pNote->ElStructSchema;
		  numnote = 0;
		  while (pNote1 != NULL)
		    {
		       pNote1 = BackSearchTypedElem (pNote1, C_PIV_TYPE, pSSnote);
		       numnote++;
		    }
		  pTT->note = numnote;
	       }
	     /* calculer la page de la 1e refnote */
	     pDE = NULL;
	     pRef = NextReferenceToEl (pNote, pDocCour, FALSE, NULL, &docsel, &pDE, TRUE);
	     /* la refnote est dans le document pointe par docsel */
	     /* si pDE != NULL */
	     pRefNote = (pRef == NULL) ? NULL : pRef->RdElement;
	     trouve = FALSE;
	     while (pRefNote != NULL && !trouve)
	       {
		  /* cette RefNote est-elle dans l'arbre principal ? */
		  if (pRefNote->ElAssocNum != 0)
		    {
		       /* si non passer a la reference suivante */
		       pRef = NextReferenceToEl (pNote, pDocCour, FALSE,
						 pRef, &docsel, &pDE, TRUE);
		       if (pRef != NULL)
			  pRefNote = pRef->RdElement;
		    }
		  else
		     trouve = TRUE;
	       }		/* end of while */
	     pElPage = (trouve) ? Ind_pageprec (pRefNote) : NULL;
	     if (pRefNote == NULL)
		stop = TRUE;
	  }			/* end of else */
     }				/* end of while */
   numpage = (pElPage == NULL) ? 1 : pElPage->ElPageNumber;
   return (numpage);
}				/* end proc Ind_page */


/*----------------------------------------------------------------------
   Ind_recupcle                                                       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_recupcle (PtrElement pEl)
#else  /* __STDC__ */
static void         Ind_recupcle (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{
   PtrTextBuffer       pBuf;
   PtrElement          pElSuiv, pFeuille, pLast;
   int                 nbcar, lgcle;

   pLast = 0;
   /* met la valeur d'element pointe par pEl et ses successeurs dans Cle */
   /* parce qu'une cle est de type FillContent (donc une liste d'unites) */
   pElSuiv = pEl;
   lgcle = 0;
   do
     {
	pFeuille = FirstLeaf (pElSuiv);
	while (pFeuille != NULL && pFeuille->ElLeafType == LtText
	       && ElemIsWithinSubtree (pFeuille, pEl) == TRUE)
	  {
	     pBuf = pFeuille->ElText;
	     pLast = pFeuille;
	     nbcar = pFeuille->ElTextLength;
	     if (nbcar != 0)
	       {		/* on suppose que la taille de la cle est < Lg_Cle < LgBuffer */
		  /* le reste est perdu !!! */
		  if (lgcle + nbcar > Lg_Cle)
		     nbcar = Lg_Cle - lgcle;	/* longueur max pour le TRI */
		  strncpy ((Cle) + lgcle, pBuf->BuContent, nbcar);
		  lgcle += nbcar;
	       }
	     pFeuille = FwdSearchTypedElem (pFeuille, CharString + 1, pEl->ElStructSchema);
	  }			/* end of while pFeuille */
	pElSuiv = NextElement (pLast);
     }
   while (pElSuiv != NULL && ElemIsAnAncestor (pEl, pElSuiv));
   Cle[lgcle] = '\0';
}				/* end proc Ind_recupcle */

 /*----------------------------------------------------------------------
    Ind_textecle(numcle,pEl)                                        
    retourne la valeur de la cle de rang numcle du descripteur pEl    
   ----------------------------------------------------------------------*/

#ifdef __STDC__
char               *Ind_textecle (int numcle, PtrElement pEl)

#else  /* __STDC__ */
char               *Ind_textecle (numcle, pEl)
int                 numcle;
PtrElement          pEl;

#endif /* __STDC__ */

{
   PtrElement          pCle;
   int                 TypeCle;
   int                 i;

   pCle = pEl->ElFirstChild->ElFirstChild;
   TypeCle = pCle->ElTypeNumber;
   if (numcle > 0)
     {
	i = 0;
	while ((i < numcle)
	       && (pCle != NULL)
	       && (pCle->ElTypeNumber == TypeCle))
	  {
	     pCle = pCle->ElNext;
	     i++;
	  }
     }
   if ((pCle == NULL) || (pCle->ElTypeNumber != TypeCle))
      Cle[0] = '\0';
   else
      /* recopie toutes les feuilles dans "Cle" */
      Ind_recupcle (pCle);
   return (Cle);
}				/* end proc Ind_textecle */


/*----------------------------------------------------------------------
   Ind_semantique                                                   
   retourne la valeur de la semantique du descripteur pEl       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
char               *Ind_semantique (PtrElement pEl)
#else  /* __STDC__ */
char               *Ind_semantique (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   PtrElement          pEl1;
   int                 C_PIV_TYPE;

   C_PIV_TYPE = (int) GetElemWithException (1227, pEl->ElStructSchema);		/* Semantique */
   pEl1 = FwdSearchTypedElem (pEl, C_PIV_TYPE, pEl->ElStructSchema);
   Cle[0] = '\0';
   if (pEl1 != NULL && pEl1->ElParent == pEl)
     {
	pEl1 = FirstLeaf (pEl1);
	if (pEl1 != NULL)
	   strcpy (Cle, pEl1->ElText->BuContent);
     }
   return (Cle);

}				/* end of proc Ind_semantique */


/*----------------------------------------------------------------------
   Ind_nouvcle(pEl)                                                 
   pEl = pointeur sur le descripteur                                  
   pMq = pointeur sur la marque debut                                 
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_nouvcle (PtrElement pEl, boolean desc,
				 int pres, PtrElement pMq)
#else  /* __STDC__ */
static boolean      Ind_nouvcle (pEl, desc, pres, pMq)
PtrElement          pEl;
boolean             desc;
int                 pres;
PtrElement          pMq;

#endif /* __STDC__ */
{

   /* desc = TRUE => c'est une cle de descripteur */
   /* desc = FALSE => c'est une cle de descripteur croise */
   /* retourne Vrai si la table est saturee */

   int                 j, i = 0;
   boolean             ret = FALSE;
   boolean             erreurcle = FALSE;
   char               *cletemp;
   PtrElement          pDesc, pRenvoi;
   int                 C_PIV_TYPE;
   PtrDocument         docsel;
   DocumentIdentifier  NomDoc;
   PtrReference        pRef;
   PtrTabTri           pTT, pTT1;
   boolean             stop;
   int                 jtrouve;

   jtrouve = 0;
   /* ajoute une ligne dans le tableau pTri et l'initialise */
   pTT = (PtrTabTri) Ind_InitTabTri ();
   if (pTT == NULL)
     {
	/* debordement memoire */
	TtaDisplaySimpleMessage (INFO, INDEX, INDEX_DEBORDEMENT);
	ret = TRUE;
	return (ret);
     }
   /* allocation memoire reussie => une entree nouvelle dans pTri */
   itabcle++;
   pTri[itabcle] = pTT;
   /* initialiser cette nouvelle entree */
   pTT->refdesc = pEl;		/* le descripteur */
   pTT->doc = pDocCour;		/* utile pour le MASTER index */
   pTT->pres = pres;
   pTT->refmarque = pMq;	/* la marque debut associee */
   if (desc)
     {				/* ne concerne pas les references croisees */
	/* qui gardent tab_page[itabcle] = -1 */
	if (Iparpage)
	  {
	     pTT->page = Ind_page (pMq, TRUE);
	     pTT->pagefin = Ind_page (pMq, FALSE);
	     /* pTT->note rempli si necessaire par Ind_page */
	  }
	else
	  {
	     pTT->page = Ind_section (pMq, TRUE);
	     pTT->pagefin = Ind_section (pMq, FALSE);
	     /* pTT->note rempli si necessaire par Ind_section */
	  }
     }
   else
     {
	/* mettre dans tab_pagefin l'indice dans tab_  du renvoi */
	/* pour permettre ensuite le tri des renvois d'une meme entree */
	C_PIV_TYPE = (int) GetElemWithException (1230, pEl->ElStructSchema);
	pRenvoi = FwdSearchTypedElem (pEl, C_PIV_TYPE, pEl->ElStructSchema);
	/* on suppose que les croises sont aussi dans pDocCour */
	pRef = pRenvoi->ElReference;	/* Cles de RefDesc (9) */
	pDesc = ReferredElement (pRef, &NomDoc, &docsel);
	if (pDesc == NULL)
	  {
	     /* un renvoi dans une ref croisee est vide */
	     TtaDisplaySimpleMessage (INFO, INDEX, INDEX_CROISES);
	     /* ignorer cette RefCroisee */
	     erreurcle = TRUE;
	  }
	else
	  {
	     pDesc = pDesc->ElParent;
	     stop = FALSE;
	     for (j = 0; (j < itabcle) && (!stop); j++)
	       {
		  pTT1 = pTri[j];
		  if (pTT1->refdesc == pDesc)
		    {
		       stop = TRUE;
		       jtrouve = j;
		    }		/* end of if */
	       }
	     if (j >= itabcle)
		/* renvoi vers une entree hors de cette table */
		/* il faudra supprimer ce renvoi invalide */
		erreurcle = TRUE;
	     else
		pTT->pagefin = jtrouve;
	  }			/* end of else */
     }
   for (i = 0; i < MaxNiveau; i++)
     {
	cletemp = Ind_textecle (i, pEl);
	strcpy (pTT->cle[i], cletemp);
     }
   /* recopier aussi la semantique, comme cle de tri de niveau MaxNiveau */
   cletemp = Ind_semantique (pEl);
   strcpy (pTT->cle[MaxNiveau], cletemp);
   if (erreurcle == TRUE)
      /* supprimer cette cle invalide */
      itabcle--;
   return (ret);

}				/* end proc Ind_nouvcle */


/*----------------------------------------------------------------------
   Ind_verifsujet                                                
   compare le sujet du descripteur ou du croise             
   avec les sujets definis dans Def_table_index             
   -  retourne -1 si le descripteur ne convient pas            
   -  retourne la valeur de l'attribut Pres_Sujet,  si le      
   sujet convient (1,2,3 ou 4) 1 = par defaut en romain     
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static int          Ind_verifsujet (PtrElement pEl)
#else  /* __STDC__ */
static int          Ind_verifsujet (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   int                 bon = -1;
   int                 TypeSujet;
   PtrElement          pEl1, pSujet;
   PtrAttribute        pAttr;
   int                 attr;
   boolean             attrtrouve = FALSE;

   /* rechercher le sujet de ce descripteur */
   TypeSujet = (int) GetElemWithException (1223, pEl->ElStructSchema);
   pEl1 = FwdSearchTypedElem (pEl, TypeSujet, pEl->ElStructSchema);
   if (ElemIsWithinSubtree (pEl1, pEl) != TRUE)
      pEl1 = NULL;

   /* le comparer avec les sujets de pDefTable */
   /* s'il existe */
   if (pDefTable->ElFirstChild->ElNext != NULL)
     {
	pSujet = pDefTable->ElFirstChild->ElNext->ElFirstChild;
	if ((pSujet != NULL) && (FirstLeaf (pSujet)->ElVolume != 0))
	  {
	     while ((pSujet != NULL) && (bon == -1))
	       {
		  if (!Ind_differtext (pEl1, pSujet))
		    {
/* test a faire */
		       /* recuperer la valeur de l'attribut Pres_Sujet de pSujet */
		       attr = (int) GetAttrWithException (1261, pSujet->ElStructSchema);
		       pAttr = pSujet->ElFirstAttr;
		       /* parcours les atributs de l'element */
		       while (!attrtrouve && pAttr != NULL)
			  if (pAttr->AeAttrNum == attr
			  && pAttr->AeAttrSSchema == pSujet->ElStructSchema)
			     attrtrouve = TRUE;
			  else
			     pAttr = pAttr->AeNext;
		       bon = (attrtrouve) ? pAttr->AeAttrValue : 1;
		    }
		  else
		     pSujet = pSujet->ElNext;
	       }		/* end of while */
	  }
	else
	   bon = 1;		/* tous => pas de controle et presentation en romain */
     }
   else
      bon = 1;			/* pas de sujet precise pour cette table => tous bons */
   return (bon);
}				/* end of proc Ind_verifsujet */

/*----------------------------------------------------------------------
    Ind_egalcle                                                  
   ----------------------------------------------------------------------*/

#ifdef __STDC__
static boolean      Ind_egalcle (int ind1, int ind2)

#else  /* __STDC__ */
static boolean      Ind_egalcle (ind1, ind2)
int                 ind1;
int                 ind2;

#endif /* __STDC__ */

{
   int                 j, num1, num2;
   int                 differ = 0;
   boolean             ret = FALSE;
   PtrTabTri           pTT1, pTT2, p1, p2;

   pTT1 = pTri[ind1];
   pTT2 = pTri[ind2];
   if (pTT1->page == -1)
     {
	for (j = 0; (differ == 0 && j <= MaxNiveau); j++)
	   /* = 0 si les chaines sont egales */
	   differ = codecmp (pTT1->cle[j], pTT2->cle[j], 1);
	if (differ == 0)
	  {
	     num1 = pTT1->pagefin;
	     num2 = pTT2->pagefin;
	     if (num1 != num2)
	       {
		  p1 = pTri[num1];
		  p2 = pTri[num2];
		  /* comparer les cles des ref croisees */
		  for (j = 0; (differ == 0 && j <= MaxNiveau); j++)
		     /* = 0 si les chaines sont egales */
		     differ = codecmp (p1->cle[j], p2->cle[j], 1);
	       }
	     if (differ == 0)
		ret = TRUE;	/* ind1 et ind2 sont des ref croisees identiques */
	  }
     }				/* end of if */
   return (ret);
}				/* end of proc Ind_egalcle */


/*----------------------------------------------------------------------
   Ind_traitedesc                                                
   retrouve TOUTES les marques associees                           
   traite un descripteur si desc = TRUE                            
   traite un descripteur croise' si desc = FALSE                   
   retourne Vrai si la table est saturee                           
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_traitedesc (PtrElement pEl, boolean desc)
#else  /* __STDC__ */
static boolean      Ind_traitedesc (pEl, desc)
PtrElement          pEl;
boolean             desc;

#endif /* __STDC__ */
{

   PtrElement          pCle;
   PtrElement          pMarque;
   int                 i, presterme;
   boolean             ret = FALSE;

   pCle = pEl->ElFirstChild->ElFirstChild;	/* Descripteur->Cles->Cle */
   Ind_recupcle (pCle);
   /* verifier si la cle est definie */
   presterme = Ind_verifsujet (pEl);
   if (Cle[0] != '\0' && (presterme != -1))
     {
	if (desc == TRUE)
	  {
	     /* verifier si le descripteur et lie a une marque debut */
	     pMarque = NULL;
	     /* rechercher la premiere marque associee a ce descripteur */
	     pMarque = Ind_marquesuivante (pEl, pMarque);
	     if (pMarque == NULL)
	       {
		  /* AVERTIR de la non utilisation d'un descripteur */
		  TtaDisplaySimpleMessage (INFO, INDEX, INDEX_NO_MARK);
	       }
	     else
	       {
		  /* creer une entree dans la table pour chaque marque */
		  /* tant que la table n'est pas saturee */
		  ret = FALSE;
		  while (pMarque != NULL && !ret)
		    {
		       ret = Ind_nouvcle (pEl, desc, presterme, pMarque);
		       pMarque = Ind_marquesuivante (pEl, pMarque);
		    }
	       }		/* end of else */
	  }			/* end of if */
	else
	   /* creer une entree dans la table pour une reference croisee */
	   ret = Ind_nouvcle (pEl, desc, presterme, NULL);
     }				/* end of if */
   if (!ret && !desc)
     {
	/* si cette ref croisee existait deja : la supprimer */
	for (i = 0; (i < itabcle && !Ind_egalcle (i, itabcle)); i++) ;
	if (i < itabcle)	/* une meme cle a ete trouvee */
	   itabcle--;		/* supprimer la derniere cle de tab_cle */
     }
   return (ret);

}				/* end proc Ind_traitedesc */


/*----------------------------------------------------------------------
   Ind_tousdescdoc                                                    
   examine successivement tous les descripteurs              
   du document pDocCour et les traite                        
  ----------------------------------------------------------------------*/
static void         Ind_tousdescdoc ()
{

   PtrElement          pEl, pMarque;
   int                 Typedesc;
   PtrSSchema          pSS;
   boolean             sature = FALSE;

   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDocCour), "ExtIndex");
   if (pSS == NULL)
      return;
   Typedesc = (int) GetElemWithException (1214, pSS);
   pEl = FirstAssociatedElement (pDocCour, Typedesc, pSS);
   while ((pEl != NULL) && (!sature))
     {
	/* pointeur sur RefDesc dans arbre associe */
	/* verifier si le descripteur et lie a une marque debut */
	pMarque = Ind_marquesuivante (pEl, NULL);
	if (pMarque == NULL || (Ind_dansdoc (pMarque, pDocCour) == 0))
	  {
	     /* AVERTIR de la non utilisation d'un descripteur */
	     TtaDisplaySimpleMessage (INFO, INDEX, INDEX_NO_MARK);
	     /* passer au descripteur suivant */
	     pEl = pEl->ElNext;
	  }
	else
	  {
	     /* pointeur sur RefDesc dans arbre associe */
	     sature = Ind_traitedesc (pEl, TRUE);
	     /* cherche le prochain element associe de type descripteur */
	     pEl = pEl->ElNext;
	  }
	if (pEl != NULL && pEl->ElTypeNumber != Typedesc)
	   /* sautant max 1 saut de page */
	   pEl = pEl->ElNext;
     }				/* end of while */

}				/* end proc Ind_tousdescdoc */


/*----------------------------------------------------------------------
   Ind_VolSuivant                                                   
   retourne le pointeur sur le document suivant pvol dans la      
   liste de documents contenue dans le MIndex pdoc                
   si pvol est NULL, retourne le premier document designe dans pdoc  
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static PtrDocument  Ind_VolSuivant (PtrDocument pvol)
#else  /* __STDC__ */
static PtrDocument  Ind_VolSuivant (pvol)
PtrDocument         pvol;

#endif /* __STDC__ */
{

   DocumentIdentifier  NomDoc;
   PtrElement          pEl, pEl1;
   int                 TypeVol;
   PtrDocument         docsel = NULL;
   boolean             stop = FALSE;
   PtrSSchema          pSS;
   boolean             ok;

   NomDoc[0] = '\0';

   pSS = pDocu->DocSSchema;
   TypeVol = (int) GetElemWithException (1281, pSS);	/* Volume appartenant a un dossier */
   if (pvol == NULL)
      stop = TRUE;		/* arret au premier document trouve */
   pEl = FwdSearchTypedElem (pDocu->DocRootElement, TypeVol, pSS);
   if (pEl != NULL && pEl->ElFirstChild && pEl->ElFirstChild->ElFirstChild != NULL
       && pEl->ElFirstChild->ElFirstChild->ElReference != NULL)
      pEl1 = ReferredElement (pEl->ElFirstChild->ElFirstChild->ElReference, &NomDoc, &docsel);
   else
      stop = TRUE;
   while (!stop)
      if (docsel != pvol)
	{
	   /* chercher le volume suivant */
	   pEl = FwdSearchTypedElem (pEl, TypeVol, pSS);
	   if (pEl != NULL && pEl->ElFirstChild && pEl->ElFirstChild->ElFirstChild != NULL
	       && pEl->ElFirstChild->ElFirstChild->ElReference != NULL)
	      pEl1 = ReferredElement (pEl->ElFirstChild->ElFirstChild->ElReference, &NomDoc, &docsel);
	   else
	     {
		NomDoc[0] = '\0';
		docsel = NULL;
	     }
	}
      else
	{
	   stop = TRUE;
	   /* enfin, le document suivant sera le bon */
	   pEl = FwdSearchTypedElem (pEl, TypeVol, pSS);
	   if (pEl != NULL && pEl->ElFirstChild && pEl->ElFirstChild->ElFirstChild != NULL
	       && pEl->ElFirstChild->ElFirstChild->ElReference != NULL)
	      pEl1 = ReferredElement (pEl->ElFirstChild->ElFirstChild->ElReference, &NomDoc, &docsel);
	   else
	     {
		NomDoc[0] = '\0';
		docsel = NULL;
	     }
	}			/* end of else */

   if (NomDoc[0] != '\0' && docsel == NULL)
     {
	CreateDocument (&docsel);
	if (docsel != NULL)
	  {			/* charger le document SANS ouvrir de vue sur l'ecran */
	     GetDocIdent (&docsel->DocIdent, NomDoc);
	     ok = OpenDocument (NomDoc, docsel, TRUE, FALSE, NULL, FALSE);
	     if (!ok)
	       {
		  UnloadDocument (&docsel);
		  TtaDisplayMessage (INFO, TtaGetMessage (INDEX, INDEX_NO_DOC), NomDoc);
	       }
	  }
     }				/* end of if */
   return (docsel);
}				/* end proc Ind_VolSuivant */

#ifdef IXA
/*----------------------------------------------------------------------
   Ind_selectdesc                                                
   retourne TRUE si le descripteur est concerne par cette table    
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static boolean      Ind_selectdesc (PtrElement pEl)
#else  /* __STDC__ */
static boolean      Ind_selectdesc (pEl)
PtrElement          pEl;

#endif /* __STDC__ */
{

   PtrElement          pCle;

   pCle = pEl->ElFirstChild->ElFirstChild;
   Ind_recupcle (pCle);
   if (Cle[0] != '\0' && (Ind_verifsujet (pEl)) != -1)
      return (TRUE);
   else
      return (FALSE);

}				/* end of proc Ind_selectdesc */
#endif

/*----------------------------------------------------------------------
   Ind_inittable                                                     
   initialise Iparpage = TRUE si les ref sont pa  page               
   initialise Igroupe = TRUE si Pres_groupe est visible              
   rempli Ialgo en fonction de l'attribut Tri                        
   rempli Ipres en fonction de l'attribut Pres                       
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                Ind_inittable (int num)
#else  /* __STDC__ */
void                Ind_inittable (num)
int                 num;

#endif /* __STDC__ */
{

   int                 attr;
   PtrElement          pEl;
   PtrSSchema          pSS;
   PtrAttribute        pAttr;
   boolean             attrtrouve;

   pAttr = NULL;
   /* verifie si des options decrivent cette table */
   pEl = Ind_table (num);
   if (pEl != NULL)
     {
	pSS = pEl->ElStructSchema;

	/* recopier les options utiles a la construction */
	/* dans Ialgo, Iparpage, Ipres, Igroupe */

	/* ATTRIBUT PRES_RENVOI */
	attr = (int) GetAttrWithException (1263, pSS);
	/* recuperer la valeur de l'attribut Pres_Renvoi de cette table */
	attrtrouve = FALSE;
	if (pEl->ElFirstChild != NULL)
	  {
	     pAttr = pEl->ElFirstChild->ElFirstAttr;
	     while (!attrtrouve && pAttr != NULL)
		if (pAttr->AeAttrNum == attr
		    && pAttr->AeAttrSSchema == pSS)
		   attrtrouve = TRUE;
		else
		   pAttr = pAttr->AeNext;
	  }
	/* Iparpage = TRUE si presentation par page (valeur par defaut) */
	Iparpage = (attrtrouve && pAttr->AeAttrValue == 2) ? FALSE : TRUE;

	/* ATTRIBUT TRI */
	attr = GetAttrWithException (1262, pSS);
	/* recuperer la valeur de l'attribut Tri de cette table */
	attrtrouve = FALSE;
	if (pEl->ElFirstChild != NULL)
	  {
	     pAttr = pEl->ElFirstChild->ElFirstAttr;
	     while (!attrtrouve && pAttr != NULL)
		if (pAttr->AeAttrNum == attr
		    && pAttr->AeAttrSSchema == pSS)
		   attrtrouve = TRUE;
		else
		   pAttr = pAttr->AeNext;
	  }
	/* Ialgo = valeur de l'attribut Tri ou par defaut = 0 */
	Ialgo = (attrtrouve) ? pAttr->AeAttrValue : 0;

	/* ATTRIBUT PRES */
	attr = GetAttrWithException (1267, pSS);
	/* recuperer la valeur de l'attribut Tri de cette table */
	attrtrouve = FALSE;
	if (pEl->ElFirstChild != NULL)
	  {
	     pAttr = pEl->ElFirstChild->ElFirstAttr;
	     while (!attrtrouve && pAttr != NULL)
		if (pAttr->AeAttrNum == attr
		    && pAttr->AeAttrSSchema == pSS)
		   attrtrouve = TRUE;
		else
		   pAttr = pAttr->AeNext;
	  }
	/* Ipres = valeur de l'attribut Pres ou par defaut = 0 */
	Ipres = (attrtrouve) ? pAttr->AeAttrValue : 0;

	/* ATTRIBUT PRES_GROUPE */
	attr = GetAttrWithException (1265, pSS);
	/* recuperer la valeur de l'attribut Pres_Groupe de cette table */
	attrtrouve = FALSE;
	if (pEl->ElFirstChild != NULL)
	  {
	     pAttr = pEl->ElFirstChild->ElFirstAttr;
	     while (!attrtrouve && pAttr != NULL)
		if (pAttr->AeAttrNum == attr
		    && pAttr->AeAttrSSchema == pSS)
		   attrtrouve = TRUE;
		else
		   pAttr = pAttr->AeNext;
	  }
	/* Igroupe = valeur de l'attribut Pres_Groupe (par defaut = visible) */
	Igroupe = (attrtrouve && pAttr->AeAttrValue == 2) ? FALSE : TRUE;
	/* initialiser le pointeur vers la definition de cette table */
	pDefTable = pEl;
	itabcle = -1;		/* tables pTri et tab_ind initialement vides */
	/* tab_ind sera allouee par Ind_tritable */
     }

}				/* end proc Ind_inittable */


/*----------------------------------------------------------------------
   Ind_tousdesc                                                      
   examine successivement tous les descripteurs             
   et les traite                                            
   pDocu pointe sur le document dans lequel seront les index  
   pDocCour pointera sur le document COURANT traite'          
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_tousdesc ()
#else  /* __STDC__ */
int                 Ind_tousdesc ()
#endif				/* __STDC__ */
{

   /* S'agit-il de construire un index ou un MASTER index ? */
   if (!TypeHasException (1280, pDocu->DocRootElement->ElTypeNumber, pDocu->DocSSchema))
      /* c'est un simple INDEX */
     {
	pDocCour = pDocu;	/* c'est plus clair comme ca ! */
	Ind_tousdescdoc ();
     }
   else
     {
	/* c'est un MASTER index */
	/* rechercher TOUS les desc de TOUS les documents concernes */
	pDocCour = Ind_VolSuivant (NULL);
	while (pDocCour != NULL)
	  {
	     Ind_tousdescdoc ();
	     pDocCour = Ind_VolSuivant (pDocCour);
	  }
     }				/* end of else */
   return (itabcle);

}				/* end proc Ind_tousdesc */


 /*----------------------------------------------------------------------
    Ind_touscroisdoc                                                  
    examine successivement tous les descripteurs             
    du document pDocCour et les traite                       
   ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_touscroisdoc ()
#else  /* __STDC__ */
static void         Ind_touscroisdoc ()
#endif				/* __STDC__ */
{

   PtrElement          pEl;
   int                 Typedesc;
   boolean             sature = FALSE;
   PtrSSchema          pSS;

   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDocCour), "ExtIndex");
/*BUG */ if (pSS == NULL)
/*BUG */ return;
   Typedesc = (int) GetElemWithException (1215, pSS);
   pEl = FirstAssociatedElement (pDocCour, Typedesc, pSS);
   while ((pEl != NULL) && (!sature))
     {
	/* pointeur sur RefCrois dans arbre associe */
	sature = Ind_traitedesc (pEl, FALSE);
	/* cherche le prochain element associe de type croise */
	pEl = pEl->ElNext;
	if (pEl != NULL && pEl->ElTypeNumber != Typedesc)
	   pEl = pEl->ElNext;
     }				/* end of while */
}				/* end proc Ind_touscroisdoc */


/*----------------------------------------------------------------------
   Ind_touscrois                                                     
   examine successivement tous les croises                  
   et les traite (pDocCour pointe sur le document COURANT)  
  ----------------------------------------------------------------------*/
#ifdef __STDC__
int                 Ind_touscroise ()
#else  /* __STDC__ */
int                 Ind_touscroise ()
#endif				/* __STDC__ */
{

   /* S'agit-il de construire un index ou un MASTER index ? */
   if (!TypeHasException (1280, pDocu->DocRootElement->ElTypeNumber, pDocu->DocSSchema))
      /* c'est un simple INDEX */
     {
	pDocCour = pDocu;	/* c'est plus sur comme cela ! */
	Ind_touscroisdoc ();
     }
   else
     {
	/* c'est un MASTER index */
	/* rechercher TOUS les desc de TOUS les documents concernes */
	pDocCour = Ind_VolSuivant (NULL);
	while (pDocCour != NULL)
	  {
	     Ind_touscroisdoc ();
	     pDocCour = Ind_VolSuivant (pDocCour);
	  }
     }				/* end of else */
   return (itabcle);

}				/* end proc Ind_touscroise */
