/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

#include "constmedia.h"
#include "typemedia.h"

#include "applicationapi_f.h"
#include "tree_f.h"
#include "structcreation_f.h"
#include "exceptions_f.h"
#include "structschema_f.h"

/*----------------------------------------------------------------------
   ChargerIndexExt charge le schema d'extension de l'application     
   index. Cette procedure est utilisee par pivlec    
   et indmenu.c. Elle est placee dans un module      
   separe de indcree pour eviter les problemes       
   d'edition de liens du print (qui utilise pivlec)  
  ----------------------------------------------------------------------*/
#ifdef __STDC__
void                ChargerIndexExt (PtrDocument pDoc)
#else  /* __STDC__ */
void                ChargerIndexExt (pDoc)
PtrDocument         pDoc;

#endif /* __STDC__ */
{
   PtrSSchema          pSS;
   PtrElement          pEl1;

   /* cherche si l'arbre d'elements associes Tables_Index existe */
   pSS = (PtrSSchema) TtaGetSchemaExtension (IdentDocument (pDoc), "ExtIndex");
   if (pSS != NULL)
     {
	pEl1 = FirstAssociatedElement (pDoc, GetElemWithException (1213, pSS), pSS);
	if (pEl1 != NULL)
	   if (pEl1->ElParent != NULL)
	      /* met l'arbre d'elements associes Tables_Index en Read Only */
	      pEl1->ElParent->ElAccess = AccessReadOnly;
     }
}
