/****************************************************************************
** $Id: qgmanagr.h,v 2.4 1996/12/10 21:23:50 agulbra Exp $
**
** Definition of QGManager class (workhorse for QLayout classes)
**
** Created : 960406
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.2.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the one in the commercial distribution of
** Qt only by this comment.)
**
*****************************************************************************/

#ifndef QGMANAGR_H
#define QGMANAGR_H

#include "qintdict.h"
#include "qwidget.h"


class QChain;
struct QGManagerData;

class QGManager : public QObject
{
    Q_OBJECT
public:
    QGManager( QWidget *parent, const char *name=0 );
    ~QGManager();

    void setBorder( int b ) { border = b; }

    enum Direction { LeftToRight, RightToLeft, Down, Up };
    enum { unlimited = QCOORD_MAX };

    QChain *newSerChain( Direction );
    QChain *newParChain( Direction );

    bool add( QChain *destination, QChain *source, int stretch = 0 );
    bool addWidget( QChain *, QWidget *, int stretch = 0 );
    bool addSpacing( QChain *, int minSize, int stretch = 0, int maxSize = unlimited );

    bool addBranch( QChain *destination, QChain *branch, int fromIndex,
		    int toIndex );
    void setStretch( QChain*, int );
    bool activate();

    void freeze( int w = 0, int h = 0 );

    QChain *xChain() {	return xC; }
    QChain *yChain() {	return yC; }

    void  setMenuBar( QWidget *w ) { menuBar = w; }

    QWidget *mainWidget() { return main; }

protected:
    bool  eventFilter( QObject *, QEvent * );

private:
    int border;

    void      resizeHandle( QWidget *, const QSize & );
    void      resizeAll();

    QChain *xC;
    QChain *yC;
    QWidget *main;
    QWidget *menuBar;
    int	    menuBarHeight;
    QGManagerData *extraData;
    bool frozen;

private:	// Disabled copy constructor and operator=
    QGManager( const QGManager & ) {}
    QGManager &operator=( const QGManager & ) { return *this; }
};


#endif // QGMANAGR_H
